/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.comparator;

import jakarta.annotation.Priority;
import java.util.Comparator;
import java.util.ServiceLoader;
import java.util.function.Function;

public class PriorityComparator<T>
implements Comparator<T> {
    private final Function<T, Priority> f_function;
    private final int f_nDefault;

    public PriorityComparator(Function<T, Priority> function, int nDefault) {
        this.f_function = function;
        this.f_nDefault = nDefault;
    }

    @Override
    public int compare(T o1, T o2) {
        Priority priority1 = this.f_function.apply(o1);
        int nValue1 = priority1 == null ? this.f_nDefault : priority1.value();
        Priority priority2 = this.f_function.apply(o2);
        int nValue2 = priority2 == null ? this.f_nDefault : priority2.value();
        return Integer.compare(nValue1, nValue2);
    }

    public static <S> Comparator<ServiceLoader.Provider<S>> forServiceLoader() {
        try {
            return new PriorityComparator<ServiceLoader.Provider<S>>(p -> p.type().getAnnotation(Priority.class), 0);
        }
        catch (IllegalAccessError | NoClassDefFoundError e) {
            return (o1, o2) -> 0;
        }
    }

    @Override
    public Comparator<T> reversed() {
        return Comparator.super.reversed();
    }
}

