/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.asm;

import com.oracle.coherence.common.base.Logger;
import java.io.IOException;
import java.io.InputStream;

public abstract class BaseClassReaderInternal<RT, CVT> {
    private static final int MAX_MAJOR_VERSION = 66;
    protected byte[] m_abBytes;

    public BaseClassReaderInternal(InputStream streamIn) throws IOException {
        this(streamIn.readAllBytes());
    }

    public BaseClassReaderInternal(byte[] abBytes) {
        this.m_abBytes = abBytes;
    }

    protected abstract RT createReader(byte[] var1);

    protected abstract void accept(RT var1, CVT var2, int var3);

    public void accept(CVT classVisitor, int nParsingOptions) {
        byte[] abBytes = this.m_abBytes;
        int nOriginalVersion = BaseClassReaderInternal.getMajorVersion(abBytes);
        boolean fRevertVersion = false;
        if (nOriginalVersion > 66) {
            BaseClassReaderInternal.setMajorVersion(66, abBytes);
            fRevertVersion = true;
            Logger.warn(() -> String.format("Unsupported class file major version " + nOriginalVersion, new Object[0]));
        }
        RT classReader = this.createReader(abBytes);
        if (fRevertVersion) {
            BaseClassReaderInternal.setMajorVersion(nOriginalVersion, abBytes);
        }
        this.accept(classReader, classVisitor, nParsingOptions);
    }

    protected static void setMajorVersion(int nMajorVersion, byte[] abBytes) {
        abBytes[6] = (byte)(nMajorVersion >>> 8);
        abBytes[7] = (byte)nMajorVersion;
    }

    protected static int getMajorVersion(byte[] abBytes) {
        return (abBytes[6] & 0xFF) << 8 | abBytes[7] & 0xFF;
    }
}

