/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.aggregator;

import com.tangosol.io.ByteArrayReadBuffer;
import com.tangosol.io.ByteArrayWriteBuffer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.aggregator.AbstractDoubleAggregator;
import java.io.IOException;

public class DoubleAverage<T>
extends AbstractDoubleAggregator<T> {
    public DoubleAverage() {
    }

    public DoubleAverage(ValueExtractor<? super T, ? extends Number> extractor) {
        super(extractor);
    }

    public DoubleAverage(String sMethod) {
        super(sMethod);
    }

    @Override
    public InvocableMap.StreamingAggregator<Object, Object, Object, Double> supply() {
        return new DoubleAverage(this.getValueExtractor());
    }

    @Override
    public int characteristics() {
        return 33;
    }

    @Override
    protected void init(boolean fFinal) {
        super.init(fFinal);
        this.m_dflResult = 0.0;
    }

    @Override
    protected void process(Object o, boolean fFinal) {
        if (o != null) {
            if (fFinal) {
                try {
                    ByteArrayReadBuffer buff = new ByteArrayReadBuffer((byte[])o);
                    ReadBuffer.BufferInput in = buff.getBufferInput();
                    this.m_count += in.readInt();
                    this.m_dflResult += in.readDouble();
                }
                catch (IOException e) {
                    throw DoubleAverage.ensureRuntimeException(e);
                }
            } else {
                ++this.m_count;
                this.m_dflResult += ((Number)o).doubleValue();
            }
        }
    }

    @Override
    protected Object finalizeResult(boolean fFinal) {
        int c = this.m_count;
        double dfl = this.m_dflResult;
        if (fFinal) {
            return c == 0 ? null : Double.valueOf(dfl / (double)c);
        }
        try {
            ByteArrayWriteBuffer buff = new ByteArrayWriteBuffer(12);
            WriteBuffer.BufferOutput out = buff.getBufferOutput();
            out.writeInt(c);
            out.writeDouble(dfl);
            return buff.getRawByteArray();
        }
        catch (IOException e) {
            throw DoubleAverage.ensureRuntimeException(e);
        }
    }
}

