/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.aggregator;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.InvocableMap;
import jakarta.json.bind.annotation.JsonbProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class CompositeAggregator<K, V>
extends ExternalizableHelper
implements InvocableMap.StreamingAggregator<K, V, Object, List>,
ExternalizableLite,
PortableObject {
    @JsonbProperty(value="aggregators")
    protected InvocableMap.EntryAggregator[] m_aAggregator;
    protected transient boolean m_fInit;
    protected transient boolean m_fStreaming;
    protected transient boolean m_fParallel;
    protected transient Set m_setEntries;
    protected transient List[] m_aParallelResults;

    public CompositeAggregator() {
    }

    public CompositeAggregator(InvocableMap.EntryAggregator[] aAggregator) {
        Objects.requireNonNull(aAggregator);
        this.m_aAggregator = aAggregator;
    }

    @Override
    public List aggregate(Set setEntries) {
        InvocableMap.EntryAggregator[] aAggregator = this.m_aAggregator;
        int cAggregators = aAggregator.length;
        Object[] aoResult = new Object[cAggregators];
        for (int i = 0; i < cAggregators; ++i) {
            aoResult[i] = aAggregator[i].aggregate(setEntries);
        }
        return new ImmutableArrayList(aoResult);
    }

    @Override
    public InvocableMap.StreamingAggregator<K, V, Object, List> supply() {
        this.ensureInitialized();
        if (this.m_fStreaming) {
            InvocableMap.EntryAggregator[] aCopy = (InvocableMap.StreamingAggregator[])Arrays.stream(this.m_aAggregator).map(aggr -> ((InvocableMap.StreamingAggregator)aggr).supply()).toArray(InvocableMap.StreamingAggregator[]::new);
            return CompositeAggregator.createInstance(aCopy);
        }
        return CompositeAggregator.createInstance(this.m_aAggregator);
    }

    @Override
    public boolean accumulate(InvocableMap.Entry entry) {
        this.ensureInitialized();
        if (this.m_fStreaming) {
            InvocableMap.EntryAggregator[] aAggregator = this.m_aAggregator;
            for (int i = 0; i < aAggregator.length; ++i) {
                ((InvocableMap.StreamingAggregator)aAggregator[i]).accumulate(entry);
            }
        } else {
            this.m_setEntries.add(entry);
        }
        return true;
    }

    @Override
    public boolean combine(Object oResultPart) {
        this.ensureInitialized();
        InvocableMap.EntryAggregator[] aAggregator = this.m_aAggregator;
        int cAggregators = aAggregator.length;
        if (this.m_fStreaming) {
            List aPartialResults = (List)oResultPart;
            int len = aPartialResults.size();
            for (int i = 0; i < len; ++i) {
                ((InvocableMap.StreamingAggregator)aAggregator[i]).combine(aPartialResults.get(i));
            }
        } else if (this.m_fParallel) {
            if (!(oResultPart instanceof List)) {
                throw new IllegalStateException("Expected result type: java.util.List; actual type: " + oResultPart.getClass().getName());
            }
            List listResultPart = (List)oResultPart;
            if (listResultPart.size() != cAggregators) {
                throw new IllegalStateException("Expected result list size: " + cAggregators + "; actual size: " + listResultPart.size());
            }
            for (int i = 0; i < cAggregators; ++i) {
                this.m_aParallelResults[i].add(listResultPart.get(i));
            }
        } else {
            this.m_setEntries.addAll((Set)oResultPart);
        }
        return true;
    }

    @Override
    public Object getPartialResult() {
        this.ensureInitialized();
        InvocableMap.EntryAggregator[] aAggregator = this.m_aAggregator;
        int cAggregators = aAggregator.length;
        if (this.m_fStreaming) {
            ArrayList aPartialResults = new ArrayList(cAggregators);
            for (int i = 0; i < cAggregators; ++i) {
                aPartialResults.add(((InvocableMap.StreamingAggregator)aAggregator[i]).getPartialResult());
            }
            return aPartialResults;
        }
        if (this.m_fParallel) {
            return this.aggregate(this.m_setEntries);
        }
        return this.m_setEntries;
    }

    @Override
    public List finalizeResult() {
        this.ensureInitialized();
        InvocableMap.EntryAggregator[] aAggregator = this.m_aAggregator;
        int cAggregators = aAggregator.length;
        if (this.m_fStreaming) {
            Object[] aoResult = new Object[cAggregators];
            for (int i = 0; i < cAggregators; ++i) {
                aoResult[i] = ((InvocableMap.StreamingAggregator)aAggregator[i]).finalizeResult();
            }
            return new ImmutableArrayList(aoResult);
        }
        if (this.m_fParallel) {
            Object[] aoResult = new Object[cAggregators];
            for (int i = 0; i < cAggregators; ++i) {
                aoResult[i] = ((InvocableMap.ParallelAwareAggregator)aAggregator[i]).aggregateResults(this.m_aParallelResults[i]);
            }
            return new ImmutableArrayList(aoResult);
        }
        return this.aggregate(this.m_setEntries);
    }

    @Override
    public int characteristics() {
        this.ensureInitialized();
        return this.m_fStreaming ? 1 : 17;
    }

    protected void ensureInitialized() {
        if (!this.m_fInit) {
            InvocableMap.EntryAggregator[] aAggregator = this.m_aAggregator;
            int cAggregators = aAggregator.length;
            boolean fStreaming = true;
            for (int i = 0; i < cAggregators; ++i) {
                if (aAggregator[i] instanceof InvocableMap.StreamingAggregator) continue;
                fStreaming = false;
                break;
            }
            this.m_fStreaming = fStreaming;
            if (!fStreaming) {
                this.m_setEntries = new HashSet();
                boolean fParallel = true;
                for (int i = 0; i < cAggregators; ++i) {
                    if (aAggregator[i] instanceof InvocableMap.ParallelAwareAggregator) continue;
                    fParallel = false;
                    break;
                }
                this.m_fParallel = fParallel;
                if (fParallel) {
                    List[] aParallelResults = new List[cAggregators];
                    for (int i = 0; i < aParallelResults.length; ++i) {
                        aParallelResults[i] = new ArrayList();
                    }
                    this.m_aParallelResults = aParallelResults;
                }
            }
            this.m_fInit = true;
        }
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        int cAggregators = CompositeAggregator.readInt(in);
        CompositeAggregator.azzert(cAggregators < 16384, "Unexpected number of chained aggregators");
        InvocableMap.EntryAggregator[] aAggregator = new InvocableMap.EntryAggregator[cAggregators];
        for (int i = 0; i < cAggregators; ++i) {
            aAggregator[i] = (InvocableMap.EntryAggregator)CompositeAggregator.readObject(in);
        }
        this.m_aAggregator = aAggregator;
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        InvocableMap.EntryAggregator[] aAggregator = this.m_aAggregator;
        int cAggregators = aAggregator.length;
        CompositeAggregator.writeInt(out, cAggregators);
        for (int i = 0; i < cAggregators; ++i) {
            CompositeAggregator.writeObject(out, aAggregator[i]);
        }
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_aAggregator = (InvocableMap.EntryAggregator[])in.readArray(0, InvocableMap.EntryAggregator[]::new);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObjectArray(0, this.m_aAggregator);
    }

    public InvocableMap.EntryAggregator[] getAggregators() {
        return this.m_aAggregator;
    }

    public boolean equals(Object o) {
        if (o instanceof CompositeAggregator) {
            CompositeAggregator that = (CompositeAggregator)o;
            return CompositeAggregator.equalsDeep(this.m_aAggregator, that.m_aAggregator);
        }
        return false;
    }

    public int hashCode() {
        InvocableMap.EntryAggregator[] aAggregator = this.m_aAggregator;
        int iHash = 0;
        int c = aAggregator.length;
        for (int i = 0; i < c; ++i) {
            iHash += aAggregator[i].hashCode();
        }
        return iHash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ClassHelper.getSimpleName(this.getClass())).append('(');
        InvocableMap.EntryAggregator[] aAggregator = this.m_aAggregator;
        int c = aAggregator.length;
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(aAggregator[i]);
        }
        sb.append(')');
        return sb.toString();
    }

    public static CompositeAggregator createInstance(InvocableMap.EntryAggregator[] aAggregator) {
        return new CompositeAggregator(aAggregator);
    }

    @Deprecated
    public static class Parallel
    extends CompositeAggregator {
        public Parallel() {
        }

        protected Parallel(InvocableMap.EntryAggregator[] aAggregator) {
            super(aAggregator);
        }
    }
}

