/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.aggregator;

import com.tangosol.internal.util.aggregator.BigDecimalSerializationWrapper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.aggregator.AbstractBigDecimalAggregator;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class BigDecimalAverage<T>
extends AbstractBigDecimalAggregator<T> {
    public BigDecimalAverage() {
    }

    public BigDecimalAverage(ValueExtractor<? super T, ? extends Number> extractor) {
        super(extractor);
    }

    public BigDecimalAverage(String sMethod) {
        super(sMethod);
    }

    @Override
    public InvocableMap.StreamingAggregator<Object, Object, Object, BigDecimal> supply() {
        BigDecimalAverage bigDecimalAverage = new BigDecimalAverage(this.getValueExtractor());
        bigDecimalAverage.setScale(this.getScale());
        bigDecimalAverage.setMathContext(this.getMathContext());
        bigDecimalAverage.setRoundingMode(this.getRoundingMode());
        bigDecimalAverage.setStripTrailingZeros(this.isStripTrailingZeros());
        return bigDecimalAverage;
    }

    @Override
    public int characteristics() {
        return 33;
    }

    @Override
    protected void process(Object o, boolean fFinal) {
        if (o != null) {
            BigDecimal decResult = this.m_decResult;
            if (fFinal) {
                BigDecimalSerializationWrapper wrapper = (BigDecimalSerializationWrapper)o;
                int c = wrapper.getCount();
                if (c > 0) {
                    this.m_count += c;
                    BigDecimal partialResult = wrapper.getBigDecimal();
                    this.m_decResult = decResult == null ? partialResult : decResult.add(partialResult);
                }
            } else {
                BigDecimal dec = BigDecimalAverage.ensureBigDecimal((Number)o);
                ++this.m_count;
                this.m_decResult = decResult == null ? dec : decResult.add(dec);
            }
        }
    }

    @Override
    protected Object finalizeResult(boolean fFinal) {
        if (this.m_count == 0) {
            return null;
        }
        if (fFinal) {
            if (this.m_mathContext != null) {
                this.m_decResult = this.m_decResult.divide(BigDecimal.valueOf(this.m_count), this.m_mathContext);
            } else if (this.m_roundingMode != null && this.m_scale != null) {
                this.m_decResult = this.m_decResult.divide(BigDecimal.valueOf(this.m_count), (int)this.m_scale, this.m_roundingMode);
            } else if (this.m_roundingMode != null && this.m_scale == null) {
                this.m_decResult = this.m_decResult.divide(BigDecimal.valueOf(this.m_count), this.m_roundingMode);
            } else {
                if (this.m_roundingMode == null && this.m_scale != null) {
                    throw new IllegalArgumentException("If scale is specified, the rounding mode must be specified as well");
                }
                this.m_decResult = this.m_decResult.divide(BigDecimal.valueOf(this.m_count), this.m_decResult.scale() + 8, RoundingMode.HALF_UP);
            }
            if (this.isStripTrailingZeros()) {
                this.m_decResult = this.m_decResult.stripTrailingZeros();
            }
            return this.m_decResult;
        }
        return new BigDecimalSerializationWrapper(this.m_count, this.m_decResult);
    }
}

