/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.aggregator;

import com.tangosol.internal.util.aggregator.BigDecimalSerializationWrapper;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.aggregator.AbstractAggregator;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Objects;

public abstract class AbstractBigDecimalAggregator<T>
extends AbstractAggregator<Object, Object, T, Number, BigDecimal> {
    protected transient int m_count;
    protected transient BigDecimal m_decResult;
    protected Integer m_scale;
    protected MathContext m_mathContext;
    protected RoundingMode m_roundingMode;
    protected boolean m_fStripTrailingZeros;

    public AbstractBigDecimalAggregator() {
    }

    public AbstractBigDecimalAggregator(ValueExtractor<? super T, ? extends Number> extractor) {
        super(extractor);
    }

    public AbstractBigDecimalAggregator(String sMethod) {
        super(sMethod);
    }

    @Override
    protected void init(boolean fFinal) {
        this.m_count = 0;
        this.m_decResult = null;
    }

    @Override
    protected Object finalizeResult(boolean fFinal) {
        if (this.m_count == 0) {
            return null;
        }
        if (fFinal) {
            if (this.getScale() != null) {
                this.m_decResult = this.getRoundingMode() != null ? this.m_decResult.setScale((int)this.getScale(), this.getRoundingMode()) : this.m_decResult.setScale(this.getScale());
            }
            if (this.isStripTrailingZeros()) {
                this.m_decResult = this.m_decResult.stripTrailingZeros();
            }
            return this.m_decResult;
        }
        return new BigDecimalSerializationWrapper(this.m_decResult);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractBigDecimalAggregator)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractBigDecimalAggregator that = (AbstractBigDecimalAggregator)o;
        return this.isStripTrailingZeros() == that.isStripTrailingZeros() && Objects.equals(this.getScale(), that.getScale()) && Objects.equals(this.getMathContext(), that.getMathContext()) && this.getRoundingMode() == that.getRoundingMode();
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getScale(), this.getMathContext(), this.getRoundingMode(), this.isStripTrailingZeros()});
    }

    public static BigDecimal ensureBigDecimal(Number num) {
        return num instanceof BigDecimal ? (BigDecimal)num : (num instanceof BigInteger ? new BigDecimal((BigInteger)num) : new BigDecimal(num.doubleValue()));
    }

    public Integer getScale() {
        return this.m_scale;
    }

    public void setScale(Integer scale) {
        this.m_scale = scale;
    }

    public MathContext getMathContext() {
        return this.m_mathContext;
    }

    public void setMathContext(MathContext mathContext) {
        this.m_mathContext = mathContext;
    }

    public RoundingMode getRoundingMode() {
        return this.m_roundingMode;
    }

    public void setRoundingMode(RoundingMode roundingMode) {
        this.m_roundingMode = roundingMode;
    }

    public boolean isStripTrailingZeros() {
        return this.m_fStripTrailingZeros;
    }

    public void setStripTrailingZeros(boolean fStripTrailingZeros) {
        this.m_fStripTrailingZeros = fStripTrailingZeros;
    }
}

