/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.oracle.coherence.common.base.Predicate;
import com.oracle.coherence.common.collections.PredicateIterator;
import com.tangosol.util.OpenHashSet;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class SubSet<E>
extends AbstractSet<E>
implements Cloneable {
    private static final Set EMPTY_SET = Collections.emptySet();
    private static final Iterator EMPTY_ITERATOR = EMPTY_SET.iterator();
    protected static final Object[] EMPTY_ARRAY = EMPTY_SET.toArray();
    private Predicate NOT_REMOVED = new Predicate(){

        public boolean evaluate(Object o) {
            if (SubSet.this.m_fRetained) {
                throw new ConcurrentModificationException();
            }
            Set setMod = SubSet.this.m_setMod;
            return setMod == null || !setMod.contains(o);
        }
    };
    protected Set<E> m_setOrig;
    protected Set<E> m_setMod;
    protected boolean m_fRetained;

    public SubSet(Set<? extends E> set) {
        this.m_setOrig = set;
    }

    public Set<? extends E> getOriginal() {
        return this.m_setOrig;
    }

    public boolean isModified() {
        Set<E> setMod = this.m_setMod;
        return this.m_fRetained ? setMod == null || setMod.size() != this.m_setOrig.size() : setMod != null && !setMod.isEmpty();
    }

    public boolean isTrackingRetained() {
        return this.m_fRetained;
    }

    public Set<E> getRetained() {
        Set<E> setMod = this.m_setMod;
        if (this.m_fRetained) {
            return setMod == null ? EMPTY_SET : setMod;
        }
        if (setMod == null || setMod.isEmpty()) {
            return this.m_setOrig;
        }
        Set<E> setOrig = this.m_setOrig;
        if (setMod.size() == setOrig.size()) {
            return EMPTY_SET;
        }
        Set<E> setRemain = this.instantiateModificationSet(setOrig.size());
        setRemain.addAll(setOrig);
        setRemain.removeAll(setMod);
        return setRemain;
    }

    public Set<E> getRemoved() {
        Set<E> setMod = this.m_setMod;
        if (this.m_fRetained) {
            if (setMod == null || setMod.isEmpty()) {
                return this.m_setOrig;
            }
            Set<E> setOrig = this.m_setOrig;
            if (setMod.size() == setOrig.size()) {
                return EMPTY_SET;
            }
            OpenHashSet<E> setRemove = new OpenHashSet<E>(setOrig);
            setRemove.removeAll(setMod);
            return setRemove;
        }
        return setMod == null ? EMPTY_SET : setMod;
    }

    protected Set<E> instantiateModificationSet(int cSize) {
        return this.m_setOrig instanceof SortedSet ? new TreeSet(((SortedSet)this.m_setOrig).comparator()) : (cSize == 0 ? new OpenHashSet() : new OpenHashSet(cSize));
    }

    protected Set<E> ensureRetained() {
        Set<E> setMod = this.m_setMod;
        if (this.m_fRetained) {
            if (setMod == null) {
                setMod = this.instantiateModificationSet(0);
                this.m_setMod = setMod;
            }
        } else {
            Set<E> setOrig = this.m_setOrig;
            Set<E> setRemoved = setMod;
            setMod = this.instantiateModificationSet(0);
            this.m_setMod = setMod;
            this.m_fRetained = true;
            if (setRemoved == null || setRemoved.isEmpty()) {
                setMod.addAll(setOrig);
            } else {
                int cRemoved;
                int cOrig = setOrig.size();
                if (cOrig != (cRemoved = setRemoved.size())) {
                    if (cRemoved << 2 > cOrig) {
                        for (E e : setOrig) {
                            if (setRemoved.contains(e)) continue;
                            setMod.add(e);
                        }
                    } else {
                        setMod.addAll(setOrig);
                        setMod.removeAll(setRemoved);
                    }
                }
            }
        }
        return setMod;
    }

    protected Set<E> ensureRemoved() {
        if (this.m_fRetained) {
            throw new IllegalStateException();
        }
        Set<E> setMod = this.m_setMod;
        if (setMod == null) {
            this.m_setMod = setMod = new OpenHashSet();
        }
        return setMod;
    }

    public void resolve() {
        if (this.isModified()) {
            Set<E> setMod = this.m_setMod;
            Set<E> setOrig = this.m_setOrig;
            if (this.m_fRetained) {
                if (setMod == null || setMod.isEmpty()) {
                    setOrig.clear();
                } else {
                    setOrig.retainAll(setMod);
                }
            } else if (setMod != null && !setMod.isEmpty()) {
                setOrig.removeAll(setMod);
            }
        }
        this.reset();
    }

    public void reset() {
        this.m_setMod = null;
        this.m_fRetained = false;
    }

    protected void resetState(Set setOrig, Set setMod, boolean fRetained) {
        this.m_setOrig = setOrig;
        this.m_setMod = setMod;
        this.m_fRetained = fRetained;
    }

    @Override
    public Iterator iterator() {
        return this.isEmpty() ? EMPTY_ITERATOR : (this.m_fRetained ? this.m_setMod.iterator() : new SubSetIterator());
    }

    @Override
    public boolean isEmpty() {
        Set<E> setMod = this.m_setMod;
        Set<E> setOrig = this.m_setOrig;
        if (setOrig.isEmpty()) {
            return true;
        }
        if (this.m_fRetained) {
            return setMod == null || setMod.isEmpty();
        }
        if (setMod == null || setMod.isEmpty()) {
            return false;
        }
        return setMod.size() == setOrig.size();
    }

    @Override
    public int size() {
        Set<E> setMod = this.m_setMod;
        int cMod = setMod == null ? 0 : setMod.size();
        return this.m_fRetained ? cMod : this.m_setOrig.size() - cMod;
    }

    @Override
    public boolean contains(Object o) {
        boolean fInMod;
        Set<E> setMod = this.m_setMod;
        boolean bl = fInMod = setMod != null && setMod.contains(o);
        return this.m_fRetained ? fInMod : !fInMod && this.m_setOrig.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> col) {
        Set<?> setMod = this.m_setMod;
        if (this.m_fRetained) {
            return (setMod == null ? EMPTY_SET : setMod).containsAll(col);
        }
        if (setMod != null) {
            Collection<?> colSmaller;
            Collection<?> colLarger;
            if (col.size() > setMod.size()) {
                colLarger = col;
                colSmaller = setMod;
            } else {
                colLarger = setMod;
                colSmaller = col;
            }
            for (Object o : colSmaller) {
                if (!colLarger.contains(o)) continue;
                return false;
            }
        }
        return this.m_setOrig.containsAll(col);
    }

    @Override
    public boolean add(E e) {
        if (!this.m_setOrig.contains(e)) {
            throw new UnsupportedOperationException("attempt to add an item to the SubSet that was not in the original set; item=\"" + String.valueOf(e) + "\"");
        }
        return this.m_fRetained ? this.ensureRetained().add(e) : this.ensureRemoved().remove(e);
    }

    @Override
    public boolean addAll(Collection<? extends E> col) {
        if (!this.m_setOrig.containsAll(col)) {
            throw new UnsupportedOperationException("attempt to add items to the SubSet that were not in the original set; item collection=\"" + String.valueOf(col) + "\"");
        }
        return this.m_fRetained ? this.ensureRetained().addAll(col) : this.ensureRemoved().removeAll(col);
    }

    @Override
    public boolean remove(Object o) {
        if (this.m_fRetained) {
            Set<E> setMod = this.m_setMod;
            return setMod != null && setMod.remove(o);
        }
        return this.m_setOrig.contains(o) && this.ensureRemoved().add(o);
    }

    @Override
    public boolean removeAll(Collection<?> col) {
        Set<?> setMod = this.m_setMod;
        if (this.m_fRetained) {
            return setMod != null && !setMod.isEmpty() && setMod.removeAll(col);
        }
        Set<E> setOrig = this.m_setOrig;
        int cOrig = setOrig.size();
        int cRemoved = setMod == null ? 0 : setMod.size();
        int cRemove = col.size();
        if (cRemove == 0) {
            return false;
        }
        if (cOrig > 64 && cRemove + cRemoved > cOrig >>> 2) {
            return this.ensureRetained().removeAll(col);
        }
        setMod = this.ensureRemoved();
        boolean fMod = false;
        for (Object o : col) {
            if (setMod.contains(o) || !setOrig.contains(o)) continue;
            setMod.add(o);
            fMod = true;
        }
        return fMod;
    }

    @Override
    public boolean retainAll(Collection<?> col) {
        assert (col != null);
        Set<E> setMod = this.m_setMod;
        int cPassed = col.size();
        if (this.m_fRetained) {
            setMod = this.ensureRetained();
            int cPrevSize = setMod.size();
            if (cPrevSize >= cPassed * 2) {
                this.retainAllInternal(col, setMod, null);
                return cPrevSize != this.m_setMod.size();
            }
            Iterator<E> iter = setMod.iterator();
            while (iter.hasNext()) {
                if (col.contains(iter.next())) continue;
                iter.remove();
            }
            return cPrevSize != setMod.size();
        }
        this.m_fRetained = true;
        Set<E> setOrig = this.m_setOrig;
        int cOrig = setOrig.size();
        Set<E> setRemoved = null;
        int cRemoved = 0;
        if (setMod != null && !setMod.isEmpty()) {
            setRemoved = setMod;
            cRemoved = setRemoved.size();
        }
        if (cOrig >= cPassed) {
            this.retainAllInternal(col, setOrig, setRemoved);
        } else {
            this.retainAllInternal(setOrig, col, setRemoved);
        }
        return cOrig - cRemoved != this.m_setMod.size();
    }

    @Override
    public void clear() {
        this.m_fRetained = true;
        this.m_setMod = null;
    }

    @Override
    public Object[] toArray() {
        Set<E> setMod = this.m_setMod;
        if (this.m_fRetained) {
            return setMod == null || setMod.isEmpty() ? EMPTY_ARRAY : setMod.toArray();
        }
        Set<E> setOrig = this.m_setOrig;
        if (setMod == null || setMod.isEmpty()) {
            return setOrig.toArray();
        }
        int i = 0;
        int c = Math.max(setOrig.size() - setMod.size(), 0);
        Object[] ao = new Object[c];
        if (c == 0) {
            return ao;
        }
        for (E o : setOrig) {
            if (setMod.contains(o)) continue;
            ao[i++] = o;
            if (i != c) continue;
            break;
        }
        return i < c ? Arrays.copyOf(ao, i) : ao;
    }

    @Override
    public Object[] toArray(Object[] ao) {
        int c = ao.length;
        Object[] aoActual = this.toArray();
        int cActual = aoActual.length;
        if (c < cActual) {
            ao = (Object[])Array.newInstance(ao.getClass().getComponentType(), cActual);
        } else if (c > cActual) {
            ao[cActual] = null;
        }
        System.arraycopy(aoActual, 0, ao, 0, cActual);
        return ao;
    }

    public Object clone() {
        SubSet setNew;
        try {
            setNew = (SubSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
        Set<E> setMod = setNew.m_setMod;
        if (setMod != null) {
            setNew.m_setMod = this.instantiateModificationSet(setMod.size());
            setNew.m_setMod.addAll(setMod);
        }
        return setNew;
    }

    protected void retainAllInternal(Collection colOuter, Collection colMatch, Set setExclude) {
        this.m_setMod = this.instantiateModificationSet(colOuter.size());
        Set setMod = this.m_setMod;
        for (Object o : colOuter) {
            if (setExclude != null && setExclude.contains(o) || !colMatch.contains(o)) continue;
            setMod.add(o);
        }
    }

    protected class SubSetIterator
    extends PredicateIterator<E> {
        protected SubSetIterator() {
            super(SubSet.this.m_setOrig.iterator(), SubSet.this.NOT_REMOVED);
        }

        @Override
        public void remove() {
            if (SubSet.this.m_fRetained) {
                throw new ConcurrentModificationException();
            }
            if (!this.m_fPrev) {
                throw new IllegalStateException();
            }
            this.m_fPrev = false;
            SubSet.this.ensureRemoved().add(this.m_next);
        }
    }
}

