/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.Base;
import com.tangosol.util.CollatedKey;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.SimpleEnumerator;
import com.tangosol.util.Tree;
import java.io.Serializable;
import java.text.CollationKey;
import java.text.Collator;
import java.util.Enumeration;
import java.util.Vector;

public final class StringTable
extends Base
implements Cloneable,
Serializable {
    private static final String CLASS = "StringTable";
    private static final String[] NO_STRINGS = new String[0];
    private Tree tree = new Tree();
    private Collator collator;

    public StringTable() {
    }

    public StringTable(Collator collator) {
        this.collator = collator;
    }

    public StringTable(int nStrength) {
        this.collator = Collator.getInstance();
        this.collator.setStrength(nStrength);
    }

    public void add(String string) {
        this.tree.add(this.createKey(string));
    }

    public void put(String string, Object value) {
        this.tree.put(this.createKey(string), value);
    }

    public Object get(String string) {
        return this.tree.get(this.createKey(string));
    }

    public boolean contains(String string) {
        return this.tree.contains(this.createKey(string));
    }

    public Object remove(String string) {
        return this.tree.remove(this.createKey(string));
    }

    public void clear() {
        this.tree.clear();
    }

    public int getSize() {
        return this.tree.getSize();
    }

    public boolean isEmpty() {
        return this.tree.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] strings() {
        Tree tree = this.tree;
        synchronized (tree) {
            int cNodes = this.tree.getSize();
            if (cNodes == 0) {
                return NO_STRINGS;
            }
            String[] asKey = new String[cNodes];
            int cStrings = 0;
            Enumeration enmr = this.tree.getUnsynchronizedKeyEnumerator();
            while (enmr.hasMoreElements()) {
                asKey[cStrings++] = enmr.nextElement().toString();
            }
            if (cStrings != cNodes) {
                throw new IllegalStateException("iterated " + cStrings + " strings in a " + cNodes + "-entry table!");
            }
            return asKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] stringsStartingWith(String prefix) {
        int cchPrefix = prefix.length();
        if (cchPrefix < 1) {
            return this.strings();
        }
        Vector<String> strings = new Vector<String>();
        Tree tree = this.tree;
        synchronized (tree) {
            if (this.collator == null) {
                String sKey;
                Enumeration enmr = this.tree.getUnsynchronizedKeyEnumerator(this.createKey(prefix));
                while (enmr.hasMoreElements() && (sKey = enmr.nextElement().toString()).startsWith(prefix)) {
                    strings.addElement(sKey);
                }
            } else {
                CollationKey ck;
                String sKey;
                CollationKey ckPrefix = this.collator.getCollationKey(prefix);
                Enumeration enmr = this.tree.getUnsynchronizedKeyEnumerator(new CollatedKey(ckPrefix));
                while (enmr.hasMoreElements() && (sKey = enmr.nextElement().toString()).length() >= cchPrefix && (ck = this.collator.getCollationKey(sKey.substring(0, cchPrefix))).compareTo(ckPrefix) == 0) {
                    strings.addElement(sKey);
                }
            }
        }
        int cStrings = strings.size();
        if (cStrings == 0) {
            return NO_STRINGS;
        }
        Object[] asKey = new String[cStrings];
        strings.copyInto(asKey);
        return asKey;
    }

    public Enumeration keys() {
        if (this.isEmpty()) {
            return NullImplementation.getEnumeration();
        }
        return new SimpleEnumerator<String>(this.strings());
    }

    public Enumeration elements() {
        return this.tree.elements();
    }

    private Comparable createKey(String sKey) {
        return this.collator == null ? sKey : new CollatedKey(this.collator.getCollationKey(sKey));
    }

    public boolean addAll(StringTable that) {
        return this.tree.addAll(that.tree);
    }

    public void putAll(StringTable that) {
        this.tree.putAll(that.tree);
    }

    public boolean retainAll(StringTable that) {
        return this.tree.retainAll(that.tree);
    }

    public boolean removeAll(StringTable that) {
        return this.tree.removeAll(that.tree);
    }

    public synchronized String toString() {
        return "StringTable(" + (this.collator == null ? "<null>" : this.collator.toString()) + "," + this.tree.toString() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StringTable)) {
            return false;
        }
        StringTable that = (StringTable)obj;
        if (!(this.collator == that.collator || this.collator != null && this.collator.equals(that.collator))) {
            return false;
        }
        int nHashThis = System.identityHashCode(this);
        int nHashThat = System.identityHashCode(that);
        StringTable o1 = this;
        StringTable o2 = that;
        if (nHashThis > nHashThat) {
            o1 = that;
            o2 = this;
        }
        StringTable stringTable = o1;
        synchronized (stringTable) {
            StringTable stringTable2 = o2;
            synchronized (stringTable2) {
                return this.tree.equals(that.tree);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean keysEquals(StringTable that) {
        if (this == that) {
            return true;
        }
        Tree thisTree = this.tree;
        Tree thatTree = that.tree;
        if (thisTree.getSize() == thatTree.getSize()) {
            if (thisTree.getSize() == 0) {
                return true;
            }
        } else {
            return false;
        }
        if (!(this.collator == that.collator || this.collator != null && this.collator.equals(that.collator))) {
            return false;
        }
        StringTable stringTable = this;
        synchronized (stringTable) {
            StringTable stringTable2 = that;
            synchronized (stringTable2) {
                Enumeration thisEnum = thisTree.getUnsynchronizedKeyEnumerator();
                Enumeration thatEnum = thatTree.getUnsynchronizedKeyEnumerator();
                while (thisEnum.hasMoreElements() && thatEnum.hasMoreElements()) {
                    if (thisEnum.nextElement().equals(thatEnum.nextElement())) continue;
                    return false;
                }
                return thisEnum.hasMoreElements() == thatEnum.hasMoreElements();
            }
        }
    }

    public synchronized Object clone() {
        StringTable that = new StringTable();
        that.tree = (Tree)this.tree.clone();
        if (this.collator != null) {
            that.collator = (Collator)this.collator.clone();
        }
        return that;
    }
}

