/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface Streamer<T>
extends Iterator<T> {
    public static final int SIZED = 1;
    public static final int ALL_INCLUSIVE = 2;

    public long size();

    public int characteristics();

    default public Spliterator<T> spliterator() {
        return Spliterators.spliterator(this, this.size(), this.isSized() ? 64 : 0);
    }

    default public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    default public boolean isSized() {
        return (this.characteristics() & 1) != 0 && this.size() >= 0L;
    }

    default public boolean isAllInclusive() {
        return (this.characteristics() & 2) != 0;
    }

    @Override
    default public void remove() {
        throw new UnsupportedOperationException();
    }
}

