/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.oracle.coherence.common.base.Disposable;
import com.tangosol.net.security.LocalPermission;
import com.tangosol.util.Base;
import com.tangosol.util.Builder;
import com.tangosol.util.BuilderHelper;
import com.tangosol.util.RegistrationBehavior;
import com.tangosol.util.ResourceRegistry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SimpleResourceRegistry
implements ResourceRegistry {
    private final ConcurrentHashMap<RegistryKey, RegistryValue> m_mapResource = new ConcurrentHashMap();

    public boolean isEmpty() {
        return this.m_mapResource.isEmpty();
    }

    public void registerResources(ResourceRegistry registry) {
        this.registerResources(registry, RegistrationBehavior.FAIL);
    }

    public void registerResources(ResourceRegistry registry, RegistrationBehavior behavior) {
        for (Map.Entry<RegistryKey, RegistryValue> entry : this.m_mapResource.entrySet()) {
            RegistryKey key = entry.getKey();
            RegistryValue value = entry.getValue();
            Class<?> clz = key.getResourceClass();
            registry.registerResource(clz, key.getName(), BuilderHelper.using(value.getResource()), behavior, value.getObserver());
        }
    }

    @Override
    public synchronized void dispose() {
        ConcurrentHashMap<RegistryKey, RegistryValue> mapResource = this.m_mapResource;
        for (Map.Entry entry : mapResource.entrySet()) {
            RegistryValue value = (RegistryValue)entry.getValue();
            try {
                value.dispose();
            }
            catch (RuntimeException e) {
                Base.log("Exception while disposing the " + ((RegistryKey)entry.getKey()).getName() + " resource: " + String.valueOf(e));
                Base.log(e);
            }
        }
        mapResource.clear();
    }

    @Override
    public <R> R getResource(Class<R> clzResource) {
        RegistryValue value = this.m_mapResource.get(new RegistryKey(clzResource));
        return (R)(value == null ? null : value.getResource());
    }

    @Override
    public <R> R getResource(Class<R> clzResource, String sResourceName) {
        RegistryValue value = this.m_mapResource.get(new RegistryKey(clzResource, sResourceName));
        return (R)(value == null ? null : value.getResource());
    }

    @Override
    public <R> String registerResource(Class<R> clzResource, R resource) {
        return this.registerResource(clzResource, clzResource.getName(), BuilderHelper.using(resource), RegistrationBehavior.FAIL, null);
    }

    @Override
    public <R> String registerResource(Class<R> clzResource, String sResourceName, R resource) {
        return this.registerResource(clzResource, sResourceName, BuilderHelper.using(resource), RegistrationBehavior.FAIL, null);
    }

    @Override
    public <R> String registerResource(Class<R> clzResource, Builder<? extends R> bldrResource, RegistrationBehavior behavior, ResourceRegistry.ResourceLifecycleObserver<R> observer) {
        return this.registerResource(clzResource, clzResource.getName(), bldrResource, behavior, observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> String registerResource(Class<R> clzResource, String sResourceName, Builder<? extends R> bldrResource, RegistrationBehavior behavior, ResourceRegistry.ResourceLifecycleObserver<R> observer) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new LocalPermission("Service.registerResource"));
        }
        Class<R> clazz = clzResource;
        synchronized (clazz) {
            RegistryKey key = new RegistryKey(clzResource, sResourceName);
            RegistryValue value = this.m_mapResource.get(key);
            if (value == null) {
                value = new RegistryValue(bldrResource.realize(), observer);
                this.m_mapResource.put(key, value);
            } else {
                switch (behavior) {
                    case IGNORE: {
                        break;
                    }
                    case REPLACE: {
                        R resource = bldrResource.realize();
                        if (resource == value.getResource() && resource.equals(value.getResource())) break;
                        value.dispose();
                        value = new RegistryValue(resource, observer);
                        this.m_mapResource.put(key, value);
                        break;
                    }
                    case FAIL: {
                        R resource = bldrResource.realize();
                        if (resource == value.getResource() && resource.equals(value.getResource())) break;
                        throw new IllegalArgumentException(String.format("Can not register resource [%s] as resource [%s] is it already registered with [%s] as [%s]", sResourceName, value.getResource(), key.getResourceClass(), key.getName()));
                    }
                    case ALWAYS: {
                        String sGeneratedResourceName;
                        int i = 1;
                        while (this.m_mapResource.containsKey(key = new RegistryKey(clzResource, sGeneratedResourceName = String.format("%s-%d", sResourceName, i++)))) {
                        }
                        R resource = bldrResource.realize();
                        value = new RegistryValue(resource, observer);
                        this.m_mapResource.put(key, value);
                        sResourceName = sGeneratedResourceName;
                    }
                }
            }
            return sResourceName;
        }
    }

    @Override
    public <R> void unregisterResource(Class<R> clzResource, String sResourceName) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new LocalPermission("Service.registerResource"));
        }
        this.m_mapResource.remove(new RegistryKey(clzResource, sResourceName));
    }

    protected class RegistryKey {
        private Class<?> m_clz;
        private String m_sName;

        public RegistryKey(Class<?> clz) {
            this(clz, clz.getName());
        }

        public RegistryKey(Class<?> clz, String sName) {
            if (clz == null) {
                throw new NullPointerException("Resource class cannot be null");
            }
            if (sName == null) {
                throw new NullPointerException("Resource name cannot be null");
            }
            this.m_clz = clz;
            this.m_sName = sName;
        }

        public Class<?> getResourceClass() {
            return this.m_clz;
        }

        public String getName() {
            return this.m_sName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !Base.equals(this.getClass(), o.getClass())) {
                return false;
            }
            RegistryKey that = (RegistryKey)o;
            return Base.equals(this.m_clz, that.m_clz) && Base.equals(this.m_sName, that.m_sName);
        }

        public int hashCode() {
            int result = this.m_clz.hashCode();
            result = 31 * result + this.m_sName.hashCode();
            return result;
        }
    }

    protected class RegistryValue
    implements Disposable {
        private Object m_oResource;
        private ResourceRegistry.ResourceLifecycleObserver<Object> m_observer;

        public RegistryValue(Object oResource, ResourceRegistry.ResourceLifecycleObserver<Object> observer) {
            if (oResource == null) {
                throw new NullPointerException("Resource cannot be null");
            }
            this.m_oResource = oResource;
            this.m_observer = observer;
        }

        public Object getResource() {
            return this.m_oResource;
        }

        public ResourceRegistry.ResourceLifecycleObserver<Object> getObserver() {
            return this.m_observer;
        }

        @Override
        public void dispose() {
            ResourceRegistry.ResourceLifecycleObserver<Object> observer;
            Object oResource = this.m_oResource;
            if (oResource instanceof Disposable) {
                ((Disposable)oResource).dispose();
            }
            if ((observer = this.m_observer) != null) {
                observer.onRelease(oResource);
            }
        }
    }
}

