/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.Base;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.MapTrigger;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.ValueUpdater;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;

public class SimpleMapEntry<K, V>
extends Base
implements MapTrigger.Entry<K, V>,
Cloneable,
Serializable {
    protected static final Object NO_VALUE = new Object();
    protected K m_oKey;
    protected V m_oValue;
    protected V m_oOrigValue;

    protected SimpleMapEntry() {
        this(null, null, NO_VALUE);
    }

    protected SimpleMapEntry(K key) {
        this(key, null, NO_VALUE);
    }

    public SimpleMapEntry(Map.Entry<K, V> entry) {
        this(entry.getKey(), entry.getValue(), entry instanceof MapTrigger.Entry && ((MapTrigger.Entry)entry).isOriginalPresent() ? ((MapTrigger.Entry)entry).getOriginalValue() : NO_VALUE);
    }

    public SimpleMapEntry(K key, V value) {
        this(key, value, NO_VALUE);
    }

    public SimpleMapEntry(K key, V value, V origValue) {
        this.m_oKey = key;
        this.m_oValue = value;
        this.m_oOrigValue = origValue;
    }

    @Override
    public K getKey() {
        return this.m_oKey;
    }

    @Override
    public V getValue() {
        return this.m_oValue;
    }

    @Override
    public V setValue(V value) {
        V oPrev = this.m_oValue;
        this.m_oValue = value;
        return oPrev;
    }

    @Override
    public V getOriginalValue() {
        V oOrig = this.m_oOrigValue;
        return oOrig == NO_VALUE ? null : (V)oOrig;
    }

    @Override
    public boolean isOriginalPresent() {
        return this.m_oOrigValue != NO_VALUE;
    }

    @Override
    public void setValue(V oValue, boolean fSynthetic) {
        this.setValue(oValue);
    }

    @Override
    public <U> void update(ValueUpdater<V, U> updater, U value) {
        InvocableMapHelper.updateEntry(updater, this, value);
    }

    @Override
    public boolean isPresent() {
        return true;
    }

    @Override
    public boolean isSynthetic() {
        return false;
    }

    @Override
    public void remove(boolean fSynthetic) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T, E> E extract(ValueExtractor<T, E> extractor) {
        return InvocableMapHelper.extractFromEntry(extractor, this);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Map.Entry)) {
            return false;
        }
        Map.Entry that = (Map.Entry)o;
        if (this == that) {
            return true;
        }
        return SimpleMapEntry.equals(this.getKey(), that.getKey()) && SimpleMapEntry.equals(this.getValue(), that.getValue());
    }

    @Override
    public int hashCode() {
        K oKey = this.getKey();
        V oValue = this.getValue();
        return (oKey == null ? 0 : oKey.hashCode()) ^ (oValue == null ? 0 : oValue.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Entry{Key=\"").append(this.getKey()).append("\", Value=\"").append(this.getValue());
        if (this.isOriginalPresent()) {
            sb.append("\", OrigValue=\"").append(this.getOriginalValue());
        }
        sb.append("\"}");
        return sb.toString();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw SimpleMapEntry.ensureRuntimeException(e);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.m_oKey);
        out.writeObject(this.m_oValue);
        if (this.isOriginalPresent()) {
            out.writeBoolean(true);
            out.writeObject(this.m_oOrigValue);
        } else {
            out.writeBoolean(false);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.m_oKey = in.readObject();
        this.m_oValue = in.readObject();
        this.m_oOrigValue = in.readBoolean() ? in.readObject() : NO_VALUE;
    }
}

