/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.ConverterCollections;
import com.tangosol.util.NullImplementation;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;

public class SetMap<K, V>
extends AbstractMap<K, V> {
    private static final Object NO_VALUE = new Object();
    protected Map<K, Object> f_map;
    protected Function<K, V> f_functionValue;

    public SetMap(Set<K> setKeys) {
        this(setKeys, k -> null);
    }

    public SetMap(Set<K> setKeys, Function<K, V> functionValue) {
        this(setKeys, functionValue, HashMap::new);
    }

    public SetMap(Set<K> setKeys, Function<K, V> functionValue, Supplier<Map<K, V>> supplierMap) {
        this.f_functionValue = functionValue;
        this.f_map = supplierMap.get();
        for (K key : setKeys) {
            this.f_map.put(key, NO_VALUE);
        }
    }

    @Override
    public int size() {
        return this.f_map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.f_map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.f_map.containsKey(key);
    }

    @Override
    public V get(Object key) {
        return this.ensureValue(key);
    }

    @Override
    public V put(K key, V value) {
        return this.getExternalMap().put(key, value);
    }

    @Override
    public V remove(Object key) {
        this.ensureValue(key);
        return this.getExternalMap().remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.getExternalMap().putAll(map);
    }

    @Override
    public void clear() {
        this.getExternalMap().clear();
    }

    @Override
    public Set<K> keySet() {
        return this.getExternalMap().keySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return ConverterCollections.getSet(this.getInternalMap().entrySet(), entry -> {
            if (entry.getValue() == NO_VALUE) {
                entry.setValue(this.f_functionValue.apply(entry.getKey()));
            }
            return entry;
        }, NullImplementation.getConverter());
    }

    protected Map<K, Object> getInternalMap() {
        return this.f_map;
    }

    protected Map<K, V> getExternalMap() {
        return this.f_map;
    }

    protected V ensureValue(Object oKey) {
        Object value;
        Object key = oKey;
        Object oValue = this.getInternalMap().get(key);
        if (oValue == NO_VALUE) {
            value = this.f_functionValue.apply(key);
            this.getExternalMap().put(key, value);
        } else {
            value = oValue;
        }
        return (V)value;
    }
}

