/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.collections.AbstractStableIterator;
import com.tangosol.util.Base;
import com.tangosol.util.NullImplementation;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class SegmentedHashMap
extends Base
implements Map {
    private static final Entry[] NO_ENTRIES = new Entry[0];
    protected static final int[] PRIME_MODULO = new int[]{61, 127, 197, 277, 397, 457, 509, 587, 641, 701, 761, 827, 883, 953, 1019, 1129, 1279, 1427, 1543, 1733, 1951, 2143, 2371, 2671, 2927, 3253, 3539, 3907, 4211, 4591, 4973, 5393, 5743, 6143, 6619, 6997, 7529, 8009, 8423, 8819, 9311, 9929, 10069, 11087, 12203, 13003, 14051, 15017, 16007, 17027, 18061, 19013, 20063, 23011, 27011, 30011, 35023, 40009, 45007, 50021, 60013, 70001, 80021, 90001, 100003, 120011, 140009, 160001, 180001, 200003, 233021, 266003, 300007, 350003, 400009, 450001, 500009, 550007, 600011, 650011, 700001, 800011, 850009, 900001, 950009, 1000003, 1100009, 1200007, 1300021, 1400017, 1500007, 1600033, 1700021, 1800017, 1900009, 2000003, 2500009, 3000017, 3500017, 4000037, 4500007, 0x4C4B4B, 6000011, 7000003, 8000009, 9000011, 10000019, 0xB71B11, 14000029, 16000057, 18000041, 20000003, 25000009, 30000001, 35000011, 40000003, 45000017, 50000017, 60000011, 70000027, 80000023, 90000049, 100000007, 150000001, 200000033, 300000007, 400000009, 500000003, 600000001, 700000001, 800000011, 900000011, 1000000007, 1100000009, 1200000041, 1300000003, 1400000023, 1500000001, 1600000009, 1700000009, 1800000011, 1900000043, Integer.MAX_VALUE};
    public static final int DEFAULT_INITIALSIZE = PRIME_MODULO[0];
    protected static final int BIGGEST_MODULO = PRIME_MODULO[PRIME_MODULO.length - 1];
    public static final float DEFAULT_LOADFACTOR = 1.0f;
    public static final float DEFAULT_GROWTHRATE = 3.0f;
    protected static final int MIN_SEGMENT_CAPACITY = 2;
    protected static final int SEGMENT_COUNT = 61;
    protected static final int LOCK_COUNT = 62;
    protected static final long LOCKS_NONE = 0L;
    protected static final long LOCKS_ALL = -1L;
    protected static final int LOCK_ALL_PENDING_IDX = 61;
    protected static final long LOCK_ALL_PENDING = 0x2000000000000000L;
    protected static final int SEGMENT_LOCK_MAX_SPIN = 15;
    protected static final int PUTALL_THRESHOLD = 91;
    protected static final Object NO_VALUE = new Object();
    public static final Map<?, ?> EMPTY = Collections.unmodifiableMap(new SegmentedHashMap(1, 1.0f, 3.0f));
    protected final Object RESIZING = new Object();
    protected final AtomicLong m_atomicLocks = new AtomicLong();
    protected final Segment[] m_aSegment;
    protected volatile Entry[] m_aeBucket;
    protected int m_cSegmentCapacity;
    protected final float m_flLoadFactor;
    protected final float m_flGrowthRate;
    protected EntrySet m_setEntries;
    protected KeySet m_setKeys;
    protected ValuesCollection m_colValues;
    protected Object m_oIterActive;
    protected GetEntryAction m_actionGetEntry;
    protected InsertAction m_actionInsert;
    protected RemoveAction m_actionRemove;
    protected ContainsValueAction m_actionContainsValue;

    public SegmentedHashMap() {
        this(DEFAULT_INITIALSIZE, 1.0f, 3.0f);
    }

    public SegmentedHashMap(int cInitialBuckets, float flLoadFactor, float flGrowthRate) {
        if (cInitialBuckets <= 0) {
            throw new IllegalArgumentException("SegmentedHashMap:  Initial number of buckets must be greater than zero.");
        }
        if (flLoadFactor <= 0.0f) {
            throw new IllegalArgumentException("SegmentedHashMap:  Load factor must be greater than zero.");
        }
        if (flGrowthRate <= 0.0f) {
            throw new IllegalArgumentException("SegmentedHashMap:  Growth rate must be greater than zero.");
        }
        this.m_aeBucket = new Entry[cInitialBuckets];
        this.m_cSegmentCapacity = Math.max((int)((float)cInitialBuckets * flLoadFactor) / 61, 2);
        this.m_flLoadFactor = flLoadFactor;
        this.m_flGrowthRate = flGrowthRate;
        this.m_aSegment = new Segment[62];
        for (int i = 0; i < 62; ++i) {
            this.m_aSegment[i] = new Segment();
        }
        this.initializeActions();
    }

    protected InsertAction getInsertAction() {
        return this.m_actionInsert;
    }

    protected void setInsertAction(InsertAction action) {
        this.m_actionInsert = action;
    }

    protected GetEntryAction getGetEntryAction() {
        return this.m_actionGetEntry;
    }

    protected void setGetEntryAction(GetEntryAction action) {
        this.m_actionGetEntry = action;
    }

    protected RemoveAction getRemoveAction() {
        return this.m_actionRemove;
    }

    protected void setRemoveAction(RemoveAction action) {
        this.m_actionRemove = action;
    }

    protected ContainsValueAction getContainsValueAction() {
        return this.m_actionContainsValue;
    }

    protected void setContainsValueAction(ContainsValueAction action) {
        this.m_actionContainsValue = action;
    }

    @Override
    public boolean equals(Object oThat) {
        if (oThat == this) {
            return true;
        }
        if (!(oThat instanceof Map)) {
            return false;
        }
        Map mapThat = (Map)oThat;
        if (mapThat.size() != this.size()) {
            return false;
        }
        for (Map.Entry entryThat : mapThat.entrySet()) {
            Entry entryThis = this.getEntryInternal(entryThat.getKey());
            if (Base.equals(entryThis, entryThat)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int nHash = 0;
        Iterator iter = this.entrySet().iterator();
        while (iter.hasNext()) {
            nHash += iter.next().hashCode();
        }
        return nHash;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        Iterator iter = this.entrySet().iterator();
        boolean fHasNext = iter.hasNext();
        while (fHasNext) {
            Entry entry = (Entry)iter.next();
            Object oKey = entry.getKey();
            Object oValue = entry.getValue();
            buf.append(oKey == this ? "(this Map)" : oKey);
            buf.append("=");
            buf.append(oValue == this ? "(this Map)" : oValue);
            fHasNext = iter.hasNext();
            if (!fHasNext) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    @Override
    public int size() {
        this.m_atomicLocks.get();
        int cEntries = 0;
        Segment[] aSegment = this.m_aSegment;
        for (int i = 0; i < 61; ++i) {
            cEntries += aSegment[i].cEntries;
        }
        return cEntries;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object oKey) {
        return this.getEntryInternal(oKey) != null;
    }

    @Override
    public boolean containsValue(Object oValue) {
        Entry[] aeBucket;
        ContainsValueAction actionEntry = this.getContainsValueAction();
        do {
            Object oContext = actionEntry.instantiateContext(oValue);
            aeBucket = this.getStableBucketArray();
            this.invokeOnAllKeys(oContext, false, actionEntry);
            if (!actionEntry.isFound(oContext)) continue;
            return true;
        } while (aeBucket != this.getStableBucketArray());
        return false;
    }

    public Object get(Object oKey) {
        Entry entry = this.getEntryInternal(oKey);
        return entry == null ? null : entry.getValue();
    }

    public Map.Entry getEntry(Object key) {
        return this.getEntryInternal(key);
    }

    public Object put(Object oKey, Object oValue) {
        Object oOrig = this.putInternal(oKey, oValue);
        return oOrig == NO_VALUE ? null : oOrig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map mapOther) {
        int nSizeOther = mapOther.size();
        if (nSizeOther < 91) {
            for (Map.Entry entryOther : mapOther.entrySet()) {
                this.putInternal(entryOther.getKey(), entryOther.getValue());
            }
        } else {
            InsertAction actionPut = new InsertAction(){

                @Override
                public Object invokeFound(Object oKey, Object oContext, Entry[] aeBucket, int nBucket, Entry entryPrev, Entry entryCur) {
                    Object oResult = super.invokeFound(oKey, oContext, aeBucket, nBucket, entryPrev, entryCur);
                    if (oResult == NO_VALUE) {
                        entryCur.setValueInternal(oContext);
                    }
                    return oResult;
                }
            };
            this.lockAllBuckets();
            try {
                if (nSizeOther > this.m_cSegmentCapacity * 61) {
                    this.grow(nSizeOther);
                }
                for (Map.Entry entryOther : mapOther.entrySet()) {
                    this.invokeOnKey(entryOther.getKey(), entryOther.getValue(), false, actionPut);
                }
            }
            finally {
                this.unlockAllBuckets();
            }
        }
    }

    public Object remove(Object oKey) {
        Object oOrig = this.removeInternal(oKey, this.getRemoveAction(), null);
        return oOrig == NO_VALUE ? null : oOrig;
    }

    @Override
    public void clear() {
        this.lockAllBuckets();
        try {
            this.m_aeBucket = new Entry[DEFAULT_INITIALSIZE];
            Segment[] aSegment = this.m_aSegment;
            for (int i = 0; i < 61; ++i) {
                aSegment[i].cEntries = 0;
            }
            this.m_cSegmentCapacity = Math.max((int)((float)DEFAULT_INITIALSIZE * this.m_flLoadFactor) / 61, 2);
        }
        finally {
            this.unlockAllBuckets();
        }
    }

    public Set entrySet() {
        EntrySet set = this.m_setEntries;
        if (set == null) {
            this.m_setEntries = set = this.instantiateEntrySet();
        }
        return set;
    }

    public Set keySet() {
        KeySet set = this.m_setKeys;
        if (set == null) {
            this.m_setKeys = set = this.instantiateKeySet();
        }
        return set;
    }

    public Collection values() {
        ValuesCollection col = this.m_colValues;
        if (col == null) {
            this.m_colValues = col = this.instantiateValuesCollection();
        }
        return col;
    }

    protected void initializeActions() {
        this.setGetEntryAction(this.instantiateGetEntryAction());
        this.setInsertAction(this.instantiateInsertAction());
        this.setRemoveAction(this.instantiateRemoveAction());
        this.setContainsValueAction(this.instantiateContainsValueAction());
    }

    protected Entry getEntryInternal(Object oKey) {
        return this.getEntryInternal(oKey, false);
    }

    protected Entry getEntryInternal(Object oKey, boolean fSynthetic) {
        Object oResult;
        Boolean FSynthetic;
        Boolean bl = FSynthetic = fSynthetic ? Boolean.TRUE : Boolean.FALSE;
        while ((oResult = this.invokeOnKey(oKey, FSynthetic, false, this.getGetEntryAction())) == NO_VALUE) {
        }
        return (Entry)oResult;
    }

    protected Object putInternal(Object oKey, Object oValue) {
        return this.putInternal(oKey, oValue, false);
    }

    protected Object putInternal(Object oKey, Object oValue, boolean fOnlyIfAbsent) {
        Entry entry;
        while ((entry = this.getEntryInternal(oKey, true)) == null || entry.isSynthetic()) {
            Object oResult = this.invokeOnKey(oKey, oValue, true, this.getInsertAction());
            if (oResult == NO_VALUE) continue;
            if (entry == null) {
                this.ensureLoadFactor(this.getSegmentForKey(oKey));
            }
            return NO_VALUE;
        }
        return !fOnlyIfAbsent ? entry.setValueInternal(oValue) : entry.getValue();
    }

    protected Object removeInternal(Object oKey, EntryAction actionRemove, Object oContext) {
        return this.invokeOnKey(oKey, oContext, true, actionRemove);
    }

    protected Object[] toArrayInternal(IterableEntryAction action, Object[] a) {
        Entry[] aeBucket;
        ArrayList list = new ArrayList();
        do {
            list.clear();
            aeBucket = this.getStableBucketArray();
            this.invokeOnAllKeys(list, false, action);
        } while (aeBucket != this.getStableBucketArray());
        return list.toArray(a == null ? new Object[list.size()] : a);
    }

    protected void ensureLoadFactor(Segment segment) {
        if (segment.cEntries > this.m_cSegmentCapacity) {
            Entry[] aeBucket = this.m_aeBucket;
            this.lockAllBuckets();
            try {
                if (this.m_aeBucket == aeBucket) {
                    this.grow();
                }
            }
            finally {
                this.unlockAllBuckets();
            }
        }
    }

    protected void grow() {
        Entry[] aeOld = this.m_aeBucket;
        int cOld = aeOld.length;
        if (cOld >= BIGGEST_MODULO) {
            return;
        }
        int cNew = (int)Math.min((long)((float)cOld * (1.0f + this.m_flGrowthRate)), (long)BIGGEST_MODULO);
        this.grow(cNew);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void grow(int cNew) {
        if (this.isActiveIterator()) {
            return;
        }
        Object object = this.RESIZING;
        synchronized (object) {
            Entry[] aeNew;
            Entry[] aeOld = this.m_aeBucket;
            int cOld = aeOld.length;
            this.m_aeBucket = NO_ENTRIES;
            if (cNew <= cOld) {
                cNew = cOld + 1;
            }
            for (int iModulo : PRIME_MODULO) {
                if (iModulo < cNew) continue;
                cNew = iModulo;
                break;
            }
            try {
                aeNew = new Entry[cNew];
            }
            catch (OutOfMemoryError e) {
                this.m_aeBucket = aeOld;
                throw e;
            }
            Segment[] aSegment = this.m_aSegment;
            for (int i = 0; i < cOld; ++i) {
                Entry entry = aeOld[i];
                int nSegmentOld = this.getSegmentIndex(i);
                while (entry != null) {
                    Entry entryNext = entry.nextEntry(true);
                    Object oKey = entry.getKey();
                    int nHash = oKey == null ? 0 : oKey.hashCode();
                    int nBucket = this.getBucketIndex(nHash, cNew);
                    int nSegmentNew = this.getSegmentIndex(nBucket);
                    entry.setNext(aeNew[nBucket]);
                    aeNew[nBucket] = entry;
                    --aSegment[nSegmentOld].cEntries;
                    ++aSegment[nSegmentNew].cEntries;
                    entry = entryNext;
                }
            }
            this.m_cSegmentCapacity = Math.max((int)((float)cNew * this.m_flLoadFactor) / 61, 2);
            this.m_aeBucket = aeNew;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeOnAllKeys(Object oContext, boolean fLock, IterableEntryAction actionEntry) {
        if (fLock) {
            this.lockAllBuckets();
        }
        try {
            Entry[] aeBucket = this.getStableBucketArray();
            int cBuckets = aeBucket.length;
            for (int iBucket = 0; iBucket < cBuckets; ++iBucket) {
                Entry entry = aeBucket[iBucket];
                Entry entryPrev = null;
                while (entry != null) {
                    Entry entryNext = entry.nextEntry(true);
                    actionEntry.invokeFound(entry.getKey(), oContext, aeBucket, iBucket, entryPrev, entry);
                    if (actionEntry.isComplete(oContext)) {
                        Object object = oContext;
                        return object;
                    }
                    entryPrev = (entryPrev == null ? aeBucket[iBucket] != entry : entryPrev.nextEntry(true) != entry) ? entryPrev : entry;
                    entry = entryNext;
                }
            }
        }
        finally {
            if (fLock) {
                this.unlockAllBuckets();
            }
        }
        return oContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeOnKey(Object oKey, Object oContext, boolean fLock, EntryAction action) {
        int nHash = oKey == null ? 0 : oKey.hashCode();
        while (true) {
            Entry[] aeBucket = this.getStableBucketArray();
            int cBuckets = aeBucket.length;
            int nBucket = this.getBucketIndex(nHash, cBuckets);
            if (fLock) {
                this.lockBucket(nBucket);
            }
            try {
                if (aeBucket != this.m_aeBucket) continue;
                Entry entryCur = aeBucket[nBucket];
                Entry entryPrev = null;
                while (entryCur != null) {
                    Entry entryNext = entryCur.nextEntry(true);
                    if (nHash == entryCur.m_nHash && Base.equals(oKey, entryCur.getKey())) {
                        Object object = action.invokeFound(oKey, oContext, aeBucket, nBucket, entryPrev, entryCur);
                        return object;
                    }
                    entryPrev = entryCur;
                    entryCur = entryNext;
                }
                Object object = action.invokeNotFound(oKey, oContext, aeBucket, nBucket);
                return object;
            }
            finally {
                if (!fLock) continue;
                this.unlockBucket(nBucket);
                continue;
            }
            break;
        }
    }

    protected int getBucketIndex(int nHash, int cBuckets) {
        return (int)(((long)nHash & 0xFFFFFFFFL) % (long)cBuckets);
    }

    protected int getSegmentIndex(int nBucket) {
        return nBucket % 61;
    }

    protected Segment getSegmentForKey(Object oKey) {
        Entry[] aeBucket = this.getStableBucketArray();
        int cBuckets = aeBucket.length;
        int nHash = oKey == null ? 0 : oKey.hashCode();
        int nBucket = this.getBucketIndex(nHash, cBuckets);
        return this.m_aSegment[this.getSegmentIndex(nBucket)];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Entry[] getStableBucketArray() {
        Entry[] aeBucket = this.m_aeBucket;
        if (aeBucket == NO_ENTRIES) {
            Object object = this.RESIZING;
            synchronized (object) {
                return this.m_aeBucket;
            }
        }
        return aeBucket;
    }

    protected synchronized void iteratorActivated(Iterator iter) {
        Object oIterActive = this.m_oIterActive;
        if (oIterActive == null) {
            this.m_oIterActive = new WeakReference<Iterator>(iter);
        } else if (oIterActive instanceof WeakReference) {
            Object oPrev = ((WeakReference)oIterActive).get();
            if (oPrev == null) {
                this.m_oIterActive = new WeakReference<Iterator>(iter);
            } else {
                WeakHashMap<Object, Object> map;
                this.m_oIterActive = map = new WeakHashMap<Object, Object>();
                map.put(oPrev, null);
                map.put(iter, null);
            }
        } else {
            ((Map)oIterActive).put(iter, null);
        }
    }

    public synchronized void releaseIterator(Iterator iter) {
        Object oIterActive = this.m_oIterActive;
        if (oIterActive instanceof WeakReference) {
            if (((WeakReference)oIterActive).get() == iter) {
                this.m_oIterActive = null;
            }
        } else {
            ((Map)oIterActive).remove(iter);
        }
    }

    protected synchronized boolean isActiveIterator() {
        Object oIterActive = this.m_oIterActive;
        if (oIterActive == null) {
            return false;
        }
        if (oIterActive instanceof WeakReference) {
            return ((WeakReference)oIterActive).get() != null;
        }
        return !((Map)oIterActive).isEmpty();
    }

    protected boolean lockBucket(int nBucket) {
        return this.lockSegment(this.getSegmentIndex(nBucket), true);
    }

    protected boolean lockSegment(int nSegment, boolean fBlock) {
        AtomicLong atomicLocks = this.m_atomicLocks;
        long maskLock = 1L << nSegment;
        if (atomicLocks.compareAndSet(0L, maskLock)) {
            return true;
        }
        int cAttempts = 0;
        while (true) {
            long lLocks;
            if (((lLocks = atomicLocks.get()) & (0x2000000000000000L | maskLock)) != 0L) {
                if (fBlock) {
                    if (++cAttempts % 15 != 0) continue;
                    this.contendForSegment(nSegment);
                    continue;
                }
                return false;
            }
            if (atomicLocks.compareAndSet(lLocks, lLocks | maskLock)) break;
        }
        return true;
    }

    protected void unlockBucket(int nBucket) {
        this.unlockSegment(this.getSegmentIndex(nBucket));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlockSegment(int nSegment) {
        long maskLock = 1L << nSegment;
        AtomicLong atomicLocks = this.m_atomicLocks;
        long lLocks = maskLock;
        while (!atomicLocks.compareAndSet(lLocks, lLocks & (maskLock ^ 0xFFFFFFFFFFFFFFFFL))) {
            lLocks = atomicLocks.get();
        }
        Segment segment = this.m_aSegment[nSegment];
        if (segment.fContend) {
            Segment segment2 = segment;
            synchronized (segment2) {
                if (segment.fContend) {
                    segment.fContend = false;
                    segment.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void contendForSegment(int nSegment) {
        Segment segment;
        long maskLock = 1L << nSegment;
        Segment segment2 = segment = this.m_aSegment[nSegment];
        synchronized (segment2) {
            segment.fContend = true;
            if ((this.m_atomicLocks.get() & maskLock) == 0L) {
                return;
            }
            try {
                Blocking.wait(segment, 1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Base.ensureRuntimeException(e, "Segment lock interrupted");
            }
        }
    }

    protected void lockAllBuckets() {
        int cAttempts = 0;
        while (!this.lockAllSegments(0L)) {
            this.getStableBucketArray();
            if (++cAttempts % 15 != 0) continue;
            this.contendForSegment(61);
        }
    }

    protected boolean lockAllBuckets(int nBucketAlreadyLocked) {
        return this.lockAllSegments(1L << this.getSegmentIndex(nBucketAlreadyLocked));
    }

    protected void unlockAllBuckets() {
        this.unlockAllSegments(0L);
    }

    protected void unlockAllBuckets(int nBucketLeaveLocked) {
        this.unlockAllSegments(1L << this.getSegmentIndex(nBucketLeaveLocked));
    }

    protected boolean lockAllSegments(long lLocksHeld) {
        long lLocks;
        AtomicLong atomicLocks = this.m_atomicLocks;
        if (atomicLocks.compareAndSet(lLocksHeld, -1L)) {
            return true;
        }
        do {
            if (((lLocks = atomicLocks.get()) & 0x2000000000000000L) == 0L) continue;
            return false;
        } while (!atomicLocks.compareAndSet(lLocks, lLocks | 0x2000000000000000L));
        lLocksHeld |= 0x2000000000000000L;
        int cAttempts = 0;
        while (lLocksHeld != -1L) {
            long lLocks2 = atomicLocks.get();
            if (atomicLocks.compareAndSet(lLocks2, -1L)) {
                lLocksHeld |= lLocks2 ^ 0xFFFFFFFFFFFFFFFFL;
                continue;
            }
            if (++cAttempts % 15 != 0) continue;
            Thread.yield();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlockAllSegments(long lLocksKeep) {
        if (!this.m_atomicLocks.compareAndSet(-1L, lLocksKeep)) {
            throw new IllegalStateException();
        }
        Segment[] aSegment = this.m_aSegment;
        for (int i = 0; i < 62; ++i) {
            long maskLock = 1L << i;
            Segment segment = aSegment[i];
            if ((lLocksKeep & maskLock) != 0L || !segment.fContend) continue;
            Segment segment2 = segment;
            synchronized (segment2) {
                if (segment.fContend) {
                    segment.fContend = false;
                    segment.notifyAll();
                }
                continue;
            }
        }
    }

    protected GetEntryAction instantiateGetEntryAction() {
        return new GetEntryAction();
    }

    protected InsertAction instantiateInsertAction() {
        return new InsertAction();
    }

    protected RemoveAction instantiateRemoveAction() {
        return new RemoveAction();
    }

    protected ContainsValueAction instantiateContainsValueAction() {
        return new ContainsValueAction();
    }

    protected Entry instantiateEntry(Object oKey, Object oValue, int nHash) {
        return new Entry(oKey, oValue, nHash);
    }

    protected static Entry entryFromBucket(Entry[] aeBucket, int nBucket) {
        Entry entry = aeBucket[nBucket];
        return entry != null && entry.isSynthetic() ? entry.nextEntry() : entry;
    }

    protected EntrySet instantiateEntrySet() {
        return new EntrySet();
    }

    protected KeySet instantiateKeySet() {
        return new KeySet();
    }

    protected ValuesCollection instantiateValuesCollection() {
        return new ValuesCollection();
    }

    protected static class Entry
    extends Base
    implements Map.Entry {
        protected final Object m_oKey;
        protected volatile Object m_oValue;
        protected final int m_nHash;
        protected volatile Entry m_eNext;

        protected Entry(Object oKey, Object oValue, int nHash) {
            this.m_oKey = oKey;
            this.m_oValue = oValue;
            this.m_nHash = nHash;
        }

        public Object getKey() {
            return this.m_oKey;
        }

        public Object getValue() {
            Object oValue = this.m_oValue;
            return oValue == NO_VALUE ? null : oValue;
        }

        protected Object getValueInternal() {
            return this.m_oValue;
        }

        public Object setValue(Object oValue) {
            Object oPrev = this.setValueInternal(oValue);
            return oPrev == NO_VALUE ? null : oPrev;
        }

        protected Object setValueInternal(Object oValue) {
            Object oPrev = this.m_oValue;
            this.m_oValue = oValue;
            return oPrev;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry that = (Map.Entry)o;
                return this == that || Base.equals(this.getKey(), that.getKey()) && Base.equals(this.getValue(), that.getValue());
            }
            return false;
        }

        @Override
        public int hashCode() {
            Object oKey = this.m_oKey;
            Object oValue = this.getValue();
            return (oKey == null ? 0 : this.m_nHash) ^ (oValue == null ? 0 : oValue.hashCode());
        }

        public String toString() {
            return "key=\"" + String.valueOf(this.getKey()) + "\", value=\"" + String.valueOf(this.getValue()) + "\"";
        }

        protected boolean isSynthetic() {
            return false;
        }

        protected void setNext(Entry eNext) {
            this.m_eNext = eNext;
        }

        protected Entry nextEntry() {
            return this.nextEntry(false);
        }

        protected Entry nextEntry(boolean fSynthetic) {
            Entry eNext = this.m_eNext;
            while (eNext != null && !fSynthetic && eNext.isSynthetic()) {
                eNext = eNext.m_eNext;
            }
            return eNext;
        }
    }

    protected static class Segment {
        protected int cEntries;
        protected volatile boolean fContend;

        protected Segment() {
        }
    }

    protected class InsertAction
    implements EntryAction {
        protected InsertAction() {
        }

        @Override
        public Object invokeFound(Object oKey, Object oContext, Entry[] aeBucket, int nBucket, Entry entryPrev, Entry entryCur) {
            if (entryCur.isSynthetic()) {
                entryCur.setValueInternal(oContext);
                return entryCur;
            }
            return NO_VALUE;
        }

        @Override
        public Object invokeNotFound(Object oKey, Object oContext, Entry[] aeBucket, int nBucket) {
            Object oValue = oContext;
            int nHash = oKey == null ? 0 : oKey.hashCode();
            Entry entry = SegmentedHashMap.this.instantiateEntry(oKey, oValue, nHash);
            entry.setNext(aeBucket[nBucket]);
            aeBucket[nBucket] = entry;
            ++SegmentedHashMap.this.m_aSegment[SegmentedHashMap.this.getSegmentIndex((int)nBucket)].cEntries;
            return entry;
        }
    }

    protected class GetEntryAction
    implements EntryAction {
        protected GetEntryAction() {
        }

        @Override
        public Object invokeFound(Object oKey, Object oContext, Entry[] aeBucket, int nBucket, Entry entryPrev, Entry entryCur) {
            boolean fSynthetic = oContext == Boolean.TRUE;
            return fSynthetic || !entryCur.isSynthetic() ? entryCur : null;
        }

        @Override
        public Object invokeNotFound(Object oKey, Object oContext, Entry[] aeBucket, int nBucket) {
            return aeBucket == SegmentedHashMap.this.m_aeBucket ? null : NO_VALUE;
        }
    }

    protected class RemoveAction
    extends EntryActionAdapter {
        protected RemoveAction() {
        }

        @Override
        public Object invokeFound(Object oKey, Object oContext, Entry[] aeBucket, int nBucket, Entry entryPrev, Entry entryCur) {
            Entry entryNext = entryCur.nextEntry(true);
            if (entryPrev == null) {
                aeBucket[nBucket] = entryNext;
            } else {
                entryPrev.setNext(entryNext);
            }
            --SegmentedHashMap.this.m_aSegment[SegmentedHashMap.this.getSegmentIndex((int)nBucket)].cEntries;
            return entryCur.getValueInternal();
        }
    }

    protected static class ContainsValueAction
    extends EntryActionAdapter {
        protected ContainsValueAction() {
        }

        @Override
        public Object invokeFound(Object oKey, Object oContext, Entry[] aeBucket, int nBucket, Entry entryPrev, Entry entryCur) {
            ContainsValueContext context = (ContainsValueContext)oContext;
            if (Base.equals(entryCur.getValue(), context.m_oValue)) {
                context.m_fFound = true;
            }
            return NO_VALUE;
        }

        @Override
        public boolean isComplete(Object oContext) {
            return this.isFound(oContext);
        }

        public boolean isFound(Object oContext) {
            return ((ContainsValueContext)oContext).m_fFound;
        }

        public Object instantiateContext(Object oValue) {
            ContainsValueContext oContext = new ContainsValueContext();
            oContext.m_oValue = oValue;
            return oContext;
        }

        private static class ContainsValueContext {
            private boolean m_fFound;
            private Object m_oValue;

            private ContainsValueContext() {
            }
        }
    }

    protected static interface IterableEntryAction
    extends EntryAction {
        public boolean isComplete(Object var1);
    }

    protected static interface EntryAction {
        public Object invokeFound(Object var1, Object var2, Entry[] var3, int var4, Entry var5, Entry var6);

        public Object invokeNotFound(Object var1, Object var2, Entry[] var3, int var4);
    }

    protected class EntrySet
    extends AbstractSet {
        protected EntrySet() {
        }

        @Override
        public Iterator iterator() {
            return SegmentedHashMap.this.isEmpty() ? NullImplementation.getIterator() : this.instantiateIterator();
        }

        @Override
        public int size() {
            return SegmentedHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry thatEntry = (Map.Entry)o;
                Entry thisEntry = SegmentedHashMap.this.getEntryInternal(thatEntry.getKey());
                return thisEntry != null && thisEntry.equals(thatEntry);
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (this.contains(o)) {
                SegmentedHashMap.this.remove(((Map.Entry)o).getKey());
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            SegmentedHashMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            return this.toArray((Object[])null);
        }

        @Override
        public Object[] toArray(Object[] ao) {
            SegmentedHashMap map = SegmentedHashMap.this;
            EntryActionAdapter actionEntry = new EntryActionAdapter(){

                @Override
                public Object invokeFound(Object oKey, Object oContext, Entry[] aeBucket, int nBucket, Entry entryPrev, Entry entryCur) {
                    if (!entryCur.isSynthetic()) {
                        ((List)oContext).add(entryCur);
                    }
                    return NO_VALUE;
                }
            };
            return map.toArrayInternal(actionEntry, ao);
        }

        protected Iterator instantiateIterator() {
            return new EntrySetIterator();
        }

        protected class EntrySetIterator
        extends AbstractStableIterator {
            private Entry[] m_aeBucket;
            private int m_iBucket = -1;
            private Entry m_entryPrev;
            private boolean m_fDeactivated;

            protected EntrySetIterator() {
            }

            @Override
            protected void advance() {
                if (this.m_fDeactivated) {
                    return;
                }
                Entry[] aeBucket = this.m_aeBucket;
                if (aeBucket == null) {
                    SegmentedHashMap map = SegmentedHashMap.this;
                    map.iteratorActivated(this);
                    this.m_aeBucket = map.getStableBucketArray();
                    aeBucket = this.m_aeBucket;
                }
                Entry entry = this.m_entryPrev;
                int iBucket = -1;
                int cBuckets = aeBucket.length;
                if (entry != null) {
                    entry = entry.nextEntry();
                }
                if (entry == null) {
                    iBucket = this.m_iBucket;
                    do {
                        if (++iBucket < cBuckets) continue;
                        this.deactivate();
                        return;
                    } while ((entry = SegmentedHashMap.entryFromBucket(aeBucket, iBucket)) == null);
                }
                if (iBucket >= 0) {
                    this.m_iBucket = iBucket;
                }
                this.m_entryPrev = entry;
                this.setNext(entry);
            }

            protected void remove(Object oPrev) {
                SegmentedHashMap.this.remove(((Map.Entry)oPrev).getKey());
            }

            protected void deactivate() {
                if (!this.m_fDeactivated) {
                    SegmentedHashMap.this.releaseIterator(this);
                    this.m_fDeactivated = true;
                    this.m_aeBucket = null;
                    this.m_entryPrev = null;
                }
            }
        }
    }

    protected class KeySet
    extends AbstractSet {
        protected KeySet() {
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){
                private Iterator m_iter;
                {
                    this.m_iter = SegmentedHashMap.this.entrySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.m_iter.hasNext();
                }

                public Object next() {
                    return ((Map.Entry)this.m_iter.next()).getKey();
                }

                @Override
                public void remove() {
                    this.m_iter.remove();
                }
            };
        }

        @Override
        public int size() {
            return SegmentedHashMap.this.size();
        }

        @Override
        public boolean contains(Object oKey) {
            return SegmentedHashMap.this.containsKey(oKey);
        }

        @Override
        public boolean remove(Object o) {
            SegmentedHashMap map = SegmentedHashMap.this;
            if (map.containsKey(o)) {
                map.remove(o);
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            SegmentedHashMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            return this.toArray((Object[])null);
        }

        @Override
        public Object[] toArray(Object[] a) {
            SegmentedHashMap map = SegmentedHashMap.this;
            EntryActionAdapter actionEntry = new EntryActionAdapter(){

                @Override
                public Object invokeFound(Object oKey, Object oContext, Entry[] aeBucket, int nBucket, Entry entryPrev, Entry entryCur) {
                    if (!entryCur.isSynthetic()) {
                        ((List)oContext).add(entryCur.getKey());
                    }
                    return NO_VALUE;
                }
            };
            return map.toArrayInternal(actionEntry, a);
        }
    }

    protected class ValuesCollection
    extends AbstractCollection {
        protected ValuesCollection() {
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){
                private Iterator m_iter;
                {
                    this.m_iter = SegmentedHashMap.this.entrySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.m_iter.hasNext();
                }

                public Object next() {
                    return ((Entry)this.m_iter.next()).getValue();
                }

                @Override
                public void remove() {
                    this.m_iter.remove();
                }
            };
        }

        @Override
        public int size() {
            return SegmentedHashMap.this.size();
        }

        @Override
        public void clear() {
            SegmentedHashMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            return this.toArray((Object[])null);
        }

        @Override
        public Object[] toArray(Object[] ao) {
            SegmentedHashMap map = SegmentedHashMap.this;
            EntryActionAdapter actionEntry = new EntryActionAdapter(){

                @Override
                public Object invokeFound(Object oKey, Object oContext, Entry[] aeBucket, int nBucket, Entry entryPrev, Entry entryCur) {
                    if (!entryCur.isSynthetic()) {
                        ((List)oContext).add(entryCur.getValue());
                    }
                    return NO_VALUE;
                }
            };
            return map.toArrayInternal(actionEntry, ao);
        }
    }

    protected static abstract class EntryActionAdapter
    implements EntryAction,
    IterableEntryAction {
        protected EntryActionAdapter() {
        }

        @Override
        public Object invokeFound(Object oKey, Object oContext, Entry[] aeBucket, int nBucket, Entry entryPrev, Entry entryCur) {
            return NO_VALUE;
        }

        @Override
        public Object invokeNotFound(Object oKey, Object oContext, Entry[] aeBucket, int nBucket) {
            return NO_VALUE;
        }

        @Override
        public boolean isComplete(Object oContext) {
            return false;
        }
    }
}

