/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.Logger;
import com.tangosol.util.Base;
import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.Gate;
import com.tangosol.util.SegmentedHashMap;
import com.tangosol.util.WrapperReentrantGate;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class SegmentedConcurrentMap
extends SegmentedHashMap
implements ConcurrentMap,
java.util.concurrent.ConcurrentMap {
    protected static AtomicReferenceFieldUpdater m_atomicUpdaterValue;
    protected Gate m_gateLockAll = new WrapperReentrantGate();
    protected LockAction m_actionLock;
    protected UnlockAction m_actionUnlock;
    protected SizeAction m_actionSize;
    protected ConditionalRemoveAction m_actionConditionalRemove;
    protected TruncateAction m_actionTruncate;
    protected DumpHeldLocksAction m_actionDumpHeldLocks;
    protected ContentionObserver m_contentionObserver;

    public SegmentedConcurrentMap() {
    }

    public SegmentedConcurrentMap(ContentionObserver contentionObserver) {
        this.setContentionObserver(contentionObserver);
    }

    public SegmentedConcurrentMap(int cInitialBuckets, float flLoadFactor, float flGrowthRate) {
        this(cInitialBuckets, flLoadFactor, flGrowthRate, null);
    }

    public SegmentedConcurrentMap(int cInitialBuckets, float flLoadFactor, float flGrowthRate, ContentionObserver contentionObserver) {
        super(cInitialBuckets, flLoadFactor, flGrowthRate);
        this.setContentionObserver(contentionObserver);
    }

    protected LockAction getLockAction() {
        return this.m_actionLock;
    }

    protected void setLockAction(LockAction action) {
        this.m_actionLock = action;
    }

    protected UnlockAction getUnlockAction() {
        return this.m_actionUnlock;
    }

    protected void setUnlockAction(UnlockAction action) {
        this.m_actionUnlock = action;
    }

    protected SizeAction getSizeAction() {
        return this.m_actionSize;
    }

    protected void setSizeAction(SizeAction action) {
        this.m_actionSize = action;
    }

    protected ConditionalRemoveAction getConditionalRemoveAction() {
        return this.m_actionConditionalRemove;
    }

    protected void setConditionalRemoveAction(ConditionalRemoveAction action) {
        this.m_actionConditionalRemove = action;
    }

    protected void setTruncateAction(TruncateAction action) {
        this.m_actionTruncate = action;
    }

    protected void setDumpHeldLocksAction(DumpHeldLocksAction action) {
        this.m_actionDumpHeldLocks = action;
    }

    public ContentionObserver getContentionObserver() {
        return this.m_contentionObserver;
    }

    protected void setContentionObserver(ContentionObserver contentionObserver) {
        this.m_contentionObserver = contentionObserver;
    }

    @Override
    public void clear() {
        this.invokeOnAllKeys(null, true, this.getRemoveAction());
    }

    @Override
    public int size() {
        Object oContext;
        SegmentedHashMap.Entry[] aeBucket;
        SizeAction actionSize = this.getSizeAction();
        do {
            aeBucket = this.getStableBucketArray();
            oContext = actionSize.instantiateContext(false);
            this.invokeOnAllKeys(oContext, false, actionSize);
        } while (aeBucket != this.getStableBucketArray());
        return actionSize.size(oContext);
    }

    @Override
    public boolean isEmpty() {
        SegmentedHashMap.Entry[] aeBucket;
        SizeAction actionSize = this.getSizeAction();
        do {
            aeBucket = this.getStableBucketArray();
            Object oContext = actionSize.instantiateContext(true);
            this.invokeOnAllKeys(oContext, false, actionSize);
            if (actionSize.size(oContext) <= 0) continue;
            return false;
        } while (aeBucket != this.getStableBucketArray());
        return true;
    }

    @Override
    public Object putIfAbsent(Object oKey, Object oValue) {
        Object oOrig = this.putInternal(oKey, oValue, true);
        return oOrig == NO_VALUE ? null : oOrig;
    }

    @Override
    public boolean replace(Object oKey, Object oValueOld, Object oValueNew) {
        LockableEntry entry = (LockableEntry)this.getEntryInternal(oKey, false);
        return entry != null && entry.casValueInternal(oValueOld, oValueNew);
    }

    @Override
    public Object replace(Object oKey, Object oValue) {
        LockableEntry entry = (LockableEntry)this.getEntryInternal(oKey, false);
        if (entry != null) {
            Object oCurrent;
            while ((oCurrent = entry.getValueInternal()) != NO_VALUE) {
                if (!entry.casValueInternal(oCurrent, oValue)) continue;
                return oCurrent;
            }
        }
        return null;
    }

    @Override
    public boolean remove(Object oKey, Object oValue) {
        Object oValueOld = this.removeInternal(oKey, this.getConditionalRemoveAction(), oValue);
        return oValueOld != NO_VALUE;
    }

    @Override
    public boolean lock(Object oKey) {
        return this.lock(oKey, 0L);
    }

    @Override
    public boolean lock(Object oKey, long cWait) {
        if (oKey == LOCK_ALL) {
            return this.m_gateLockAll.close(cWait);
        }
        if (!this.m_gateLockAll.enter(cWait)) {
            return false;
        }
        Thread thdCurrent = Thread.currentThread();
        boolean fSuccess = false;
        try {
            while (true) {
                Object oResult;
                if ((oResult = this.invokeOnKey(oKey, thdCurrent, true, this.getLockAction())) == NO_VALUE) {
                    this.ensureLoadFactor(this.getSegmentForKey(oKey));
                    fSuccess = true;
                    boolean bl = true;
                    return bl;
                }
                if (cWait == 0L) {
                    boolean bl = false;
                    return bl;
                }
                cWait = ((LockableEntry)oResult).waitForNotify(cWait, this.getContentionObserver());
            }
        }
        finally {
            if (!fSuccess) {
                this.m_gateLockAll.exit();
            }
        }
    }

    @Override
    public boolean unlock(Object oKey) {
        if (oKey == LOCK_ALL) {
            try {
                this.m_gateLockAll.open();
                return true;
            }
            catch (IllegalMonitorStateException e) {
                return false;
            }
        }
        Object oResult = this.invokeOnKey(oKey, Thread.currentThread(), true, this.getUnlockAction());
        boolean fReleased = (Boolean)oResult;
        if (fReleased) {
            try {
                this.m_gateLockAll.exit();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return fReleased;
    }

    @Override
    protected void initializeActions() {
        super.initializeActions();
        this.setLockAction(this.instantiateLockAction());
        this.setUnlockAction(this.instantiateUnlockAction());
        this.setSizeAction(this.instantiateSizeAction());
        this.setConditionalRemoveAction(this.instantiateConditionalRemoveAction());
        this.setTruncateAction(this.instantiateTruncateAction());
        this.setDumpHeldLocksAction(this.instantiateDumpHeldLocksAction());
    }

    public void truncate() {
        this.invokeOnAllKeys(null, false, new TruncateAction());
        this.clear();
    }

    public void dumpHeldLocks() {
        this.invokeOnAllKeys(null, false, new DumpHeldLocksAction());
    }

    @Override
    protected SegmentedHashMap.RemoveAction instantiateRemoveAction() {
        return new RemoveAction();
    }

    protected ConditionalRemoveAction instantiateConditionalRemoveAction() {
        return new ConditionalRemoveAction();
    }

    protected LockAction instantiateLockAction() {
        return new LockAction();
    }

    protected UnlockAction instantiateUnlockAction() {
        return new UnlockAction();
    }

    protected SizeAction instantiateSizeAction() {
        return new SizeAction();
    }

    protected TruncateAction instantiateTruncateAction() {
        return new TruncateAction();
    }

    protected DumpHeldLocksAction instantiateDumpHeldLocksAction() {
        return new DumpHeldLocksAction();
    }

    @Override
    protected SegmentedHashMap.Entry instantiateEntry(Object oKey, Object oValue, int nHash) {
        return new LockableEntry(oKey, oValue, nHash);
    }

    public static boolean isAlive(Thread t) {
        if (!t.isAlive()) {
            return false;
        }
        StackTraceElement[] arElement = t.getStackTrace();
        if (!Arrays.stream(arElement).anyMatch(e -> e.getClassName().endsWith(".Daemon") && e.getMethodName().compareTo("run") == 0)) {
            return true;
        }
        return !Arrays.stream(arElement).anyMatch(e -> e.getClassName().endsWith(".Daemon") && e.getMethodName().compareTo("onWait") == 0);
    }

    public static interface ContentionObserver {
        public void onContend(Object var1, LockableEntry var2);

        public void onUncontend(Object var1, LockableEntry var2);
    }

    protected class LockAction
    implements SegmentedHashMap.EntryAction {
        protected LockAction() {
        }

        @Override
        public Object invokeFound(Object oKey, Object oContext, SegmentedHashMap.Entry[] aeBucket, int nBucket, SegmentedHashMap.Entry entryPrev, SegmentedHashMap.Entry entryCur) {
            Object oHolder = oContext;
            LockableEntry entry = (LockableEntry)entryCur;
            if (!entry.isLocked() || entry.m_oLockHolder == oHolder) {
                entry.lock(oHolder);
                return SegmentedHashMap.NO_VALUE;
            }
            return entry;
        }

        @Override
        public Object invokeNotFound(Object oKey, Object oContext, SegmentedHashMap.Entry[] aeBucket, int nBucket) {
            ((LockableEntry)SegmentedConcurrentMap.this.getInsertAction().invokeNotFound(oKey, SegmentedHashMap.NO_VALUE, aeBucket, nBucket)).lock(oContext);
            return SegmentedHashMap.NO_VALUE;
        }
    }

    protected class UnlockAction
    extends SegmentedHashMap.EntryActionAdapter {
        protected UnlockAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invokeFound(Object oKey, Object oContext, SegmentedHashMap.Entry[] aeBucket, int nBucket, SegmentedHashMap.Entry entryPrev, SegmentedHashMap.Entry entryCur) {
            LockableEntry entry = (LockableEntry)entryCur;
            if (!entry.isLocked() || entry.m_oLockHolder != oContext) {
                return Boolean.FALSE;
            }
            if (entry.unlock()) {
                LockableEntry lockableEntry = entry;
                synchronized (lockableEntry) {
                    if (entry.isContended()) {
                        entry.notify();
                        return Boolean.TRUE;
                    }
                }
                if (entry.isSynthetic()) {
                    SegmentedConcurrentMap.this.getRemoveAction().invokeFound(oKey, oContext, aeBucket, nBucket, entryPrev, entry);
                }
            }
            return Boolean.TRUE;
        }

        @Override
        public Object invokeNotFound(Object oKey, Object oContext, SegmentedHashMap.Entry[] aeBucket, int nBucket) {
            return Boolean.FALSE;
        }
    }

    protected static class SizeAction
    extends SegmentedHashMap.EntryActionAdapter {
        protected SizeAction() {
        }

        @Override
        public Object invokeFound(Object oKey, Object oContext, SegmentedHashMap.Entry[] aeBucket, int nBucket, SegmentedHashMap.Entry entryPrev, SegmentedHashMap.Entry entryCur) {
            if (!entryCur.isSynthetic()) {
                ++((SizeContext)oContext).m_cEntries;
            }
            return SegmentedHashMap.NO_VALUE;
        }

        @Override
        public boolean isComplete(Object oContext) {
            SizeContext sizeContext = (SizeContext)oContext;
            return sizeContext.m_fEmptyCheck && sizeContext.m_cEntries > 0;
        }

        public int size(Object oContext) {
            return ((SizeContext)oContext).m_cEntries;
        }

        public Object instantiateContext(boolean fEmptyCheck) {
            SizeContext oContext = new SizeContext();
            oContext.m_fEmptyCheck = fEmptyCheck;
            return oContext;
        }

        private static class SizeContext {
            private boolean m_fEmptyCheck;
            private int m_cEntries;

            private SizeContext() {
            }
        }
    }

    protected class ConditionalRemoveAction
    extends SegmentedHashMap.RemoveAction {
        protected ConditionalRemoveAction() {
            super(SegmentedConcurrentMap.this);
        }

        @Override
        public Object invokeFound(Object oKey, Object oContext, SegmentedHashMap.Entry[] aeBucket, int nBucket, SegmentedHashMap.Entry entryPrev, SegmentedHashMap.Entry entryCur) {
            LockableEntry entry = (LockableEntry)entryCur;
            if (oContext == SegmentedHashMap.NO_VALUE) {
                Object oCurrent;
                while ((oCurrent = entry.getValueInternal()) != SegmentedHashMap.NO_VALUE) {
                    if (!entry.casValueInternal(oCurrent, SegmentedHashMap.NO_VALUE)) continue;
                    return super.invokeFound(oKey, oContext, aeBucket, nBucket, entryPrev, entryCur);
                }
            } else if (entry.casValueInternal(oContext, SegmentedHashMap.NO_VALUE)) {
                super.invokeFound(oKey, oContext, aeBucket, nBucket, entryPrev, entryCur);
                return oContext;
            }
            return SegmentedHashMap.NO_VALUE;
        }
    }

    protected class TruncateAction
    extends SegmentedHashMap.EntryActionAdapter {
        protected TruncateAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invokeFound(Object oKey, Object oContext, SegmentedHashMap.Entry[] aeBucket, int nBucket, SegmentedHashMap.Entry entryPrev, SegmentedHashMap.Entry entryCur) {
            LockableEntry entry = (LockableEntry)entryCur;
            Object lockHolder = entry.getLockHolder();
            if (lockHolder != null && lockHolder instanceof Thread) {
                try {
                    Thread thread = (Thread)lockHolder;
                    thread.interrupt();
                    Logger.fine("TruncateAction: interrupted lock holder thread: " + thread.getName() + " holding lock on key: " + String.valueOf(entry.getKey()) + " LockableEntry@" + Integer.toHexString(System.identityHashCode(entry)));
                    entry.m_cLock = 0;
                    entry.m_oLockHolder = null;
                    LockableEntry lockableEntry = entry;
                    synchronized (lockableEntry) {
                        if (entry.isContended()) {
                            entry.notify();
                        }
                    }
                    return Boolean.TRUE;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return Boolean.FALSE;
        }

        @Override
        public Object invokeNotFound(Object oKey, Object oContext, SegmentedHashMap.Entry[] aeBucket, int nBucket) {
            return Boolean.FALSE;
        }
    }

    protected class DumpHeldLocksAction
    extends SegmentedHashMap.EntryActionAdapter {
        protected DumpHeldLocksAction() {
        }

        @Override
        public Object invokeFound(Object oKey, Object oContext, SegmentedHashMap.Entry[] aeBucket, int nBucket, SegmentedHashMap.Entry entryPrev, SegmentedHashMap.Entry entryCur) {
            LockableEntry entry = (LockableEntry)entryCur;
            Object lockHolder = entry.getLockHolder();
            if (lockHolder != null && lockHolder instanceof Thread) {
                try {
                    Thread thread = (Thread)lockHolder;
                    Logger.info("SegmentedConcurrentMap.dump: LockableEntry@" + Integer.toHexString(System.identityHashCode(entry)) + " key=" + String.valueOf(entry.getKey()) + " lock count=" + entry.m_cLock + " owner: [" + String.valueOf(thread) + "] contend:" + entry.m_cContend + " isThreadAlive: " + SegmentedConcurrentMap.isAlive(thread));
                    return Boolean.TRUE;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return Boolean.FALSE;
        }

        @Override
        public Object invokeNotFound(Object oKey, Object oContext, SegmentedHashMap.Entry[] aeBucket, int nBucket) {
            return Boolean.FALSE;
        }
    }

    public class LockableEntry
    extends SegmentedHashMap.Entry {
        protected volatile Object m_oLockHolder;
        protected volatile short m_cLock;
        protected volatile short m_cContend;

        protected LockableEntry(Object oKey, Object oValue, int nHash) {
            super(oKey, oValue, nHash);
            this.m_oLockHolder = null;
        }

        public Object getLockHolder() {
            return this.m_oLockHolder;
        }

        public SegmentedConcurrentMap getSource() {
            return SegmentedConcurrentMap.this;
        }

        public boolean isContended() {
            return this.m_cContend > 0;
        }

        @Override
        protected Object setValueInternal(Object oValue) {
            Object oValueOld;
            AtomicReferenceFieldUpdater atomicUpdater = this.getAtomicUpdaterValue();
            while (!atomicUpdater.compareAndSet(this, oValueOld = m_atomicUpdaterValue.get(this), oValue)) {
            }
            return oValueOld;
        }

        @Override
        protected boolean isSynthetic() {
            return this.m_oValue == SegmentedHashMap.NO_VALUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized long waitForNotify(long cWait, ContentionObserver observer) {
            Thread thdCurrent = Thread.currentThread();
            try {
                this.m_cContend = (short)(this.m_cContend + 1);
                if (observer != null) {
                    observer.onContend(thdCurrent, this);
                }
                while (cWait != 0L && this.isLocked()) {
                    cWait = this.waitForNotify(cWait);
                }
            }
            finally {
                this.m_cContend = (short)(this.m_cContend - 1);
                if (observer != null) {
                    observer.onUncontend(thdCurrent, this);
                }
            }
            return cWait;
        }

        protected long waitForNotify(long cWait) {
            Object oHolder;
            long lTime = Base.getSafeTimeMillis();
            try {
                long cMaxWait = 1000L;
                long cMillis = cWait <= 0L || cWait > cMaxWait ? cMaxWait : cWait;
                Blocking.wait(this, cMillis);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Base.ensureRuntimeException(e, "Lock request interrupted");
            }
            if (cWait >= 0L) {
                cWait -= Base.getSafeTimeMillis() - lTime;
                cWait = Math.max(0L, cWait);
            }
            if ((oHolder = this.m_oLockHolder) instanceof Thread && !((Thread)oHolder).isAlive()) {
                this.m_cLock = 0;
                this.m_oLockHolder = null;
            }
            return cWait;
        }

        protected void lock(Object oHolder) {
            this.m_oLockHolder = oHolder;
            this.m_cLock = (short)(this.m_cLock + 1);
        }

        protected boolean unlock() {
            this.m_cLock = (short)(this.m_cLock - 1);
            if (this.m_cLock == 0) {
                this.m_oLockHolder = null;
                return true;
            }
            return false;
        }

        protected boolean casValueInternal(Object oValueAssume, Object oValue) {
            return this.getAtomicUpdaterValue().compareAndSet(this, oValueAssume, oValue);
        }

        @Override
        public String toString() {
            return super.toString() + (String)(this.isLocked() ? ", locked by " + String.valueOf(this.m_oLockHolder) : "");
        }

        protected boolean isLocked() {
            return this.m_oLockHolder != null;
        }

        private AtomicReferenceFieldUpdater getAtomicUpdaterValue() {
            AtomicReferenceFieldUpdater<SegmentedHashMap.Entry, Object> atomicUpdater = m_atomicUpdaterValue;
            if (atomicUpdater == null) {
                m_atomicUpdaterValue = atomicUpdater = AtomicReferenceFieldUpdater.newUpdater(SegmentedHashMap.Entry.class, Object.class, "m_oValue");
            }
            return atomicUpdater;
        }
    }

    protected class RemoveAction
    extends SegmentedHashMap.RemoveAction {
        protected RemoveAction() {
            super(SegmentedConcurrentMap.this);
        }

        @Override
        public Object invokeFound(Object oKey, Object oContext, SegmentedHashMap.Entry[] aeBucket, int nBucket, SegmentedHashMap.Entry entryPrev, SegmentedHashMap.Entry entryCur) {
            LockableEntry entry = (LockableEntry)entryCur;
            if (entry.isLocked() || entry.isContended()) {
                return entryCur.setValueInternal(SegmentedHashMap.NO_VALUE);
            }
            return super.invokeFound(oKey, oContext, aeBucket, nBucket, entryPrev, entryCur);
        }
    }
}

