/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.oracle.coherence.common.base.Classes;
import com.tangosol.util.Base;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.ListResourceBundle;

public abstract class Resources
extends ListResourceBundle {
    public static final String DEFAULT_RESOURCE_PACKAGE = "/com/oracle/coherence/defaults";

    public String getString(String sKey, String sDefault) {
        return this.getString(sKey, null, sDefault);
    }

    public String getString(String sKey, String[] asParam, String sDefault) {
        Object sBase;
        try {
            sBase = this.getString(sKey);
        }
        catch (Exception e) {
            sBase = sDefault;
        }
        if (asParam != null && asParam.length > 0) {
            try {
                return MessageFormat.format((String)sBase, asParam);
            }
            catch (Exception e) {
                int c = asParam.length;
                for (int i = 0; i < c; ++i) {
                    sBase = (String)sBase + "\n[" + i + "]=\"" + (asParam[i] == null ? "<null>" : asParam[i]) + "\"";
                }
            }
        }
        return sBase;
    }

    public static URL findResource(String sName, ClassLoader loader) {
        return Resources.findResource(sName, loader, null);
    }

    public static URL findResourceOrDefault(String sName, ClassLoader loader) {
        return Resources.findResource(sName, loader, Resources.getDefaultName(sName));
    }

    public static URL findResource(String sName, ClassLoader loader, String sDefault) {
        URL url = Resources.findRelativeOrAbsoluteResource(sName, loader);
        if (url == null) {
            url = Resources.findRelativeOrAbsoluteResource(sName, Thread.currentThread().getContextClassLoader());
        }
        if (url == null) {
            url = Resources.findRelativeOrAbsoluteResource(sName, Base.class.getClassLoader());
        }
        if (url == null) {
            url = Resources.findRelativeOrAbsoluteResource(sName, ClassLoader.getSystemClassLoader());
        }
        if (url == null) {
            try {
                url = new URL(sName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (url == null && sDefault != null && !sDefault.isBlank()) {
            url = Resources.findResource(sDefault, loader, null);
        }
        return url;
    }

    public static Iterable<URL> findResources(String sName, ClassLoader loader) throws IOException {
        URL url = Resources.getFileURL(sName);
        if (url != null) {
            return Collections.singleton(url);
        }
        return Collections.list(Base.ensureClassLoader(loader).getResources(sName));
    }

    public static URL findRelativeOrAbsoluteResource(String sName, ClassLoader loader) {
        if (loader == null) {
            return null;
        }
        URL url = loader.getResource(sName);
        if (url == null) {
            url = sName.startsWith("/") ? loader.getResource(sName.substring(1)) : loader.getResource("/" + sName);
        }
        return url;
    }

    public static URL getFileURL(String sName) {
        URL url;
        block4: {
            url = null;
            try {
                File file = new File(sName);
                if (!file.exists()) break block4;
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException ioex) {
                    file = file.getAbsoluteFile();
                }
                url = file.toURI().toURL();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return url;
    }

    public static URL findFileOrResource(String sName, ClassLoader loader) {
        return Resources.findFileOrResource(sName, loader, null);
    }

    public static URL findFileOrResourceOrDefault(String sName, ClassLoader loader) {
        return Resources.findFileOrResource(sName, loader, Resources.getDefaultName(sName));
    }

    public static URL findFileOrResource(String sName, ClassLoader loader, String sDefault) {
        URL url = Resources.getFileURL(sName);
        return url == null ? Resources.findResource(sName, loader, sDefault) : url;
    }

    public static InputStream findInputStream(String s) throws IOException {
        URL url;
        String sScheme;
        URI uri = null;
        try {
            uri = URI.create(s);
            sScheme = uri.getScheme();
        }
        catch (Exception e) {
            sScheme = null;
        }
        ClassLoader loader = Classes.getContextClassLoader();
        if (sScheme == null || sScheme.isEmpty()) {
            url = Resources.findFileOrResource(s, null);
        } else {
            try {
                url = uri.toURL();
            }
            catch (MalformedURLException e) {
                url = Resources.findFileOrResource(s, null);
            }
        }
        InputStream in = loader.getResourceAsStream(url.getFile());
        if (in == null) {
            in = url.openStream();
        }
        return in;
    }

    private static String getDefaultName(String sName) {
        if (sName == null || sName.isBlank()) {
            return null;
        }
        if (sName.charAt(0) == '/') {
            return DEFAULT_RESOURCE_PACKAGE + sName;
        }
        return "/com/oracle/coherence/defaults/" + sName;
    }
}

