/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.oracle.coherence.common.util.AutoLock;
import com.oracle.coherence.common.util.NullLock;
import com.tangosol.util.AbstractSafeLongArray;
import com.tangosol.util.LongArray;
import com.tangosol.util.SparseArray;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ReadHeavyLongArray<V>
extends AbstractSafeLongArray<V> {
    private static final int CLONE_COST_MULTIPLIER = 1000;
    private LongArray<V> m_laDelegate;
    protected final AutoLock<LongArray<V>> f_lockWrite;
    protected final Lock f_lockReadRaw;
    protected volatile AutoLock<LongArray<V>> m_lockRead;
    protected long m_cReads;
    protected long m_cReadTrigger;

    public ReadHeavyLongArray() {
        this(new SparseArray());
    }

    public ReadHeavyLongArray(LongArray<V> delegate) {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.m_laDelegate = delegate;
        this.f_lockReadRaw = lock.readLock();
        this.m_lockRead = new AutoLock<LongArray<V>>(this.f_lockReadRaw, delegate);
        this.f_lockWrite = new AutoLock<LongArray<V>>(lock.writeLock()){

            @Override
            public LongArray<V> getResource() {
                return ReadHeavyLongArray.this.m_laDelegate;
            }
        };
    }

    @Override
    public ReadHeavyLongArray<V> clone() {
        try (AutoLock.Sentry<LongArray<V>> sentry = this.acquireReadLock();){
            ReadHeavyLongArray<V> readHeavyLongArray = new ReadHeavyLongArray<V>(sentry.getResource().clone());
            return readHeavyLongArray;
        }
    }

    @Override
    protected AutoLock.Sentry<LongArray<V>> acquireReadLock() {
        long cReadTrigger = this.m_cReadTrigger;
        if (++this.m_cReads >= cReadTrigger) {
            try (AutoLock.Sentry<LongArray<V>> sentry = this.f_lockWrite.acquire();){
                if (cReadTrigger == this.m_cReadTrigger) {
                    this.m_lockRead = new NullLock<LongArray<V>>(sentry.getResource());
                    this.m_cReadTrigger = Long.MAX_VALUE;
                }
            }
        }
        return this.m_lockRead.acquire();
    }

    @Override
    protected AutoLock.Sentry<LongArray<V>> acquireWriteLock() {
        AutoLock.Sentry<LongArray<V>> sentry = this.f_lockWrite.acquire();
        LongArray<V> delegate = sentry.getResource();
        if (this.m_lockRead instanceof NullLock) {
            delegate = delegate.clone();
            this.m_laDelegate = delegate;
            this.m_lockRead = new AutoLock<LongArray<V>>(this.f_lockReadRaw, delegate);
        }
        this.m_cReadTrigger = this.m_cReads + (long)(delegate.getSize() * 1000);
        return sentry;
    }

    @Override
    protected AbstractSafeLongArray.SafeIterator instantiateSafeIterator(boolean fForward, long lIndexFrom) {
        try (AutoLock.Sentry<LongArray<V>> sentry = this.acquireReadLock();){
            final LongArray<V> laDelegateStart = sentry.getResource();
            AbstractSafeLongArray.SafeIterator safeIterator = new AbstractSafeLongArray.SafeIterator(laDelegateStart, fForward, lIndexFrom){

                @Override
                public V setValue(V oValue) {
                    Object valueOld;
                    try (AutoLock.Sentry sentry = ReadHeavyLongArray.this.acquireWriteLock();){
                        LongArray laDelegateCurr = sentry.getResource();
                        valueOld = laDelegateStart == laDelegateCurr ? this.f_delegate.setValue(oValue) : laDelegateCurr.set(this.getIndex(), oValue);
                    }
                    this.m_valueLast = oValue;
                    return valueOld;
                }

                @Override
                public void remove() {
                    try (AutoLock.Sentry sentry = ReadHeavyLongArray.this.acquireWriteLock();){
                        LongArray laDelegateCurr = sentry.getResource();
                        if (laDelegateStart == laDelegateCurr) {
                            this.f_delegate.remove();
                        } else {
                            laDelegateCurr.remove(this.getIndex());
                        }
                        this.m_valueLast = AbstractSafeLongArray.NO_VALUE;
                    }
                }
            };
            return safeIterator;
        }
    }
}

