/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.coherence.config.ResolvableParameterList;
import com.tangosol.coherence.dslquery.CoherenceQueryLanguage;
import com.tangosol.coherence.dslquery.ExecutionContext;
import com.tangosol.coherence.dslquery.FilterBuilder;
import com.tangosol.coherence.dslquery.Statement;
import com.tangosol.coherence.dsltools.precedence.OPParser;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.coherence.dsltools.termtrees.Term;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.Session;
import com.tangosol.util.Filter;
import com.tangosol.util.FilterBuildingException;
import com.tangosol.util.ValueExtractor;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class QueryHelper {
    protected static final CoherenceQueryLanguage f_language = new CoherenceQueryLanguage();

    private QueryHelper() {
    }

    public static Filter createFilter(String sWhereClause) {
        return QueryHelper.createFilter(sWhereClause, new Object[0], new HashMap(), f_language);
    }

    public static Filter createFilter(String sWhereClause, Object[] aoBindings) {
        return QueryHelper.createFilter(sWhereClause, aoBindings, new HashMap(), f_language);
    }

    public static Filter createFilter(String sWhereClause, Map mapBindings) {
        return QueryHelper.createFilter(sWhereClause, new Object[0], mapBindings, f_language);
    }

    public static Filter createFilter(String sWhereClause, Object[] aBindings, Map mapBindings) {
        return QueryHelper.createFilter(sWhereClause, aBindings, mapBindings, f_language);
    }

    public static Filter createFilter(String sWhereClause, Object[] aBindings, Map mapBindings, CoherenceQueryLanguage language) {
        try {
            FilterBuilder filterBuilder = new FilterBuilder(aBindings == null ? Collections.emptyList() : Arrays.asList(aBindings), new ResolvableParameterList(mapBindings), language);
            return filterBuilder.makeFilter(QueryHelper.parse(sWhereClause));
        }
        catch (RuntimeException e) {
            throw new FilterBuildingException(e.getMessage(), sWhereClause, e);
        }
    }

    public static ValueExtractor createExtractor(String s) {
        return QueryHelper.createExtractor(s, f_language);
    }

    public static ValueExtractor createExtractor(String sQuery, CoherenceQueryLanguage language) {
        try {
            return new FilterBuilder(language).makeExtractor((NodeTerm)QueryHelper.parse(sQuery));
        }
        catch (RuntimeException e) {
            throw new FilterBuildingException(e.getMessage(), sQuery, e);
        }
    }

    protected static Term parse(String sQuery) {
        return QueryHelper.parse(sQuery, f_language);
    }

    protected static Term parse(String sQuery, CoherenceQueryLanguage language) {
        OPParser parser = new OPParser(sQuery, language.filtersTokenTable(), language.getOperators());
        return parser.parse();
    }

    public static Object executeStatement(String sStatement) {
        PrintWriter out = new PrintWriter(System.out);
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        ExecutionContext ctx = QueryHelper.createExecutionContext(CacheFactory.getConfigurableCacheFactory());
        ctx.setWriter(out);
        ctx.setReader(in);
        ctx.setCluster(CacheFactory.ensureCluster());
        return QueryHelper.executeStatement(sStatement, ctx);
    }

    public static ExecutionContext createExecutionContext(ConfigurableCacheFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("must specify a CacheFactory");
        }
        ExecutionContext ctx = QueryHelper.createCommonExecutionContext();
        ctx.setCacheFactory(factory);
        return ctx;
    }

    public static ExecutionContext createExecutionContext(Session session) {
        if (session == null) {
            throw new IllegalArgumentException("must specify a Session");
        }
        ExecutionContext ctx = QueryHelper.createCommonExecutionContext();
        ctx.setSession(session);
        return ctx;
    }

    protected static ExecutionContext createCommonExecutionContext() {
        ExecutionContext ctx = new ExecutionContext();
        ctx.setSilentMode(true);
        ctx.setSanityCheckingEnabled(true);
        ctx.setExtendedLanguage(true);
        ctx.setCoherenceQueryLanguage(f_language);
        return ctx;
    }

    public static Object executeStatement(String sStatement, ExecutionContext context) {
        if (sStatement == null || sStatement.isEmpty()) {
            return null;
        }
        return QueryHelper.createStatement(sStatement, context).execute(context).getResult();
    }

    public static Statement createStatement(String sStatement, ExecutionContext context) {
        return QueryHelper.createStatement(sStatement, context, null, null);
    }

    public static Statement createStatement(String sStatement, ExecutionContext context, Object[] oaPositionalParams) {
        return QueryHelper.createStatement(sStatement, context, oaPositionalParams, null);
    }

    public static Statement createStatement(String sStatement, ExecutionContext context, Map<String, Object> mapBindingParams) {
        return QueryHelper.createStatement(sStatement, context, null, mapBindingParams);
    }

    protected static Statement createStatement(String sStatement, ExecutionContext context, Object[] aoPositionalParams, Map<String, Object> mapBindingParams) {
        if (sStatement == null || sStatement.isEmpty()) {
            return null;
        }
        CoherenceQueryLanguage language = context.getCoherenceQueryLanguage();
        OPParser parser = context.instantiateParser(new StringReader(sStatement));
        Object term = parser.parse();
        List<Object> listPositional = aoPositionalParams == null || aoPositionalParams.length == 0 ? null : Arrays.asList(aoPositionalParams);
        ResolvableParameterList mapBindings = mapBindingParams == null || mapBindingParams.isEmpty() ? null : new ResolvableParameterList(mapBindingParams);
        Statement statement = language.prepareStatement((NodeTerm)term, context, listPositional, mapBindings);
        if (context.isSanityChecking()) {
            statement.sanityCheck(context);
        }
        return statement;
    }
}

