/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.Base;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class PagedIterator
extends Base
implements Iterator {
    protected Advancer m_advancer;
    protected Iterator m_iterPage;
    protected Object m_oCurr;

    public PagedIterator(Advancer advancer) {
        PagedIterator.azzert(advancer != null);
        this.m_advancer = advancer;
    }

    @Override
    public void remove() {
        Object oCurr = this.m_oCurr;
        if (oCurr == null) {
            throw new IllegalStateException();
        }
        try {
            this.m_advancer.remove(oCurr);
        }
        finally {
            this.m_oCurr = null;
        }
    }

    @Override
    public boolean hasNext() {
        Iterator iter = this.m_iterPage;
        while (iter == null || !iter.hasNext()) {
            Collection colPage = this.m_advancer.nextPage();
            if (colPage == null) {
                return false;
            }
            iter = this.m_iterPage = colPage.iterator();
        }
        return true;
    }

    public Object next() {
        Iterator iter = this.m_iterPage;
        while (iter == null || !iter.hasNext()) {
            Collection colPage = this.m_advancer.nextPage();
            if (colPage == null) {
                throw new NoSuchElementException();
            }
            iter = this.m_iterPage = colPage.iterator();
        }
        this.m_oCurr = iter.next();
        return this.m_oCurr;
    }

    public static interface Advancer {
        public Collection nextPage();

        public void remove(Object var1);
    }
}

