/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.oracle.coherence.common.collections.AbstractStableIterator;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class OpenHashSet<E>
extends AbstractSet<E> {
    static final Object REMOVED = new Object();
    static final Object NULL_SUBSTITUTE = new Object(){

        public int hashCode() {
            return 982451653;
        }

        public boolean equals(Object that) {
            return this == that;
        }
    };
    static final Object[] EMPTY = new Object[0];
    static final double LOAD_FACTOR = 0.65;
    static final double PURGE_FACTOR = 0.75;
    static final int[] PRIME_MODULO = new int[]{17, 31, 47, 61, 79, 103, 127, 149, 173, 197, 229, 277, 347, 397, 457, 509, 587, 641, 701, 761, 827, 883, 953, 1019, 1129, 1279, 1427, 1543, 1733, 1951, 2143, 2371, 2671, 2927, 3253, 3539, 3907, 4211, 4591, 4973, 5393, 5743, 6143, 6619, 6997, 7529, 8009, 8423, 8819, 9311, 9929, 10069, 11087, 12203, 13003, 14051, 15017, 16007, 17027, 18061, 19013, 20063, 23011, 27011, 30011, 35023, 40009, 45007, 50021, 60013, 70001, 80021, 90001, 100003, 120011, 140009, 160001, 180001, 200003, 233021, 266003, 300007, 350003, 400009, 450001, 500009, 550007, 600011, 650011, 700001, 800011, 850009, 900001, 950009, 1000003, 1100009, 1200007, 1300021, 1400017, 1500007, 1600033, 1700021, 1800017, 1900009, 2000003, 2500009, 3000017, 3500017, 4000037, 4500007, 0x4C4B4B, 6000011, 7000003, 8000009, 9000011, 10000019, 0xB71B11, 14000029, 16000057, 18000041, 20000003, 25000009, 30000001, 35000011, 40000003, 45000017, 50000017, 60000011, 70000027, 80000023, 90000049, 100000007, 150000001, 200000033, 300000007, 400000009, 500000003, 600000001, 700000001, 800000011, 900000011, 1000000007, 1100000009, 1200000041, 1300000003, 1400000023, 1500000001, 1600000009, 1700000009, 1800000011, 1900000043, 2147455043};
    static final int[] PRIME_NON_MODULO = new int[]{37, 41, 43, 53, 59, 67, 71, 73, 83, 89, 97, 101, 107, 109, 113, 131, 137, 139, 151, 157, 163, 167, 179, 181, 191, 193, 199, 211, 223, 227, 233, 239, 241, 251, 257, 263, 269, 271, 281, 283, 293, 307, 311, 313, 317, 331, 337, 349, 353, 359, 367, 373, 379, 383, 389, 401, 409, 419, 421, 431, 433, 439, 443, 449, 461, 463, 467, 479, 487, 491, 499, 503, 521, 523, 541, 547, 557, 563, 569, 571, 577, 593, 599, 601, 607, 613, 617, 619, 631, 643, 647, 653, 659, 661, 673, 677, 683, 691, 709, 719, 727, 733, 739, 743, 751, 757, 769, 773, 787, 797, 809, 811, 821, 823, 829, 839, 853, 857, 859, 863, 877, 881, 887, 907, 911, 919, 929, 937};
    private Object[] m_aElement;
    private int m_cElements;
    private int m_cRemoved;
    private int m_cMaxDepth;
    private int m_cGrowThreshold;
    private int m_cShrinkThreshold;
    private int m_cPurgeThreshold;
    int m_cLiveIterators;

    public OpenHashSet() {
        this.clear();
    }

    public OpenHashSet(int initialCapacity) {
        this();
        if (initialCapacity > 0) {
            long cElements = (long)((double)initialCapacity * 1.5384615384615383);
            if (cElements >= Integer.MAX_VALUE) {
                throw new IllegalArgumentException("initialCapacity too large: " + initialCapacity);
            }
            this.checkCapacity(initialCapacity);
        } else if (initialCapacity < 0) {
            throw new IllegalArgumentException("negative initial capacity: " + initialCapacity);
        }
    }

    public OpenHashSet(Collection<? extends E> coll) {
        this(coll == null ? 0 : coll.size());
        if (coll != null) {
            Object[] aElement = this.m_aElement;
            int cElements = 0;
            for (E oExternal : coll) {
                Object o = this.toInternal(oExternal);
                int i = this.find(o, true);
                if (i >= 0) continue;
                aElement[-1 - i] = o;
                ++cElements;
            }
            this.m_cElements = cElements;
            this.checkCapacity(cElements);
        }
    }

    @Override
    public int size() {
        return this.m_cElements;
    }

    @Override
    public boolean contains(Object o) {
        return this.find(this.toInternal(o), false) >= 0;
    }

    @Override
    public boolean add(E e) {
        Object o = this.toInternal(e);
        int i = this.find(o, true);
        if (i >= 0) {
            return false;
        }
        int cElements = this.m_cElements + 1;
        if (this.checkCapacity(cElements)) {
            i = this.find(o, true);
            assert (i < 0);
        }
        if (this.m_aElement[i = -1 - i] == REMOVED) {
            --this.m_cRemoved;
        }
        this.m_aElement[i] = o;
        this.m_cElements = cElements;
        return true;
    }

    @Override
    public boolean remove(Object o) {
        int i = this.find(this.toInternal(o), false);
        if (i < 0) {
            return false;
        }
        this.m_aElement[i] = REMOVED;
        --this.m_cElements;
        ++this.m_cRemoved;
        return true;
    }

    @Override
    public void clear() {
        this.m_aElement = EMPTY;
        this.m_cElements = 0;
        this.m_cRemoved = 0;
        this.m_cMaxDepth = 0;
        this.m_cGrowThreshold = -1;
        this.m_cShrinkThreshold = -1;
        this.m_cPurgeThreshold = Integer.MAX_VALUE;
    }

    @Override
    public Iterator<E> iterator() {
        final Object[] aElement = this.m_aElement;
        ++this.m_cLiveIterators;
        return new AbstractStableIterator<E>(){
            private int iNext;

            @Override
            protected void advance() {
                int cLimit = aElement.length;
                while (this.iNext < cLimit) {
                    Object o;
                    if ((o = aElement[this.iNext++]) == null || o == REMOVED) continue;
                    this.setNext(OpenHashSet.this.toExternal(o));
                    return;
                }
                --OpenHashSet.this.m_cLiveIterators;
            }

            @Override
            protected void remove(E oPrev) {
                OpenHashSet.this.remove(oPrev);
            }
        };
    }

    @Override
    public Object[] toArray() {
        int c = this.size();
        if (c == 0) {
            return EMPTY;
        }
        Object[] a = new Object[c];
        int i = 0;
        for (Object o : this.m_aElement) {
            if (o == null || o == REMOVED) continue;
            a[i++] = this.toExternal(o);
        }
        assert (i == c);
        return a;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int c = this.size();
        if (a == null) {
            a = c == 0 ? EMPTY : new Object[c];
        } else if (a.length < c) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), c);
        } else if (a.length > c) {
            a[c] = null;
        }
        if (c == 0) {
            return a;
        }
        int i = 0;
        for (Object o : this.m_aElement) {
            if (o == null || o == REMOVED) continue;
            a[i++] = this.toExternal(o);
        }
        assert (i == c);
        return a;
    }

    private Object toInternal(E oValue) {
        return oValue == null ? NULL_SUBSTITUTE : oValue;
    }

    E toExternal(Object o) {
        return (E)(o == NULL_SUBSTITUTE ? null : o);
    }

    private boolean checkCapacity(int c) {
        int BIGGEST_MODULO;
        if (c >= this.m_cShrinkThreshold && c <= this.m_cGrowThreshold) {
            if (c + this.m_cRemoved > this.m_cPurgeThreshold) {
                this.purgeRemoves();
                return true;
            }
            return false;
        }
        boolean fGrowing = c > this.m_cGrowThreshold;
        long cTarget = (long)((double)c * (fGrowing ? 1.5 : 1.25) * 1.5384615384615383);
        if (cTarget > (long)(BIGGEST_MODULO = PRIME_MODULO[PRIME_MODULO.length - 1])) {
            throw new IllegalStateException("maximum size (" + BIGGEST_MODULO + ") exceeded (" + cTarget + ")");
        }
        int iModulo = Arrays.binarySearch(PRIME_MODULO, (int)cTarget);
        if (iModulo < 0) {
            iModulo = -1 - iModulo;
        }
        assert (!fGrowing || this.m_aElement.length == 0 || Arrays.binarySearch(PRIME_MODULO, this.m_aElement.length) >= 0 && iModulo > Arrays.binarySearch(PRIME_MODULO, this.m_aElement.length));
        assert (fGrowing || Arrays.binarySearch(PRIME_MODULO, this.m_aElement.length) >= 0 && iModulo < Arrays.binarySearch(PRIME_MODULO, this.m_aElement.length));
        Object[] aOld = this.m_aElement;
        int cNew = PRIME_MODULO[iModulo];
        Object[] aNew = new Object[cNew];
        this.m_cGrowThreshold = (int)((double)cNew * 0.65);
        this.m_cShrinkThreshold = iModulo == 0 ? -1 : (int)((double)PRIME_MODULO[iModulo - 1] * 0.65 * 0.65);
        this.m_cPurgeThreshold = (int)((double)cNew * 0.75);
        assert (this.m_cGrowThreshold > c);
        assert (this.m_cShrinkThreshold < c);
        assert (this.m_cPurgeThreshold > this.m_cGrowThreshold);
        this.m_aElement = aNew;
        this.m_cMaxDepth = 0;
        this.m_cRemoved = 0;
        for (Object o : aOld) {
            if (o == null || o == REMOVED) continue;
            int i = this.find(o, true);
            if (i < 0) {
                aNew[-1 - i] = o;
                continue;
            }
            throw new IllegalStateException("duplicate found during rehash: " + String.valueOf(o) + " and " + String.valueOf(aNew[i]));
        }
        return true;
    }

    private int find(Object o, boolean fAdd) {
        Object[] aElement = this.m_aElement;
        int cModulo = aElement.length;
        if (cModulo == 0) {
            return -1;
        }
        int nHash = o.hashCode();
        long nNextHash = (long)nHash & 0xFFFFFFFFL;
        long nHashInc = 0L;
        int iInsert = -1;
        int cDepth = 0;
        int MAX_DEPTH = this.m_cMaxDepth;
        while (true) {
            int iTest;
            Object oTest;
            if (fAdd) {
                if (iInsert < 0) {
                    ++cDepth;
                }
            } else if (++cDepth > MAX_DEPTH) {
                return -1;
            }
            if ((oTest = aElement[iTest = (int)(nNextHash % (long)cModulo)]) == null) {
                if (iInsert < 0) {
                    iInsert = iTest;
                }
                if (fAdd && cDepth > MAX_DEPTH) {
                    this.m_cMaxDepth = cDepth;
                }
                return -1 - iInsert;
            }
            if (oTest == REMOVED) {
                if (iInsert < 0) {
                    iInsert = iTest;
                }
            } else {
                try {
                    if (o == oTest || nHash == oTest.hashCode() && o.equals(oTest)) {
                        if (iInsert >= 0 && this.m_cLiveIterators == 0) {
                            aElement[iInsert] = oTest;
                            aElement[iTest] = REMOVED;
                            return iInsert;
                        }
                        return iTest;
                    }
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            nNextHash += nHashInc == 0L ? (long)OpenHashSet.calculateHashIncrement(nHash) : nHashInc;
        }
    }

    private void purgeRemoves() {
        Object[] aElement = this.m_aElement;
        int cModulo = aElement.length;
        for (int i = 0; i < cModulo; ++i) {
            Object o = aElement[i];
            if (o != REMOVED) continue;
            aElement[i] = null;
        }
        int cRemoved = 0;
        int cMaxDepth = this.m_cElements == 0 ? 0 : 1;
        Object oRemoved = null;
        for (int i = 0; i < cModulo; ++i) {
            int nHash;
            long nNextHash;
            int iTarget;
            Object o = aElement[i];
            if (o == null || o == REMOVED || i == (iTarget = (int)((nNextHash = (long)(nHash = o.hashCode()) & 0xFFFFFFFFL) % (long)cModulo))) continue;
            int cDepth = 1;
            int nHashInc = 0;
            do {
                long l;
                Object oTarget;
                if ((oTarget = aElement[iTarget]) == null || oTarget == REMOVED) {
                    aElement[iTarget] = o;
                    aElement[i] = oRemoved;
                    if (oRemoved != REMOVED || oTarget == REMOVED) break;
                    ++cRemoved;
                    break;
                }
                if (nHashInc == 0) {
                    nHashInc = OpenHashSet.calculateHashIncrement(nHash);
                    l = nHashInc;
                } else {
                    l = nHashInc;
                }
                iTarget = (int)((nNextHash += l) % (long)cModulo);
                ++cDepth;
            } while (i != iTarget);
            if (cDepth <= cMaxDepth) continue;
            cMaxDepth = cDepth;
            oRemoved = REMOVED;
        }
        this.m_cMaxDepth = cMaxDepth;
        this.m_cRemoved = cRemoved;
    }

    protected E getElement(int n) {
        Object o = this.m_aElement[n];
        return o == REMOVED ? null : (E)this.toExternal(this.m_aElement[n]);
    }

    static int calculateHashIncrement(int nHash) {
        return PRIME_NON_MODULO[0x7F & (nHash ^ nHash >>> 7 ^ nHash >>> 14 ^ nHash >>> 21 ^ nHash >>> 28)];
    }
}

