/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.oracle.coherence.common.base.Nullable;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MapSet
extends AbstractSet
implements Cloneable,
Externalizable,
ExternalizableLite {
    protected static final Object NO_VALUE = Nullable.of(true);
    protected transient Map m_map;

    public MapSet() {
        this.m_map = this.instantiateMap();
    }

    public MapSet(Map map) {
        Base.azzert(map != null);
        this.m_map = map;
    }

    @Override
    public int size() {
        return this.m_map.size();
    }

    @Override
    public boolean contains(Object o) {
        return this.m_map.containsKey(o);
    }

    @Override
    public Iterator iterator() {
        return this.m_map.keySet().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.m_map.keySet().toArray();
    }

    @Override
    public Object[] toArray(Object[] ao) {
        return this.m_map.keySet().toArray(ao);
    }

    @Override
    public boolean add(Object o) {
        return this.m_map.put(o, NO_VALUE) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.m_map.remove(o) != null;
    }

    @Override
    public boolean containsAll(Collection coll) {
        return this.m_map.keySet().containsAll(coll);
    }

    @Override
    public boolean addAll(Collection coll) {
        Map map = this.m_map;
        boolean fChanged = false;
        for (Object o : coll) {
            if (map.put(o, NO_VALUE) != null) continue;
            fChanged = true;
        }
        return fChanged;
    }

    @Override
    public boolean retainAll(Collection coll) {
        return this.m_map.keySet().retainAll(coll);
    }

    @Override
    public boolean removeAll(Collection coll) {
        return this.m_map.keySet().removeAll(coll);
    }

    @Override
    public void clear() {
        this.m_map.clear();
    }

    public Map getMap() {
        return this.m_map;
    }

    public Object clone() {
        MapSet that;
        try {
            that = (MapSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw Base.ensureRuntimeException(e);
        }
        Map mapThat = that.instantiateMap();
        mapThat.putAll(this.m_map);
        that.m_map = mapThat;
        return that;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Map map = this.m_map;
        if (!map.isEmpty()) {
            throw new NotActiveException();
        }
        int c = in.readInt();
        for (int i = 0; i < c; ++i) {
            map.put(in.readObject(), NO_VALUE);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        Map map = this.m_map;
        int c = map.size();
        out.writeInt(c);
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            out.writeObject(iter.next());
            --c;
        }
        if (c != 0) {
            throw new IOException("wrote " + Math.abs(c) + " too " + (c > 0 ? "few" : "many") + " elements");
        }
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        Map map = this.m_map;
        if (!map.isEmpty()) {
            throw new NotActiveException();
        }
        Object NO_VALUE = MapSet.NO_VALUE;
        boolean fLite = in.readBoolean();
        if (fLite) {
            int c = ExternalizableHelper.readInt(in);
            for (int i = 0; i < c; ++i) {
                map.put(ExternalizableHelper.readObject(in), NO_VALUE);
            }
        } else {
            Object[] ao = (Object[])ExternalizableHelper.readObject(in);
            int c = ao.length;
            for (int i = 0; i < c; ++i) {
                map.put(ao[i], NO_VALUE);
            }
        }
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        int i;
        boolean fLite = true;
        Object[] ao = this.m_map.keySet().toArray();
        int c = ao.length;
        int FMT_OBJ_SER = 11;
        for (i = 0; i < c; ++i) {
            if (ExternalizableHelper.getStreamFormat(ao[i]) != 11) continue;
            fLite = false;
            break;
        }
        out.writeBoolean(fLite);
        if (fLite) {
            ExternalizableHelper.writeInt(out, c);
            for (i = 0; i < c; ++i) {
                ExternalizableHelper.writeObject(out, ao[i]);
            }
        } else {
            ExternalizableHelper.writeObject(out, ao);
        }
    }

    protected Map instantiateMap() {
        Map map = this.m_map;
        if (map == null) {
            return new HashMap();
        }
        try {
            return (Map)this.m_map.getClass().newInstance();
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e);
        }
    }
}

