/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.NullImplementation;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class LiteSet<E>
extends AbstractSet<E>
implements Cloneable,
Externalizable,
ExternalizableLite {
    private static final Object[] NO_OBJECTS = new Object[0];
    private static final int THRESHOLD = 8;
    private static final int I_EMPTY = 0;
    private static final int I_SINGLE = 1;
    private static final int I_ARRAY_1 = 2;
    private static final int I_ARRAY_2 = 3;
    private static final int I_ARRAY_3 = 4;
    private static final int I_ARRAY_4 = 5;
    private static final int I_ARRAY_5 = 6;
    private static final int I_ARRAY_6 = 7;
    private static final int I_ARRAY_7 = 8;
    private static final int I_ARRAY_8 = 9;
    private static final int I_OTHER = 10;
    private byte m_nImpl;
    private Object m_oContents;

    public LiteSet() {
    }

    public LiteSet(Collection<? extends E> collection) {
        this.addAll(collection);
    }

    @Override
    public boolean isEmpty() {
        return this.m_nImpl == 0;
    }

    @Override
    public int size() {
        switch (this.m_nImpl) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return this.m_nImpl - 2 + 1;
            }
            case 10: {
                return ((Set)this.m_oContents).size();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean contains(Object o) {
        switch (this.m_nImpl) {
            case 0: {
                return false;
            }
            case 1: {
                return Base.equals(o, this.m_oContents);
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                Object[] ao = (Object[])this.m_oContents;
                int c = this.m_nImpl - 2 + 1;
                return this.indexOf(ao, c, o) >= 0;
            }
            case 10: {
                return ((Set)this.m_oContents).contains(o);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public Iterator<E> iterator() {
        return this.isEmpty() ? NullImplementation.getIterator() : new Iterator<E>(){
            Object[] m_aVals;
            int m_iPrev;
            boolean m_fCanRemove;
            {
                this.m_aVals = LiteSet.this.toArray();
                this.m_iPrev = -1;
                this.m_fCanRemove = false;
            }

            @Override
            public boolean hasNext() {
                return this.m_iPrev + 1 < this.m_aVals.length;
            }

            @Override
            public E next() {
                int iNext = this.m_iPrev + 1;
                if (iNext < this.m_aVals.length) {
                    this.m_iPrev = iNext;
                    this.m_fCanRemove = true;
                    return this.m_aVals[iNext];
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                if (!this.m_fCanRemove) {
                    throw new IllegalStateException();
                }
                this.m_fCanRemove = false;
                LiteSet.this.remove(this.m_aVals[this.m_iPrev]);
            }
        };
    }

    public Enumeration<E> elements() {
        return this.isEmpty() ? NullImplementation.getEnumeration() : new Enumeration<E>(){
            Object[] m_aVals;
            int m_iNext;
            {
                this.m_aVals = LiteSet.this.toArray();
                this.m_iNext = 0;
            }

            @Override
            public boolean hasMoreElements() {
                return this.m_iNext < this.m_aVals.length;
            }

            @Override
            public E nextElement() {
                if (this.m_iNext < this.m_aVals.length) {
                    return this.m_aVals[this.m_iNext++];
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public Object[] toArray() {
        switch (this.m_nImpl) {
            case 0: {
                return NO_OBJECTS;
            }
            case 1: {
                return new Object[]{this.m_oContents};
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                Object[] ao = (Object[])this.m_oContents;
                int c = this.m_nImpl - 2 + 1;
                Object[] aoResult = new Object[c];
                System.arraycopy(ao, 0, aoResult, 0, c);
                return aoResult;
            }
            case 9: {
                return (Object[])((Object[])this.m_oContents).clone();
            }
            case 10: {
                return ((Set)this.m_oContents).toArray();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public Object[] toArray(Object[] aDest) {
        if (this.m_nImpl == 10) {
            return ((Set)this.m_oContents).toArray(aDest);
        }
        int cDest = aDest.length;
        Object[] aSrc = this.toArray();
        int cSrc = aSrc.length;
        if (cDest < cSrc) {
            cDest = cSrc;
            aDest = (Object[])Array.newInstance(aDest.getClass().getComponentType(), cDest);
        }
        if (cSrc > 0) {
            System.arraycopy(aSrc, 0, aDest, 0, cSrc);
        }
        if (cDest > cSrc) {
            aDest[cSrc] = null;
        }
        return aDest;
    }

    @Override
    public boolean add(E o) {
        switch (this.m_nImpl) {
            case 0: {
                this.m_nImpl = 1;
                this.m_oContents = o;
                return true;
            }
            case 1: {
                Object oContents = this.m_oContents;
                if (Base.equals(o, oContents)) {
                    return false;
                }
                Object[] ao = new Object[8];
                ao[0] = oContents;
                ao[1] = o;
                this.m_nImpl = (byte)3;
                this.m_oContents = ao;
                return true;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                byte nImpl = this.m_nImpl;
                Object[] ao = (Object[])this.m_oContents;
                int c = nImpl - 2 + 1;
                if (this.indexOf(ao, c, o) >= 0) {
                    return false;
                }
                if (c >= 8) {
                    Set<E> set = this.instantiateSet();
                    set.addAll(this);
                    set.add(o);
                    this.m_nImpl = (byte)10;
                    this.m_oContents = set;
                } else {
                    ao[c] = o;
                    this.m_nImpl = (byte)(nImpl + 1);
                }
                return true;
            }
            case 10: {
                return ((Set)this.m_oContents).add(o);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean remove(Object o) {
        switch (this.m_nImpl) {
            case 0: {
                return false;
            }
            case 1: {
                if (Base.equals(o, this.m_oContents)) {
                    this.m_nImpl = 0;
                    this.m_oContents = null;
                    return true;
                }
                return false;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                int nImpl = this.m_nImpl;
                Object[] ao = (Object[])this.m_oContents;
                int c = nImpl - 2 + 1;
                int i = this.indexOf(ao, c, o);
                if (i < 0) {
                    return false;
                }
                if (c == 1) {
                    this.m_nImpl = 0;
                    this.m_oContents = null;
                } else {
                    System.arraycopy(ao, i + 1, ao, i, c - i - 1);
                    ao[c - 1] = null;
                    this.m_nImpl = (byte)(--nImpl);
                }
                return true;
            }
            case 10: {
                Set set = (Set)this.m_oContents;
                boolean fRemoved = set.remove(o);
                if (fRemoved) {
                    this.checkShrinkFromOther();
                }
                return fRemoved;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        switch (this.m_nImpl) {
            case 0: {
                return collection.isEmpty();
            }
            case 10: {
                return ((Set)this.m_oContents).containsAll(collection);
            }
        }
        return super.containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        switch (this.m_nImpl) {
            case 0: {
                int c = collection.size();
                switch (c) {
                    case 0: {
                        return false;
                    }
                    case 1: {
                        this.m_nImpl = 1;
                        this.m_oContents = collection.iterator().next();
                        return true;
                    }
                }
                return super.addAll(collection);
            }
            case 10: {
                return ((Set)this.m_oContents).addAll(collection);
            }
        }
        return super.addAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        switch (this.m_nImpl) {
            case 0: {
                return false;
            }
            case 10: {
                boolean fChanged = ((Set)this.m_oContents).retainAll(collection);
                if (fChanged) {
                    this.checkShrinkFromOther();
                }
                return fChanged;
            }
        }
        return super.retainAll(collection);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        switch (this.m_nImpl) {
            case 0: {
                return false;
            }
            case 10: {
                boolean fChanged = ((Set)this.m_oContents).removeAll(collection);
                if (fChanged) {
                    this.checkShrinkFromOther();
                }
                return fChanged;
            }
        }
        return super.removeAll(collection);
    }

    @Override
    public void clear() {
        this.m_nImpl = 0;
        this.m_oContents = null;
    }

    public Object clone() {
        LiteSet that;
        try {
            that = (LiteSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw Base.ensureRuntimeException(e);
        }
        switch (this.m_nImpl) {
            case 0: 
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                that.m_oContents = ((Object[])this.m_oContents).clone();
                break;
            }
            case 10: {
                Set setThis = (Set)this.m_oContents;
                Set<E> setThat = that.instantiateSet();
                setThat.addAll(setThis);
                that.m_oContents = setThat;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return that;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (!this.isEmpty()) {
            throw new NotActiveException();
        }
        int c = in.readInt();
        if (c > 0) {
            this.initFromArray((Object[])in.readObject(), c);
        }
    }

    @Override
    public synchronized void writeExternal(ObjectOutput out) throws IOException {
        byte nImpl = this.m_nImpl;
        switch (nImpl) {
            case 0: {
                out.writeInt(0);
                break;
            }
            case 1: {
                out.writeInt(1);
                out.writeObject(new Object[]{this.m_oContents});
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                out.writeInt(nImpl - 2 + 1);
                out.writeObject((Object[])this.m_oContents);
                break;
            }
            case 10: {
                Object[] ao = ((Set)this.m_oContents).toArray();
                out.writeInt(ao.length);
                out.writeObject(ao);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        if (!this.isEmpty()) {
            throw new NotActiveException();
        }
        boolean fLite = in.readBoolean();
        if (fLite) {
            this.readAndInitObjectArray(in);
        } else {
            Object[] ao = (Object[])ExternalizableHelper.readObject(in);
            this.initFromArray(ao, ao.length);
        }
    }

    @Override
    public synchronized void writeExternal(DataOutput out) throws IOException {
        int i;
        boolean fLite = true;
        Object[] ao = this.toArray();
        int c = ao.length;
        int FMT_OBJ_SER = 11;
        for (i = 0; i < c; ++i) {
            if (ExternalizableHelper.getStreamFormat(ao[i]) != 11) continue;
            fLite = false;
            break;
        }
        out.writeBoolean(fLite);
        if (fLite) {
            ExternalizableHelper.writeInt(out, c);
            for (i = 0; i < c; ++i) {
                ExternalizableHelper.writeObject(out, ao[i]);
            }
        } else {
            ExternalizableHelper.writeObject(out, ao);
        }
    }

    private void readAndInitObjectArray(DataInput in) throws IOException {
        int cLength = ExternalizableHelper.readInt(in);
        int cCap = cLength <= 1 || cLength > 8 ? cLength : 8;
        ExternalizableHelper.validateLoadArray(Object[].class, cCap, in);
        Object[] oa = cCap <= 0 ? new Object[]{} : (cCap < 0x7FFFFF ? LiteSet.readObjectArray(in, cCap, cLength) : LiteSet.readLargeObjectArray(in, cCap));
        this.initFromArray(oa, cLength);
    }

    private static Object[] readObjectArray(DataInput in, int cLength, int cRead) throws IOException {
        Object[] ao = new Object[cLength];
        for (int i = 0; i < cRead; ++i) {
            ao[i] = ExternalizableHelper.readObject(in);
        }
        return ao;
    }

    private static Object[] readLargeObjectArray(DataInput in, int cLength) throws IOException {
        int cBatchMax = 0x3FFFFF;
        int cBatch = cLength / cBatchMax + 1;
        Object[] aMerged = null;
        int cRead = 0;
        int cAllocate = cBatchMax;
        for (int i = 0; i < cBatch && cRead < cLength; ++i) {
            Object[] ao = LiteSet.readObjectArray(in, cAllocate, cAllocate);
            aMerged = ExternalizableHelper.mergeArray(aMerged, ao);
            cAllocate = Math.min(cLength - (cRead += ao.length), cBatchMax);
        }
        return aMerged;
    }

    protected Set<E> instantiateSet() {
        return new HashSet();
    }

    private int indexOf(Object[] ao, int c, Object o) {
        int i;
        for (i = 0; i < c; ++i) {
            if (o != ao[i]) continue;
            return i;
        }
        if (o != null) {
            for (i = 0; i < c; ++i) {
                if (!o.equals(ao[i])) continue;
                return i;
            }
        }
        return -1;
    }

    protected void initFromArray(Object[] ao, int c) {
        switch (c) {
            case 0: {
                this.m_oContents = null;
                this.m_nImpl = 0;
                break;
            }
            case 1: {
                this.m_oContents = ao[0];
                this.m_nImpl = 1;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (ao.length != 8) {
                    Object[] aoPresize = new Object[8];
                    System.arraycopy(ao, 0, aoPresize, 0, c);
                    ao = aoPresize;
                }
                this.m_oContents = ao;
                this.m_nImpl = (byte)(2 + c - 1);
                break;
            }
            default: {
                Set<Object> set = this.instantiateSet();
                for (int i = 0; i < c; ++i) {
                    set.add(ao[i]);
                }
                this.m_oContents = set;
                this.m_nImpl = (byte)10;
            }
        }
        assert (this.size() == c);
    }

    protected void checkShrinkFromOther() {
        assert (this.m_nImpl == 10);
        Set set = (Set)this.m_oContents;
        int c = set.size();
        switch (c) {
            case 0: {
                this.m_nImpl = 0;
                this.m_oContents = null;
                break;
            }
            case 1: {
                this.m_nImpl = 1;
                this.m_oContents = set.toArray()[0];
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                Object[] ao = set.toArray(new Object[8]);
                this.m_nImpl = (byte)(2 + c - 1);
                this.m_oContents = ao;
            }
        }
    }
}

