/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.AbstractKeyBasedMap;
import com.tangosol.util.Base;
import com.tangosol.util.SimpleEnumerator;
import java.util.Iterator;

public class KeyValueArrayMap
extends AbstractKeyBasedMap {
    protected Object[] m_aoKey;
    protected Object[] m_aoValue;
    protected int m_iKey;
    protected int m_iValue;
    protected int m_cSize;

    public KeyValueArrayMap(Object[] aoKey, Object[] aoValue) {
        this(aoKey, 0, aoValue, 0, aoKey.length);
    }

    public KeyValueArrayMap(Object[] aoKey, int iKey, Object[] aoValue, int iValue, int cSize) {
        if (iKey + cSize > aoKey.length || iValue + cSize > aoValue.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.m_aoKey = aoKey;
        this.m_aoValue = aoValue;
        this.m_iKey = iKey;
        this.m_iValue = iValue;
        this.m_cSize = cSize;
    }

    @Override
    public Object get(Object oKey) {
        Object[] aoKey = this.m_aoKey;
        int iKey = this.m_iKey;
        int c = this.m_cSize;
        for (int i = 0; i < c; ++i) {
            if (!Base.equals(aoKey[iKey + i], oKey)) continue;
            return this.m_aoValue[this.m_iValue + i];
        }
        return null;
    }

    protected Iterator iterateKeys() {
        return new SimpleEnumerator<Object>(this.m_aoKey, this.m_iKey, this.m_cSize);
    }

    @Override
    public int size() {
        return this.m_cSize;
    }
}

