/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.oracle.coherence.common.base.NonBlocking;
import com.tangosol.internal.util.Daemons;
import com.tangosol.internal.util.invoke.Lambdas;
import com.tangosol.io.Serializer;
import com.tangosol.net.BackingMapContext;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.NamedCache;
import com.tangosol.net.cache.LocalCache;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.Converter;
import com.tangosol.util.ConverterCollections;
import com.tangosol.util.Filter;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapIndex;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.MapTrigger;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.SimpleMapEntry;
import com.tangosol.util.SimpleMapIndex;
import com.tangosol.util.SubSet;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.ValueUpdater;
import com.tangosol.util.comparator.EntryComparator;
import com.tangosol.util.comparator.SafeComparator;
import com.tangosol.util.extractor.AbstractExtractor;
import com.tangosol.util.extractor.AbstractUpdater;
import com.tangosol.util.extractor.IndexAwareExtractor;
import com.tangosol.util.filter.AlwaysFilter;
import com.tangosol.util.filter.EntryFilter;
import com.tangosol.util.filter.IndexAwareFilter;
import com.tangosol.util.filter.LimitFilter;
import com.tangosol.util.processor.AsynchronousProcessor;
import com.tangosol.util.processor.SingleEntryAsynchronousProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.ToIntFunction;

public abstract class InvocableMapHelper
extends Base {
    public static final Converter ENTRY_TO_KEY_CONVERTER = o -> ((Map.Entry)o).getKey();
    public static final Converter ENTRY_TO_VALUE_CONVERTER = o -> ((Map.Entry)o).getValue();

    public static <K, V, R> CompletableFuture<R> invokeAsync(NamedCache<K, V> cache, K key, InvocableMap.EntryProcessor<K, V, R> proc) {
        return InvocableMapHelper.invokeAsync(cache, key, Thread.currentThread().hashCode(), proc, new BiConsumer[0]);
    }

    @SafeVarargs
    public static <K, V, R> CompletableFuture<R> invokeAsync(NamedCache<K, V> cache, K key, int nOrderId, InvocableMap.EntryProcessor<K, V, R> proc, BiConsumer<? super R, ? super Throwable> ... continuations) {
        return InvocableMapHelper.invokeAsync(cache, key, nOrderId, proc, Daemons.commonPool(), continuations);
    }

    @SafeVarargs
    public static <K, V, R> CompletableFuture<R> invokeAsync(NamedCache<K, V> cache, K key, int nOrderId, InvocableMap.EntryProcessor<K, V, R> proc, Executor executor, BiConsumer<? super R, ? super Throwable> ... continuations) {
        SingleEntryAsynchronousProcessor<K, V, R> procAsync = new SingleEntryAsynchronousProcessor<K, V, R>(proc, nOrderId, executor);
        CompletionStage future = procAsync.getCompletableFuture();
        for (BiConsumer<? super R, ? super Throwable> continuation : continuations) {
            future = future.whenComplete(continuation);
        }
        cache.invoke(key, procAsync);
        if (NonBlocking.isNonBlockingCaller()) {
            procAsync.flush();
        }
        return future;
    }

    @SafeVarargs
    public static <K, V, R> CompletableFuture<Map<K, R>> invokeAllAsync(NamedCache<K, V> cache, Collection<? extends K> setKey, int nOrderId, InvocableMap.EntryProcessor<K, V, R> proc, Executor executor, BiConsumer<? super Map<? extends K, ? extends R>, ? super Throwable> ... continuations) {
        AsynchronousProcessor<K, V, R> procAsync = new AsynchronousProcessor<K, V, R>(proc, nOrderId, executor);
        CompletionStage<Map<K, Object>> future = procAsync.getCompletableFuture();
        for (BiConsumer<? super Map<? extends K, ? extends R>, ? super Throwable> continuation : continuations) {
            future = future.whenComplete(continuation::accept);
        }
        cache.invokeAll(setKey, procAsync);
        if (NonBlocking.isNonBlockingCaller()) {
            procAsync.flush();
        }
        return future;
    }

    @SafeVarargs
    public static <K, V, R> CompletableFuture<Map<K, R>> invokeAllAsync(NamedCache<K, V> cache, Collection<? extends K> setKey, ToIntFunction<K> funcOrder, InvocableMap.EntryProcessor<K, V, R> proc, BiConsumer<? super Map<? extends K, ? extends R>, ? super Throwable> ... continuations) {
        return InvocableMapHelper.invokeAllAsync(cache, setKey, funcOrder, proc, (Executor)Daemons.commonPool(), continuations);
    }

    @SafeVarargs
    public static <K, V, R> CompletableFuture<Map<K, R>> invokeAllAsync(NamedCache<K, V> cache, Collection<? extends K> setKey, ToIntFunction<K> funcOrder, InvocableMap.EntryProcessor<K, V, R> proc, Executor executor, BiConsumer<? super Map<? extends K, ? extends R>, ? super Throwable> ... continuations) {
        Object[] aKey = setKey.toArray();
        SingleEntryAsynchronousProcessor[] aProc = new SingleEntryAsynchronousProcessor[aKey.length];
        CompletableFuture[] aFuture = new CompletableFuture[aKey.length];
        for (int i = 0; i < aKey.length; ++i) {
            aProc[i] = new SingleEntryAsynchronousProcessor<K, V, R>(proc, funcOrder.applyAsInt(aKey[i]), executor);
            aFuture[i] = aProc[i].getCompletableFuture();
        }
        CompletionStage future = CompletableFuture.allOf(aFuture).thenApply(nil -> {
            HashMap<Object, Object> mapResult = new HashMap<Object, Object>();
            for (int i = 0; i < aKey.length; ++i) {
                mapResult.put(aKey[i], aFuture[i].getNow(null));
            }
            return mapResult;
        });
        for (BiConsumer<? super Map<? extends K, ? extends R>, ? super Throwable> continuation : continuations) {
            future = ((CompletableFuture)future).whenComplete(continuation::accept);
        }
        for (int i = 0; i < aKey.length; ++i) {
            cache.invoke(aKey[i], aProc[i]);
            if (!NonBlocking.isNonBlockingCaller()) continue;
            aProc[i].flush();
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V, R> R invokeLocked(ConcurrentMap<K, V> map, InvocableMap.Entry<K, V> entry, InvocableMap.EntryProcessor<K, V, R> agent) {
        K oKey = entry.getKey();
        map.lock(oKey, -1L);
        try {
            R r = agent.process(entry);
            return r;
        }
        finally {
            map.unlock(oKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V, R> Map<K, R> invokeAllLocked(ConcurrentMap<K, V> map, Set<? extends InvocableMap.Entry<K, V>> setEntries, InvocableMap.EntryProcessor<K, V, R> agent) {
        ConverterCollections.ConverterSet setKeys = ConverterCollections.getSet(setEntries, ENTRY_TO_KEY_CONVERTER, NullImplementation.getConverter());
        List listLocked = InvocableMapHelper.lockAll(map, setKeys, 0L);
        if (listLocked == null) {
            HashMap<K, R> mapResult = new HashMap<K, R>(setEntries.size());
            for (InvocableMap.Entry<K, V> entry : setEntries) {
                mapResult.put(entry.getKey(), InvocableMapHelper.invokeLocked(map, entry, agent));
            }
            return mapResult;
        }
        try {
            Map<K, R> map2 = agent.processAll(setEntries);
            return map2;
        }
        finally {
            InvocableMapHelper.unlockAll(map, listLocked);
        }
    }

    public static List lockAll(ConcurrentMap map, Collection collKeys, long cWait) {
        Set setKeys = collKeys instanceof Set ? (Set)collKeys : new HashSet(collKeys);
        ArrayList listKeys = new ArrayList(setKeys);
        LinkedList listLocked = new LinkedList();
        int cKeys = listKeys.size();
        boolean fSuccess = true;
        do {
            long cWaitNext = cWait;
            for (int i = 0; i < cKeys; ++i) {
                Object oKey = listKeys.get(i);
                fSuccess = map.lock(oKey, cWaitNext);
                if (fSuccess) {
                    listLocked.add(0, oKey);
                    cWaitNext = 0L;
                    continue;
                }
                if (i == 0) {
                    return null;
                }
                Iterator iterLocked = listLocked.iterator();
                while (iterLocked.hasNext()) {
                    map.unlock(iterLocked.next());
                }
                listLocked.clear();
                listKeys.remove(i);
                listKeys.add(0, oKey);
            }
        } while (!fSuccess);
        return listLocked;
    }

    public static void unlockAll(ConcurrentMap map, Collection collKeys) {
        Iterator iterLocked = collKeys.iterator();
        while (iterLocked.hasNext()) {
            map.unlock(iterLocked.next());
        }
    }

    public static <K, V> SimpleEntry<K, V> makeEntry(Map<K, V> map, K key) {
        return new SimpleEntry<K, V>(map, key, false);
    }

    public static <K, V> Set<InvocableMap.Entry<K, V>> makeEntrySet(Map<K, V> map, Collection<? extends K> collKeys, boolean fReadOnly) {
        HashSet<InvocableMap.Entry<K, V>> setEntries = new HashSet<InvocableMap.Entry<K, V>>(collKeys.size());
        for (K key : collKeys) {
            setEntries.add(new SimpleEntry<K, V>(map, key, fReadOnly));
        }
        return setEntries;
    }

    public static <K, V> Set<InvocableMap.Entry<K, V>> makeEntrySet(Collection<? extends Map.Entry<K, V>> collEntries) {
        HashSet<InvocableMap.Entry<K, V>> setEntries = new HashSet<InvocableMap.Entry<K, V>>(collEntries.size());
        for (Map.Entry<K, V> entry : collEntries) {
            setEntries.add(new SimpleEntry<K, V>(entry.getKey(), entry.getValue()));
        }
        return setEntries;
    }

    public static <K, V> Set<InvocableMap.Entry<K, V>> duplicateEntrySet(Map<K, V> map, Collection<? extends Map.Entry<K, V>> collEntries, boolean fReadOnly) {
        HashSet<InvocableMap.Entry<K, V>> setEntries = new HashSet<InvocableMap.Entry<K, V>>(collEntries.size());
        for (Map.Entry<K, V> entry : collEntries) {
            setEntries.add(new SimpleEntry<K, V>(map, entry.getKey(), entry.getValue(), fReadOnly));
        }
        return setEntries;
    }

    public static <K, V> boolean evaluateEntry(Filter filter, Map.Entry<K, V> entry) {
        return filter instanceof EntryFilter ? ((EntryFilter)filter).evaluateEntry(entry) : filter.evaluate(entry.getValue());
    }

    public static <K, V> boolean evaluateEntry(Filter filter, K oKey, V oValue) {
        return filter instanceof EntryFilter ? ((EntryFilter)filter).evaluateEntry(new SimpleMapEntry<K, V>(oKey, oValue)) : filter.evaluate(oValue);
    }

    public static boolean evaluateOriginalEntry(Filter filter, MapTrigger.Entry entry) {
        if (entry.isOriginalPresent()) {
            if (filter instanceof EntryFilter) {
                EntryFilter filterEntry = (EntryFilter)filter;
                return entry instanceof BinaryEntry ? filterEntry.evaluateEntry(new RoutingBinaryEntry((BinaryEntry)((Object)entry))) : filterEntry.evaluateEntry(new RoutingMapTriggerEntry(entry));
            }
            return filter.evaluate(entry.getOriginalValue());
        }
        return false;
    }

    public static <T, E, K, V> E extractFromEntry(ValueExtractor<? super T, ? extends E> extractor, Map.Entry<? extends K, ? extends V> entry) {
        return (extractor = Lambdas.ensureRemotable(extractor)) instanceof AbstractExtractor ? ((AbstractExtractor)extractor).extractFromEntry(entry) : extractor.extract(entry.getValue());
    }

    public static Object extractOriginalFromEntry(ValueExtractor extractor, MapTrigger.Entry entry) {
        return extractor instanceof AbstractExtractor ? ((AbstractExtractor)extractor).extractOriginalFromEntry(entry) : (entry.isOriginalPresent() ? extractor.extract(entry.getOriginalValue()) : null);
    }

    public static <K, V, U> void updateEntry(ValueUpdater<V, U> updater, Map.Entry<K, V> entry, U oValue) {
        if (updater instanceof AbstractUpdater) {
            ((AbstractUpdater)updater).updateEntry(entry, oValue);
        } else {
            V target = entry.getValue();
            updater.update(target, oValue);
            if (entry instanceof InvocableMap.Entry) {
                ((InvocableMap.Entry)entry).setValue(target, false);
            } else {
                entry.setValue(target);
            }
        }
    }

    public static Set query(Map map, Filter filter, boolean fEntries, boolean fSort, Comparator comparator) {
        return InvocableMapHelper.query(map, null, filter, fEntries, fSort, comparator);
    }

    public static Set query(Map map, Map mapIndexes, Filter filter, boolean fEntries, boolean fSort, Comparator comparator) {
        LimitFilter filterLimit;
        Filter<?> filterOrig = filter;
        if (AlwaysFilter.INSTANCE.equals(filter)) {
            filter = null;
        }
        Object[] aoResult = null;
        if (mapIndexes != null && !mapIndexes.isEmpty() && filter instanceof IndexAwareFilter) {
            IndexAwareFilter filterIx = (IndexAwareFilter)filter;
            SubSet<Object> setFilteredKeys = new SubSet(map.keySet());
            try {
                filter = filterIx.applyIndex(mapIndexes, setFilteredKeys);
            }
            catch (ConcurrentModificationException e) {
                setFilteredKeys = new SubSet(new ImmutableArrayList(map.keySet().toArray()));
                filter = filterIx.applyIndex(mapIndexes, setFilteredKeys);
            }
            aoResult = setFilteredKeys.toArray();
        }
        if (aoResult == null) {
            aoResult = map.keySet().toArray();
        }
        int cResults = 0;
        if (filter == null && !fEntries) {
            cResults = aoResult.length;
        } else {
            int c = aoResult.length;
            for (int i = 0; i < c; ++i) {
                Object oKey = aoResult[i];
                Object oValue = map.get(oKey);
                if (oValue == null && !map.containsKey(oKey)) continue;
                SimpleMapEntry entry = new SimpleMapEntry(oKey, oValue);
                if (filter != null && !InvocableMapHelper.evaluateEntry(filter, entry)) continue;
                aoResult[cResults++] = fEntries ? entry : oKey;
            }
        }
        LimitFilter limitFilter = filterLimit = filterOrig instanceof LimitFilter ? (LimitFilter)filterOrig : null;
        if (filterLimit != null || fEntries && fSort) {
            if (cResults < aoResult.length) {
                Object[] ao = new Object[cResults];
                System.arraycopy(aoResult, 0, ao, 0, cResults);
                aoResult = ao;
            }
            if (fEntries && fSort) {
                if (comparator == null) {
                    comparator = SafeComparator.INSTANCE;
                }
                Arrays.sort(aoResult, new EntryComparator(comparator));
            }
            if (filterLimit != null) {
                filterLimit.setComparator(null);
                aoResult = filterLimit.extractPage(aoResult);
                cResults = aoResult.length;
                filterLimit.setComparator(comparator);
            }
        }
        return new ImmutableArrayList(aoResult, 0, cResults).getSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addIndex(ValueExtractor extractor, boolean fOrdered, Comparator comparator, ObservableMap map, Map mapIndex) {
        extractor = Lambdas.ensureRemotable(extractor);
        Map map2 = mapIndex;
        synchronized (map2) {
            block12: {
                MapIndex index = (MapIndex)mapIndex.get(extractor);
                if (index == null) {
                    int cAttempts = 4;
                    while (true) {
                        if (extractor instanceof IndexAwareExtractor) {
                            index = ((IndexAwareExtractor)extractor).createIndex(fOrdered, comparator, mapIndex, null);
                            if (index == null) {
                                return;
                            }
                        } else {
                            index = new SimpleMapIndex(extractor, fOrdered, comparator, null);
                            mapIndex.put(extractor, index);
                        }
                        MapListener listener = InvocableMapHelper.ensureListener(index);
                        map.addMapListener(listener, null, false);
                        try {
                            for (Map.Entry entry : map.entrySet()) {
                                index.insert(entry);
                            }
                            break block12;
                        }
                        catch (ConcurrentModificationException cme) {
                            map.removeMapListener(listener);
                            if (--cAttempts != 0) continue;
                            InvocableMapHelper.removeIndex(extractor, map, mapIndex);
                            InvocableMapHelper.trace("Exception occurred during index rebuild: " + InvocableMapHelper.getStackTrace(cme));
                            throw cme;
                        }
                        break;
                    }
                }
                if (fOrdered != index.isOrdered() || !Base.equals(comparator, index.getComparator())) {
                    throw new IllegalArgumentException("Index for " + String.valueOf(extractor) + " already exists; remove the index and add it with the new settings");
                }
            }
        }
    }

    public static void removeIndex(ValueExtractor extractor, ObservableMap map, Map mapIndex) {
        MapIndex index;
        MapIndex mapIndex2 = index = (extractor = Lambdas.ensureRemotable(extractor)) instanceof IndexAwareExtractor ? ((IndexAwareExtractor)extractor).destroyIndex(mapIndex) : (MapIndex)mapIndex.remove(extractor);
        if (index != null) {
            map.removeMapListener(InvocableMapHelper.ensureListener(index));
        }
    }

    protected static MapListener ensureListener(MapIndex index) {
        return index instanceof MapListenerSupport.SynchronousListener ? (MapListener)((Object)index) : new IndexAdapter(index);
    }

    public static class SimpleEntry<K, V>
    extends SimpleMapEntry<K, V> {
        private static final Object UNKNOWN = new Object();
        protected Map<K, V> m_map;
        private boolean m_fReadOnly;

        public SimpleEntry(Map<K, V> map, K oKey, boolean fReadOnly) {
            this(map, oKey, UNKNOWN, fReadOnly);
        }

        public SimpleEntry(Map<K, V> map, K oKey, V oValue, boolean fReadOnly) {
            super(oKey, oValue);
            SimpleEntry.azzert(map != null);
            this.m_map = map;
            this.m_fReadOnly = fReadOnly;
        }

        public SimpleEntry(K oKey, V oValue) {
            super(oKey, oValue);
            this.m_fReadOnly = true;
        }

        @Override
        public V getValue() {
            Object oValue = super.getValue();
            if (oValue == UNKNOWN) {
                this.m_oValue = this.m_map.get(this.m_oKey);
                oValue = this.m_oValue;
            }
            return oValue;
        }

        @Override
        public V setValue(V oValue) {
            this.checkMutable();
            super.setValue(oValue);
            return this.m_map.put(this.m_oKey, oValue);
        }

        @Override
        public void setValue(V oValue, boolean fSynthetic) {
            this.checkMutable();
            super.setValue(oValue);
            this.m_map.putAll(Collections.singletonMap(this.m_oKey, oValue));
        }

        @Override
        public boolean isPresent() {
            Object oValue = this.m_oValue;
            return oValue != UNKNOWN && oValue != null || this.m_map == null || this.m_map.containsKey(this.m_oKey);
        }

        @Override
        public void remove(boolean fSynthetic) {
            this.checkMutable();
            Map<K, V> map = this.m_map;
            Object oKey = this.m_oKey;
            if (fSynthetic && map instanceof LocalCache) {
                ((LocalCache)map).evict(oKey);
            } else {
                map.keySet().remove(oKey);
            }
            this.m_oValue = null;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof SimpleEntry) {
                SimpleEntry that = (SimpleEntry)o;
                return SimpleEntry.equals(this.m_oKey, that.m_oKey);
            }
            return false;
        }

        @Override
        public int hashCode() {
            Object oKey = this.m_oKey;
            return oKey == null ? 0 : oKey.hashCode();
        }

        @Override
        public String toString() {
            return "SimpleEntry(key=" + String.valueOf(this.m_oKey) + ")";
        }

        protected void checkMutable() {
            if (this.m_fReadOnly) {
                throw new UnsupportedOperationException("Read-only entry does not allow Map modification");
            }
        }
    }

    protected static class RoutingBinaryEntry
    extends RoutingMapTriggerEntry
    implements BinaryEntry {
        protected RoutingBinaryEntry(BinaryEntry entry) {
            super(entry);
        }

        @Override
        public Binary getBinaryKey() {
            return ((BinaryEntry)this.m_entry).getBinaryKey();
        }

        @Override
        public Binary getBinaryValue() {
            return ((BinaryEntry)this.m_entry).getOriginalBinaryValue();
        }

        @Override
        public Serializer getSerializer() {
            return ((BinaryEntry)this.m_entry).getSerializer();
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public BackingMapManagerContext getContext() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void updateBinaryValue(Binary binValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void updateBinaryValue(Binary binValue, boolean fSynthetic) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Binary getOriginalBinaryValue() {
            throw new UnsupportedOperationException();
        }

        public ObservableMap getBackingMap() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BackingMapContext getBackingMapContext() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void expire(long cMillis) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getExpiry() {
            throw new UnsupportedOperationException();
        }
    }

    protected static class RoutingMapTriggerEntry
    implements MapTrigger.Entry {
        protected InvocableMap.Entry m_entry;

        protected RoutingMapTriggerEntry(MapTrigger.Entry entry) {
            this.m_entry = entry;
        }

        protected RoutingMapTriggerEntry(BinaryEntry entry) {
            this.m_entry = entry;
        }

        @Override
        public Object getKey() {
            return this.m_entry.getKey();
        }

        @Override
        public Object getValue() {
            return ((MapTrigger.Entry)this.m_entry).getOriginalValue();
        }

        @Override
        public Object extract(ValueExtractor extractor) {
            return InvocableMapHelper.extractFromEntry(extractor, this);
        }

        public Object getOriginalValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object setValue(Object oValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setValue(Object oValue, boolean fSynthetic) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void update(ValueUpdater updater, Object oValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove(boolean fSynthetic) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isPresent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isSynthetic() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isOriginalPresent() {
            throw new UnsupportedOperationException();
        }
    }

    protected static class IndexAdapter
    implements MapListenerSupport.SynchronousListener {
        private MapIndex m_index;

        protected IndexAdapter(MapIndex index) {
            this.m_index = index;
        }

        @Override
        public void entryInserted(MapEvent evt) {
            this.m_index.insert(new SimpleMapEntry(evt.getKey(), evt.getNewValue()));
        }

        @Override
        public void entryUpdated(MapEvent evt) {
            this.m_index.update(new SimpleMapEntry(evt.getKey(), evt.getNewValue(), evt.getOldValue()));
        }

        @Override
        public void entryDeleted(MapEvent evt) {
            this.m_index.delete(new SimpleMapEntry(evt.getKey(), null, evt.getOldValue()));
        }

        public boolean equals(Object o) {
            return this == o || o instanceof IndexAdapter && Base.equals(this.m_index, ((IndexAdapter)o).m_index);
        }

        public int hashCode() {
            return this.m_index.hashCode();
        }
    }
}

