/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;

public class HealthCheckClient {
    public static void main(String[] asArg) {
        if (asArg.length == 0) {
            System.err.println("Missing URL parameter");
            System.exit(1);
        }
        String sURL = asArg[0];
        try {
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(sURL)).GET().build();
            HttpResponse<Void> response = client.send(request, HttpResponse.BodyHandlers.discarding());
            int nStatus = response.statusCode();
            if (nStatus != 200) {
                System.err.println("Request to \"" + sURL + "\" returned " + nStatus);
                System.exit(1);
            }
        }
        catch (Throwable e) {
            System.err.println("Request to \"" + sURL + "\" failed");
            e.printStackTrace();
            System.exit(1);
        }
    }
}

