/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.Extractors;
import com.tangosol.util.Filter;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.filter.AllFilter;
import com.tangosol.util.filter.AlwaysFilter;
import com.tangosol.util.filter.AnyFilter;
import com.tangosol.util.filter.BetweenFilter;
import com.tangosol.util.filter.ContainsAllFilter;
import com.tangosol.util.filter.ContainsAnyFilter;
import com.tangosol.util.filter.ContainsFilter;
import com.tangosol.util.filter.EqualsFilter;
import com.tangosol.util.filter.GreaterEqualsFilter;
import com.tangosol.util.filter.GreaterFilter;
import com.tangosol.util.filter.InFilter;
import com.tangosol.util.filter.IsNotNullFilter;
import com.tangosol.util.filter.IsNullFilter;
import com.tangosol.util.filter.LessEqualsFilter;
import com.tangosol.util.filter.LessFilter;
import com.tangosol.util.filter.LikeFilter;
import com.tangosol.util.filter.NeverFilter;
import com.tangosol.util.filter.NotEqualsFilter;
import com.tangosol.util.filter.NotFilter;
import com.tangosol.util.filter.PredicateFilter;
import com.tangosol.util.filter.PresentFilter;
import com.tangosol.util.filter.RegexFilter;
import com.tangosol.util.filter.ScriptFilter;
import com.tangosol.util.function.Remote;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class Filters {
    public static AllFilter all(Filter<?> ... filters) {
        return new AllFilter((Filter[])filters);
    }

    public static AnyFilter any(Filter<?> ... filters) {
        return new AnyFilter((Filter[])filters);
    }

    public static <T> AlwaysFilter<T> always() {
        return AlwaysFilter.INSTANCE();
    }

    public static <T> NeverFilter<T> never() {
        return NeverFilter.INSTANCE();
    }

    public static <T> PresentFilter<T> present() {
        return PresentFilter.INSTANCE();
    }

    public static <T> NotFilter<T> not(Filter<T> filter) {
        return new NotFilter<T>(filter);
    }

    public static <T, E> IsNullFilter<T, E> isNull(ValueExtractor<T, E> extractor) {
        return new IsNullFilter<T, E>(extractor);
    }

    public static <T, E> IsNotNullFilter<T, E> isNotNull(ValueExtractor<T, E> extractor) {
        return new IsNotNullFilter<T, E>(extractor);
    }

    public static <T> EqualsFilter<T, Boolean> isTrue(ValueExtractor<T, Boolean> extractor) {
        return Filters.equal(extractor, Boolean.valueOf(true));
    }

    public static <T> EqualsFilter<T, Boolean> isFalse(ValueExtractor<T, Boolean> extractor) {
        return Filters.equal(extractor, Boolean.valueOf(false));
    }

    public static <T, E> EqualsFilter<T, E> equal(String fieldName, E value) {
        return Filters.equal(Extractors.extract(fieldName), value);
    }

    public static <T, E> EqualsFilter<T, E> equal(ValueExtractor<T, ? extends E> extractor, E value) {
        return new EqualsFilter<T, E>(extractor, value);
    }

    public static <T, E> NotEqualsFilter<T, E> notEqual(ValueExtractor<T, ? extends E> extractor, E value) {
        return new NotEqualsFilter<T, E>(extractor, value);
    }

    public static <T, E extends Comparable<? super E>> LessFilter<T, E> less(ValueExtractor<T, ? extends E> extractor, E value) {
        return new LessFilter<T, E>(extractor, value);
    }

    public static <T, E extends Comparable<? super E>> LessEqualsFilter<T, E> lessEqual(ValueExtractor<T, ? extends E> extractor, E value) {
        return new LessEqualsFilter<T, E>(extractor, value);
    }

    public static <T, E extends Comparable<? super E>> GreaterFilter<T, E> greater(ValueExtractor<T, ? extends E> extractor, E value) {
        return new GreaterFilter<T, E>(extractor, value);
    }

    public static <T, E extends Comparable<? super E>> GreaterEqualsFilter<T, E> greaterEqual(ValueExtractor<T, ? extends E> extractor, E value) {
        return new GreaterEqualsFilter<T, E>(extractor, value);
    }

    public static <T, E extends Comparable<? super E>> BetweenFilter<T, E> between(ValueExtractor<T, ? extends E> extractor, E from, E to) {
        return new BetweenFilter<T, E>(extractor, from, to);
    }

    public static <T, E, C extends Collection<? extends E>> ContainsFilter<T, ?> contains(ValueExtractor<T, C> extractor, E value) {
        return new ContainsFilter<T, C>(extractor, value);
    }

    public static <T, E> ContainsFilter<T, ?> arrayContains(ValueExtractor<T, E[]> extractor, E value) {
        return new ContainsFilter<T, E[]>(extractor, (E[])value);
    }

    public static <T, E, C extends Collection<? extends E>> ContainsAllFilter<T, C> containsAll(ValueExtractor<T, C> extractor, Set<? extends E> setValues) {
        return new ContainsAllFilter<T, C>(extractor, setValues);
    }

    @SafeVarargs
    public static <T, E, C extends Collection<? extends E>> ContainsAllFilter<T, C> containsAll(ValueExtractor<T, C> extractor, E ... values) {
        return new ContainsAllFilter<T, C>(extractor, (Set<?>)new ImmutableArrayList(values));
    }

    public static <T, E> ContainsAllFilter<T, E[]> arrayContainsAll(ValueExtractor<T, E[]> extractor, Set<? extends E> setValues) {
        return new ContainsAllFilter<T, E[]>(extractor, setValues);
    }

    @SafeVarargs
    public static <T, E> ContainsAllFilter<T, E[]> arrayContainsAll(ValueExtractor<T, E[]> extractor, E ... values) {
        return new ContainsAllFilter<T, E[]>(extractor, (Set<?>)new ImmutableArrayList(values));
    }

    public static <T, E, C extends Collection<? extends E>> ContainsAnyFilter<T, C> containsAny(ValueExtractor<T, C> extractor, Set<? extends E> setValues) {
        return new ContainsAnyFilter<T, C>(extractor, setValues);
    }

    @SafeVarargs
    public static <T, E, C extends Collection<? extends E>> ContainsAnyFilter<T, C> containsAny(ValueExtractor<T, C> extractor, E ... values) {
        return new ContainsAnyFilter<T, C>(extractor, (Set<?>)new ImmutableArrayList(values));
    }

    public static <T, E> ContainsAnyFilter<T, E[]> arrayContainsAny(ValueExtractor<T, E[]> extractor, Set<? extends E> setValues) {
        return new ContainsAnyFilter<T, E[]>(extractor, setValues);
    }

    @SafeVarargs
    public static <T, E> ContainsAnyFilter<T, E[]> arrayContainsAny(ValueExtractor<T, E[]> extractor, E ... values) {
        return new ContainsAnyFilter<T, E[]>(extractor, (Set<?>)new ImmutableArrayList(values));
    }

    public static <T, E> InFilter<T, E> in(ValueExtractor<T, ? extends E> extractor, Set<? extends E> setValues) {
        return new InFilter<T, E>(extractor, setValues);
    }

    @SafeVarargs
    public static <T, E> InFilter<T, E> in(ValueExtractor<T, ? extends E> extractor, E ... values) {
        return new InFilter<T, E>(extractor, new HashSet<E>(Arrays.asList(values)));
    }

    public static <T, E> LikeFilter<T, E> like(ValueExtractor<T, E> extractor, String sPattern) {
        return Filters.like(extractor, sPattern, '\u0000', false);
    }

    public static <T, E> LikeFilter<T, E> like(ValueExtractor<T, E> extractor, String sPattern, char chEscape) {
        return Filters.like(extractor, sPattern, chEscape, false);
    }

    public static <T, E> LikeFilter<T, E> like(ValueExtractor<T, E> extractor, String sPattern, boolean fIgnoreCase) {
        return Filters.like(extractor, sPattern, '\u0000', fIgnoreCase);
    }

    public static <T, E> LikeFilter<T, E> like(ValueExtractor<T, E> extractor, String sPattern, char chEscape, boolean fIgnoreCase) {
        return new LikeFilter<T, E>(extractor, sPattern, chEscape, fIgnoreCase);
    }

    public static <T, E> RegexFilter<T, E> regex(ValueExtractor<T, E> extractor, String sRegex) {
        return new RegexFilter<T, E>(extractor, sRegex);
    }

    public static <T> PredicateFilter<T, ?> predicate(Remote.Predicate<T> predicate) {
        return new PredicateFilter(predicate);
    }

    public static <T, E> PredicateFilter<T, E> predicate(ValueExtractor<T, ? extends E> extractor, Remote.Predicate<? super E> predicate) {
        return new PredicateFilter<T, E>(extractor, predicate);
    }

    public static <V> ScriptFilter<V> script(String sLanguage, String sScriptPath, Object ... aoArgs) {
        return new ScriptFilter(sLanguage, sScriptPath, aoArgs);
    }
}

