/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.io.pof.reflect.PofNavigator;
import com.tangosol.io.pof.reflect.PofReflectionHelper;
import com.tangosol.io.pof.reflect.SimplePofPath;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.ChainedExtractor;
import com.tangosol.util.extractor.ChainedFragmentExtractor;
import com.tangosol.util.extractor.CollectionExtractor;
import com.tangosol.util.extractor.FragmentExtractor;
import com.tangosol.util.extractor.IdentityExtractor;
import com.tangosol.util.extractor.KeyExtractor;
import com.tangosol.util.extractor.MultiExtractor;
import com.tangosol.util.extractor.PofExtractor;
import com.tangosol.util.extractor.ScriptValueExtractor;
import com.tangosol.util.extractor.UniversalExtractor;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class Extractors {
    public static <T> IdentityExtractor<T> identity() {
        return IdentityExtractor.INSTANCE();
    }

    public static <T, E> ValueExtractor<T, E> extract(String from) {
        return new UniversalExtractor(from);
    }

    public static <T, E> ValueExtractor<T, E> extract(String from, Object ... aoParam) {
        if (!((String)from).endsWith("()")) {
            from = (String)from + "()";
        }
        return new UniversalExtractor((String)from, aoParam);
    }

    public static <T> ValueExtractor<T, List<?>> multi(String ... fields) {
        if (fields == null || fields.length == 0) {
            throw new IllegalArgumentException("The fields parameter cannot be null or empty");
        }
        ValueExtractor[] aExtractor = (ValueExtractor[])Arrays.stream(fields).filter(Objects::nonNull).map(xva$0 -> Extractors.chained(xva$0)).toArray(ValueExtractor[]::new);
        if (aExtractor.length == 0) {
            throw new IllegalArgumentException("The fields parameter must contain at least one non-null element");
        }
        return Extractors.multi(aExtractor);
    }

    public static <T> ValueExtractor<T, List<?>> multi(ValueExtractor<T, ?> ... extractors) {
        return new MultiExtractor(extractors);
    }

    public static <T, R> ValueExtractor<T, R> chained(String ... fields) {
        if (fields == null || fields.length == 0) {
            throw new IllegalArgumentException("The fields parameter cannot be null or empty");
        }
        ValueExtractor[] aExtractor = (ValueExtractor[])Arrays.stream(fields).filter(Objects::nonNull).map(s -> s.split("\\.")).flatMap(Arrays::stream).map(Extractors::extract).toArray(ValueExtractor[]::new);
        if (aExtractor.length == 0) {
            throw new IllegalArgumentException("The fields parameter must contain at least one non-null element");
        }
        if (aExtractor.length == 1) {
            return aExtractor[0];
        }
        return Extractors.chained(aExtractor);
    }

    public static <T, R> ValueExtractor<T, R> chained(ValueExtractor<?, ?> ... extractors) {
        if (extractors == null || extractors.length == 0) {
            throw new IllegalArgumentException("The extractors parameter cannot be null or empty");
        }
        if (extractors.length == 1) {
            return extractors[0];
        }
        return new ChainedExtractor(extractors);
    }

    public static <T, E> ValueExtractor<T, E> identityCast() {
        return IdentityExtractor.INSTANCE;
    }

    public static <T, E> CollectionExtractor<T, E> fromCollection(String ... fields) {
        return new CollectionExtractor(Extractors.chained(fields));
    }

    public static <T, E> CollectionExtractor<T, E> fromCollection(ValueExtractor<?, ?> ... extractors) {
        return new CollectionExtractor(Extractors.chained(extractors));
    }

    public static <T> PofExtractor<T, ?> fromPof(int ... indexes) {
        return Extractors.fromPof(null, indexes);
    }

    public static <T, E> PofExtractor<T, E> fromPof(Class<E> cls, int ... indexes) {
        return Extractors.fromPof(cls, new SimplePofPath(Objects.requireNonNull(indexes)));
    }

    public static <T, E> PofExtractor<T, E> fromPof(Class<T> clsFrom, String sPath) {
        return Extractors.fromPof(null, PofReflectionHelper.getPofNavigator(clsFrom, sPath));
    }

    public static <T, E> PofExtractor<T, E> fromPof(Class<E> cls, PofNavigator navigator) {
        return new PofExtractor(cls, navigator);
    }

    public static <T, E> ScriptValueExtractor<T, E> script(String sLanguage, String sScriptPath, Object ... aoArgs) {
        return new ScriptValueExtractor(sLanguage, sScriptPath, aoArgs);
    }

    @SafeVarargs
    public static <T> FragmentExtractor<T> fragment(ValueExtractor<? super T, ?> ... aExtractors) {
        return new FragmentExtractor<T>(aExtractors);
    }

    @SafeVarargs
    public static <T, E> ChainedFragmentExtractor<T, E> fragment(ValueExtractor<? super T, E> from, ValueExtractor<? super E, ?> ... aExtractors) {
        return new ChainedFragmentExtractor<T, E>(from, aExtractors);
    }

    public static <T, R> ValueExtractor<T, R> key(ValueExtractor<?, ?> ... extractors) {
        if (extractors == null || extractors.length == 0) {
            throw new IllegalArgumentException("The fields parameter must contain at least one non-null element");
        }
        if (extractors.length == 1) {
            return extractors[0].fromKey();
        }
        ValueExtractor[] copy = new ValueExtractor[extractors.length];
        System.arraycopy(extractors, 0, copy, 0, extractors.length);
        ValueExtractor key = copy[0].fromKey();
        if (key instanceof KeyExtractor) {
            return Extractors.chained(copy).fromKey();
        }
        copy[0] = key;
        return Extractors.chained(copy);
    }

    public static <T, R> ValueExtractor<T, R> key(String ... fields) {
        return Extractors.key(Extractors.chained(fields));
    }
}

