/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.Base;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;

public class ErrorList
extends AbstractList {
    private int m_nSev = 0;
    private int m_cSev;
    private int m_cMax = Integer.MAX_VALUE;
    private List m_listErrors = new ArrayList();

    public ErrorList() {
    }

    public ErrorList(int cMax) {
        this.m_cMax = cMax;
    }

    public boolean isSevere() {
        return this.m_cSev > 0;
    }

    public int getSeverity() {
        return this.m_nSev;
    }

    @Override
    public void add(int nSev, String sText) {
        this.add(new Item(nSev, sText));
    }

    public void addInfo(String sInfo) {
        this.add(1, sInfo);
    }

    public void addWarning(String sWarning) {
        this.add(2, sWarning);
    }

    public void addError(String sError) {
        this.add(3, sError);
    }

    public void addFatal(String sError) {
        this.add(4, sError);
    }

    public void addException(Throwable e) {
        Item item = new Item(4, e.toString());
        item.setLocator(e);
        this.add(item);
    }

    @Override
    public int size() {
        return this.m_listErrors.size();
    }

    @Override
    public Object get(int index) {
        return this.m_listErrors.get(index);
    }

    @Override
    public synchronized boolean add(Object o) {
        Item item = (Item)o;
        this.m_listErrors.add(item);
        if (item.isSevere()) {
            ++this.m_cSev;
            if (this.m_cSev > this.m_cMax) {
                throw new OverflowException();
            }
        }
        if (item.getSeverity() > this.m_nSev) {
            this.m_nSev = item.getSeverity();
        }
        return true;
    }

    @Override
    public void clear() {
        this.m_listErrors.clear();
        this.m_cSev = 0;
        this.m_nSev = 0;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "ErrorList is empty.";
        }
        StringBuffer sb = new StringBuffer();
        int c = this.size();
        sb.append("ErrorList contains " + c + " items:");
        for (int i = 0; i < c; ++i) {
            sb.append("\n[" + i + "]=" + String.valueOf(this.get(i)));
        }
        return sb.toString();
    }

    public void print() {
        Base.out(this.toString());
    }

    public static String toSeverityString(int nSev) {
        switch (nSev) {
            case 0: {
                return "No Error";
            }
            case 1: {
                return "Information";
            }
            case 2: {
                return "Warning";
            }
            case 3: {
                return "Error";
            }
            case 4: {
                return "Fatal Error";
            }
        }
        return "Unknown Severity";
    }

    public static interface Constants {
        public static final int NONE = 0;
        public static final int INFO = 1;
        public static final int WARNING = 2;
        public static final int ERROR = 3;
        public static final int FATAL = 4;
    }

    public static class Item
    extends Base {
        private String m_sCode;
        private int m_nSev;
        private String m_sText;
        private Object[] m_aoParam;
        private Object m_oLocator;
        private ResourceBundle m_res;

        public Item(String sCode, int nSev, String sText, Object[] aoParam, Object oLocator, ResourceBundle res) {
            this.m_sCode = sCode;
            this.m_nSev = nSev;
            this.m_sText = sText;
            this.m_aoParam = aoParam;
            this.m_oLocator = oLocator;
            this.m_res = res;
        }

        public Item(int nSev, String sText) {
            this(null, nSev, sText, null, null, null);
        }

        public Item(int nSev, String sText, Object[] aoParam) {
            this(null, nSev, sText, aoParam, null, null);
        }

        public String getCode() {
            return this.m_sCode;
        }

        public int getSeverity() {
            return this.m_nSev;
        }

        public boolean isSevere() {
            return this.m_nSev > 2;
        }

        public String getText() {
            if (this.m_sText == null) {
                if (this.m_sCode != null && this.m_res != null) {
                    this.m_sText = this.m_res.getString(this.m_sCode);
                }
                if (this.m_sText == null) {
                    this.m_sText = "";
                }
            }
            return this.m_sText;
        }

        public Object[] getParameters() {
            return this.m_aoParam;
        }

        public String getMessage() {
            String sMsg = this.getText();
            if (this.m_aoParam != null && this.m_aoParam.length > 0) {
                try {
                    sMsg = MessageFormat.format(sMsg, this.m_aoParam);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return sMsg;
        }

        public Object getLocator() {
            return this.m_oLocator;
        }

        public void setLocator(Object oLocator) {
            this.m_oLocator = oLocator;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.m_oLocator != null && !(this.m_oLocator instanceof Throwable)) {
                sb.append(' ').append(this.m_oLocator).append(':');
            }
            if (this.m_nSev > 0) {
                sb.append(' ').append(ErrorList.toSeverityString(this.m_nSev));
            }
            if (this.m_sCode != null) {
                sb.append("  #").append(this.m_sCode);
            }
            if (this.m_nSev > 0 || this.m_sCode != null) {
                sb.append(":");
            }
            sb.append(' ').append(this.getMessage());
            return sb.substring(1);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Item) {
                Item that = (Item)obj;
                return this.m_nSev == that.m_nSev && (this.m_sCode == null ? that.m_sCode == null : this.m_sCode.equals(that.m_sCode)) && (this.m_sText == null ? that.m_sText == null : this.m_sText.equals(that.m_sText)) && Arrays.equals(this.m_aoParam, that.m_aoParam) && (this.m_oLocator == null ? that.m_oLocator == null : this.m_oLocator.equals(that.m_oLocator));
            }
            return false;
        }
    }

    public class OverflowException
    extends RuntimeException {
        protected OverflowException() {
            super("ErrorList limit");
        }
    }
}

