/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class DaemonThreadFactory
implements ThreadFactory {
    protected final String m_sNamePrefix;
    protected final AtomicInteger m_cNameSuffix = new AtomicInteger();
    public static final DaemonThreadFactory INSTANCE = new DaemonThreadFactory("DaemonThread-");

    public DaemonThreadFactory() {
        this(null);
    }

    public DaemonThreadFactory(String sPrefix) {
        this.m_sNamePrefix = sPrefix;
    }

    @Override
    public Thread makeThread(ThreadGroup group, Runnable runnable, String sName) {
        String sPrefix = this.m_sNamePrefix;
        Thread thread = sName == null && sPrefix == null ? new Thread(group, runnable) : new Thread(group, runnable, sPrefix + this.m_cNameSuffix.incrementAndGet());
        thread.setDaemon(true);
        return thread;
    }

    @Override
    public Thread newThread(Runnable r) {
        String sPrefix = this.m_sNamePrefix;
        Thread thread = sPrefix == null ? new Thread(r) : new Thread(r, sPrefix + this.m_cNameSuffix.incrementAndGet());
        thread.setDaemon(true);
        return thread;
    }
}

