/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.IntFunction;

public class ChainedSet<E>
extends AbstractSet<E> {
    protected final Set<E>[] f_aSets;

    public ChainedSet(Collection<Set<E>> col) {
        this((Set[])col.toArray(Set[]::new));
    }

    public ChainedSet(ChainedSet<E> original, Set<E> set) {
        this.f_aSets = Arrays.copyOf(original.f_aSets, original.f_aSets.length + 1);
        this.f_aSets[original.f_aSets.length] = set;
    }

    public ChainedSet(ChainedSet<E> original, Set<E> ... aSets) {
        this.f_aSets = Arrays.copyOf(original.f_aSets, original.f_aSets.length + aSets.length);
        System.arraycopy(aSets, 0, this.f_aSets, original.f_aSets.length, aSets.length);
    }

    public ChainedSet(Set<E> ... aSets) {
        this.f_aSets = aSets;
    }

    @Override
    public int size() {
        int cSize = 0;
        for (Set<E> set : this.f_aSets) {
            cSize += set.size();
        }
        return cSize;
    }

    @Override
    public boolean isEmpty() {
        for (Set<E> set : this.f_aSets) {
            if (set.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(Object o) {
        for (Set<E> set : this.f_aSets) {
            if (!set.contains(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> col) {
        for (Object o : col) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            Iterator<E> m_iter;
            int m_iSet = -1;

            @Override
            public boolean hasNext() {
                Iterator iter = this.m_iter;
                int iSet = this.m_iSet;
                int cSet = ChainedSet.this.f_aSets.length;
                while (!(iter != null && iter.hasNext() || ++iSet >= cSet)) {
                    this.m_iter = ChainedSet.this.f_aSets[iSet].iterator();
                    iter = this.m_iter;
                    this.m_iSet = iSet;
                }
                if (iSet >= cSet) {
                    this.m_iter = null;
                    return false;
                }
                return true;
            }

            @Override
            public E next() {
                if (this.hasNext()) {
                    return this.m_iter.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                if (this.m_iter == null) {
                    throw new NoSuchElementException();
                }
                this.m_iter.remove();
            }
        };
    }

    @Override
    public Object[] toArray() {
        return this.toArray((Object[])null);
    }

    @Override
    public <T> T[] toArray(IntFunction<T[]> generator) {
        return this.toArray(generator.apply(this.size()));
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int cSize = this.size();
        if (a == null || cSize > a.length) {
            a = new Object[cSize];
        }
        int of = 0;
        int cArray = this.f_aSets.length;
        for (int i = 0; i < cArray; ++i) {
            Object[] aoCol = this.f_aSets[i].toArray();
            System.arraycopy(aoCol, 0, a, of, aoCol.length);
            of += aoCol.length;
        }
        return a;
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

