/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.IntFunction;

public class ChainedCollection<E>
extends AbstractCollection<E> {
    protected final Collection<E>[] f_aCol;

    public ChainedCollection(Collection<Collection<E>> col) {
        this((Collection[])col.toArray(Collection[]::new));
    }

    public ChainedCollection(ChainedCollection<E> original, Collection<E> col) {
        this.f_aCol = Arrays.copyOf(original.f_aCol, original.f_aCol.length + 1);
        this.f_aCol[original.f_aCol.length] = col;
    }

    @SafeVarargs
    public ChainedCollection(ChainedCollection<E> original, Collection<E> ... aCol) {
        this.f_aCol = Arrays.copyOf(original.f_aCol, original.f_aCol.length + aCol.length);
        System.arraycopy(aCol, 0, this.f_aCol, original.f_aCol.length, aCol.length);
    }

    public ChainedCollection(Collection<E>[] aCol) {
        this.f_aCol = aCol;
    }

    @Override
    public int size() {
        int cSize = 0;
        for (Collection<E> col : this.f_aCol) {
            cSize += col.size();
        }
        return cSize;
    }

    @Override
    public boolean isEmpty() {
        for (Collection<E> col : this.f_aCol) {
            if (col.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(Object o) {
        for (Collection<E> col : this.f_aCol) {
            if (!col.contains(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> col) {
        for (Object o : col) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            Iterator<E> m_iter;
            int m_iCol = -1;

            @Override
            public boolean hasNext() {
                Iterator iter = this.m_iter;
                int iCol = this.m_iCol;
                int cCol = ChainedCollection.this.f_aCol.length;
                while (!(iter != null && iter.hasNext() || ++iCol >= cCol)) {
                    this.m_iter = ChainedCollection.this.f_aCol[iCol].iterator();
                    iter = this.m_iter;
                    this.m_iCol = iCol;
                }
                if (iCol >= cCol) {
                    this.m_iter = null;
                    return false;
                }
                return true;
            }

            @Override
            public E next() {
                if (this.hasNext()) {
                    return this.m_iter.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                if (this.m_iter == null) {
                    throw new NoSuchElementException();
                }
                this.m_iter.remove();
            }
        };
    }

    @Override
    public Object[] toArray() {
        return this.toArray((Object[])null);
    }

    @Override
    public <T> T[] toArray(IntFunction<T[]> generator) {
        return this.toArray(generator.apply(this.size()));
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int cSize = this.size();
        if (a == null || cSize > a.length) {
            a = new Object[cSize];
        }
        int of = 0;
        int cArray = this.f_aCol.length;
        for (int i = 0; i < cArray; ++i) {
            Object[] aoCol = this.f_aCol[i].toArray();
            System.arraycopy(aoCol, 0, a, of, aoCol.length);
            of += aoCol.length;
        }
        return a;
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

