/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.oracle.coherence.common.collections.AbstractStableIterator;
import com.tangosol.util.AbstractKeyBasedMap;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractKeySetBasedMap<K, V>
extends AbstractKeyBasedMap<K, V> {
    @Override
    public boolean containsKey(Object oKey) {
        return this.getInternalKeySet().contains(oKey);
    }

    @Override
    public boolean isEmpty() {
        return this.getInternalKeySet().isEmpty();
    }

    @Override
    public int size() {
        return this.getInternalKeySet().size();
    }

    @Override
    protected Iterator<K> iterateKeys() {
        return this.instantiateKeyIterator();
    }

    protected abstract Set<K> getInternalKeySet();

    protected boolean isInternalKeySetIteratorMutable() {
        return false;
    }

    @Override
    protected Set<K> instantiateKeySet() {
        return new KeySet();
    }

    @Override
    protected Set<Map.Entry<K, V>> instantiateEntrySet() {
        return new EntrySet();
    }

    @Override
    protected Collection<V> instantiateValues() {
        return new ValuesCollection();
    }

    protected Iterator<K> instantiateKeyIterator() {
        KeyIterator iter = this.getInternalKeySet().iterator();
        if (!this.isInternalKeySetIteratorMutable()) {
            iter = new KeyIterator(iter);
        }
        return iter;
    }

    protected class KeySet
    extends AbstractKeyBasedMap.KeySet {
        protected KeySet() {
            super(AbstractKeySetBasedMap.this);
        }

        @Override
        public Object[] toArray() {
            return AbstractKeySetBasedMap.this.getInternalKeySet().toArray();
        }

        @Override
        public Object[] toArray(Object[] ao) {
            return AbstractKeySetBasedMap.this.getInternalKeySet().toArray(ao);
        }
    }

    public class EntrySet
    extends AbstractKeyBasedMap.EntrySet {
        public EntrySet() {
            super(AbstractKeySetBasedMap.this);
        }

        @Override
        public Object[] toArray() {
            AbstractKeySetBasedMap map = AbstractKeySetBasedMap.this;
            Object[] ao = map.keySet().toArray();
            int c = ao.length;
            for (int i = 0; i < c; ++i) {
                Object key = ao[i];
                ao[i] = this.instantiateEntry(key, map.get(key));
            }
            return ao;
        }

        @Override
        public Object[] toArray(Object[] ao) {
            Object[] aoRaw = this.toArray();
            if (ao == null) {
                ao = aoRaw;
            } else {
                int cDest = ao.length;
                int cRaw = aoRaw.length;
                if (cDest < cRaw) {
                    ao = (Object[])Array.newInstance(ao.getClass().getComponentType(), cRaw);
                }
                System.arraycopy(aoRaw, 0, ao, 0, cRaw);
                if (cDest > cRaw) {
                    ao[cRaw] = null;
                }
            }
            return ao;
        }
    }

    protected class ValuesCollection
    extends AbstractKeyBasedMap.ValuesCollection {
        protected ValuesCollection() {
            super(AbstractKeySetBasedMap.this);
        }

        @Override
        public Object[] toArray() {
            AbstractKeySetBasedMap map = AbstractKeySetBasedMap.this;
            Object[] ao = map.keySet().toArray();
            int c = ao.length;
            for (int i = 0; i < c; ++i) {
                ao[i] = map.get(ao[i]);
            }
            return ao;
        }

        @Override
        public Object[] toArray(Object[] ao) {
            Object[] aoRaw = this.toArray();
            if (ao == null) {
                ao = aoRaw;
            } else {
                int cDest = ao.length;
                int cRaw = aoRaw.length;
                if (cDest < cRaw) {
                    ao = (Object[])Array.newInstance(ao.getClass().getComponentType(), cRaw);
                }
                System.arraycopy(aoRaw, 0, ao, 0, cRaw);
                if (cDest > cRaw) {
                    ao[cRaw] = null;
                }
            }
            return ao;
        }
    }

    public class KeyIterator
    extends AbstractStableIterator<K> {
        private Iterator<K> m_iter;

        protected KeyIterator(Iterator<K> iter) {
            this.m_iter = iter;
        }

        @Override
        protected void advance() {
            Iterator iter = this.m_iter;
            if (iter.hasNext()) {
                this.setNext(iter.next());
            }
        }

        @Override
        protected void remove(Object oPrev) {
            AbstractKeySetBasedMap.this.removeBlind(oPrev);
        }
    }
}

