/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryWriteBuffer;
import com.tangosol.util.ByteSequence;

public abstract class AbstractByteSequence
implements ByteSequence {
    @Override
    public ByteSequence subSequence(int ofStart, int ofEnd) {
        int cbThis = this.length();
        int cbThat = ofEnd - ofStart;
        if (ofStart < 0 || ofEnd > cbThis || cbThat < 0) {
            throw new IllegalArgumentException("ofStart=" + ofStart + ", ofEnd=" + ofEnd + ", length()=" + cbThis);
        }
        if (ofStart == 0 && ofEnd == cbThis) {
            return this;
        }
        return new PartialByteSequence(this, ofStart, cbThat);
    }

    @Override
    public Binary toBinary() {
        int cb = this.length();
        if (cb == 0) {
            return Binary.NO_BINARY;
        }
        BinaryWriteBuffer writer = new BinaryWriteBuffer(cb);
        for (int of = 0; of < cb; ++of) {
            writer.write(of, this.byteAt(of));
        }
        return writer.toBinary();
    }

    public int hashCode() {
        return Base.toCrc(this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ByteSequence)) {
            return false;
        }
        ByteSequence that = (ByteSequence)o;
        if (this == that) {
            return true;
        }
        int cb = this.length();
        if (cb != that.length()) {
            return false;
        }
        for (int of = 0; of < cb; ++of) {
            if (this.byteAt(of) == that.byteAt(of)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        int cb = this.length();
        int MAX = 256;
        boolean fTrunc = cb > 256;
        return "ByteSequence(length=" + cb + ", value=" + Base.toHexEscape(this, 0, fTrunc ? 256 : cb) + (fTrunc ? "...)" : ")");
    }

    public static class PartialByteSequence
    extends AbstractByteSequence {
        private ByteSequence m_seq;
        private int m_of;
        private int m_cb;

        public PartialByteSequence(ByteSequence seq, int of, int cb) {
            assert (seq != null);
            assert (of >= 0 && of < seq.length());
            assert (cb >= 0 && of + cb <= seq.length());
            this.m_seq = seq;
            this.m_of = of;
            this.m_cb = cb;
        }

        @Override
        public int length() {
            return this.m_cb;
        }

        @Override
        public byte byteAt(int of) {
            if (of < 0 || of >= this.m_cb) {
                throw new IndexOutOfBoundsException("of=" + of + ", range=0.." + (this.m_cb - 1));
            }
            return this.m_seq.byteAt(this.m_of + of);
        }
    }

    public static class AggregateByteSequence
    extends AbstractByteSequence {
        private ByteSequence m_seq1;
        private ByteSequence m_seq2;

        public AggregateByteSequence(ByteSequence seqFirst, ByteSequence seqSecond) {
            this.m_seq1 = seqFirst;
            this.m_seq2 = seqSecond;
        }

        @Override
        public int length() {
            return this.m_seq1.length() + this.m_seq2.length();
        }

        @Override
        public byte byteAt(int of) {
            int cb1 = this.m_seq1.length();
            return of < cb1 ? this.m_seq1.byteAt(of) : this.m_seq2.byteAt(of - cb1);
        }

        @Override
        public ByteSequence subSequence(int ofStart, int ofEnd) {
            int cbThis = this.length();
            int cbThat = ofEnd - ofStart;
            if (ofStart == 0 && ofEnd == this.m_seq1.length()) {
                return this.m_seq1;
            }
            if (ofEnd == cbThis && cbThat == this.m_seq2.length()) {
                return this.m_seq2;
            }
            return super.subSequence(ofStart, ofEnd);
        }
    }
}

