/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.run.xml;

import com.tangosol.run.xml.XmlElement;
import java.util.UnknownFormatConversionException;

public class QualifiedName {
    private String m_sLocalName;
    private String m_sPrefix;

    public QualifiedName(String xmlName) throws UnknownFormatConversionException {
        String[] parts = xmlName.trim().split(":");
        if (parts.length == 1) {
            this.m_sPrefix = "";
            this.m_sLocalName = xmlName.trim();
        } else if (parts.length == 2) {
            if (parts[0].equals("xmlns")) {
                this.m_sLocalName = parts[0].trim();
                this.m_sPrefix = parts[1].trim();
            } else {
                this.m_sPrefix = parts[0].trim();
                this.m_sLocalName = parts[1].trim();
            }
        } else {
            throw new UnknownFormatConversionException(String.format("The specified xmlName [%s] can't be parsed into a QualifiedName", xmlName));
        }
    }

    public QualifiedName(XmlElement xmlElement) throws UnknownFormatConversionException {
        this(xmlElement.getName());
    }

    public QualifiedName(QualifiedName qualifiedName, String localName) {
        this(qualifiedName.getPrefix(), localName);
    }

    public QualifiedName(String prefix, String localName) {
        this.m_sPrefix = prefix.trim();
        this.m_sLocalName = localName.trim();
    }

    public boolean equals(Object other) {
        return other != null && other instanceof QualifiedName && ((QualifiedName)other).m_sPrefix.equals(this.m_sPrefix) && ((QualifiedName)other).m_sLocalName.equals(this.m_sLocalName);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_sLocalName == null ? 0 : this.m_sLocalName.hashCode());
        result = 31 * result + (this.m_sPrefix == null ? 0 : this.m_sPrefix.hashCode());
        return result;
    }

    public String toString() {
        return this.getName();
    }

    public String getPrefix() {
        return this.m_sPrefix;
    }

    public String getLocalName() {
        return this.m_sLocalName;
    }

    public String getName() {
        return this.hasPrefix() ? String.format("%s:%s", this.getPrefix(), this.getLocalName()) : this.getLocalName();
    }

    public boolean hasPrefix() {
        return this.m_sPrefix.length() > 0;
    }
}

