/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.run.xml;

import com.tangosol.run.xml.IterableAdapter;
import com.tangosol.run.xml.PropertyAdapter;
import com.tangosol.run.xml.XmlBean;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.run.xml.XmlValue;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ArrayAdapter
extends IterableAdapter {
    private Class m_clzElement;
    private PropertyAdapter m_adapterElement;

    public ArrayAdapter(XmlBean.BeanInfo infoBean, Class clzType, String sName, String sXml, XmlElement xml) {
        super(infoBean, clzType, sName, sXml, xml);
        Class<?> clzElement;
        ArrayAdapter.azzert(Object[].class.isAssignableFrom(clzType));
        Class clzArray = this.getType();
        XmlElement xmlClz = xml.getElement("class");
        if (xmlClz != null) {
            clzArray = infoBean.resolveClass(xmlClz.getString());
        }
        ArrayAdapter.azzert((clzElement = clzArray.getComponentType()) != null);
        this.m_clzElement = clzElement;
        XmlElement xmlElement = xml.ensureElement("element");
        xmlElement.ensureElement("type").setString(clzElement.getName());
        this.m_adapterElement = this.findAdapter(infoBean, xmlElement);
    }

    @Override
    public int hash(Object o) {
        Object[] ao = (Object[])o;
        if (ao == null || ao.length == 0) {
            return 0;
        }
        int n = 0;
        PropertyAdapter adapterElement = this.m_adapterElement;
        for (Object oElement : ao) {
            if (oElement == null) continue;
            n ^= adapterElement.hash(oElement);
        }
        return n;
    }

    @Override
    public boolean equalsValue(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        Object[] ao1 = (Object[])o1;
        Object[] ao2 = (Object[])o2;
        if (ao1.length != ao2.length) {
            return false;
        }
        PropertyAdapter adapterElement = this.m_adapterElement;
        int c = ao1.length;
        for (int i = 0; i < c; ++i) {
            Object oElement1 = ao1[i];
            Object oElement2 = ao2[i];
            if (adapterElement.equalsValue(oElement1, oElement2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object clone(Object o) {
        if (o == null) {
            return null;
        }
        Object[] aoOld = (Object[])o;
        int c = aoOld.length;
        if (c == 0) {
            return aoOld;
        }
        Object[] aoNew = (Object[])aoOld.clone();
        PropertyAdapter adapterElement = this.m_adapterElement;
        for (int i = 0; i < c; ++i) {
            Object oOld = aoNew[i];
            if (oOld == null) continue;
            aoNew[i] = adapterElement.clone(oOld);
        }
        return aoNew;
    }

    @Override
    protected Object readElements(XmlElement xml) {
        Iterator iter;
        PropertyAdapter adapterElement = this.m_adapterElement;
        Iterator iterator = iter = adapterElement.isAnonymous() ? xml.getElementList().iterator() : XmlHelper.getElements(xml, this.getElementName(), adapterElement.getNamespaceUri());
        if (this.isSparse()) {
            int c = xml.getSafeAttribute("length").getInt();
            Object[] ao = (Object[])Array.newInstance(this.m_clzElement, c);
            while (iter.hasNext()) {
                XmlElement xmlElement = (XmlElement)iter.next();
                Object oElement = adapterElement.fromXml(xmlElement);
                XmlValue attrId = xmlElement.getAttribute("id");
                if (attrId == null) {
                    throw new IllegalArgumentException("Element " + xmlElement.getName() + " is missing the required \"id\" attribute");
                }
                ao[attrId.getInt((int)-1)] = oElement;
            }
            return ao;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        while (iter.hasNext()) {
            XmlElement xmlElement = (XmlElement)iter.next();
            Object oElement = adapterElement.fromXml(xmlElement);
            list.add(oElement);
        }
        return list.isEmpty() ? null : list.toArray((Object[])Array.newInstance(this.m_clzElement, list.size()));
    }

    @Override
    protected void writeElements(XmlElement xml, Object o) {
        PropertyAdapter adapterElement = this.m_adapterElement;
        boolean fAnonymous = adapterElement.isAnonymous();
        String sNmsPrefix = null;
        String sElement = null;
        if (!fAnonymous) {
            sNmsPrefix = adapterElement.getNamespacePrefix();
            sElement = XmlHelper.getUniversalName(this.getElementName(), sNmsPrefix);
        }
        Object[] ao = (Object[])o;
        int c = ao.length;
        boolean fSparse = this.isSparse();
        if (fSparse) {
            xml.addAttribute("length").setInt(c);
        }
        List list = xml.getElementList();
        for (int i = 0; i < c; ++i) {
            Object oElement = ao[i];
            if (oElement == null) {
                if (fSparse || fAnonymous) continue;
                xml.addElement(sElement);
                continue;
            }
            XmlElement xmlElement = adapterElement.toXml(oElement);
            if (fAnonymous) {
                List listElement = xmlElement.getElementList();
                int cElements = listElement.size();
                if (cElements == 1) {
                    list.add(listElement.get(0));
                    continue;
                }
                if (cElements <= 1) continue;
                throw new IllegalStateException("Too many elements: " + String.valueOf(xmlElement) + "\nadapter=" + String.valueOf(adapterElement));
            }
            xmlElement.setName(sElement);
            if (fSparse) {
                xmlElement.addAttribute("id").setInt(i);
            }
            list.add(xmlElement);
        }
    }

    @Override
    public Object readExternal(DataInput in) throws IOException {
        int c = ArrayAdapter.readInt(in);
        Object[] ao = c < 0x7FFFFF ? this.readArray(in, c) : this.readLargeArray(in, c);
        return ao;
    }

    protected Object[] readArray(DataInput in, int c) throws IOException {
        Object[] ao = (Object[])Array.newInstance(this.m_clzElement, c);
        PropertyAdapter adapter = this.m_adapterElement;
        for (int i = 0; i < c; ++i) {
            if (!in.readBoolean()) continue;
            ao[i] = adapter.readExternal(in);
        }
        return ao;
    }

    protected Object[] readLargeArray(DataInput in, int c) throws IOException {
        int cBatchMax = 0x3FFFFF;
        int cBatch = c / cBatchMax + 1;
        Object[] aMerged = null;
        int cRead = 0;
        int cAllocate = cBatchMax;
        for (int i = 0; i < cBatch && cRead < c; ++i) {
            Object[] ao = this.readArray(in, cAllocate);
            aMerged = ArrayAdapter.mergeArray(aMerged, ao);
            cAllocate = Math.min(c - (cRead += ao.length), cBatchMax);
        }
        return aMerged;
    }

    @Override
    public void writeExternal(DataOutput out, Object o) throws IOException {
        Object[] ao = (Object[])o;
        int c = ao.length;
        ArrayAdapter.writeInt(out, c);
        PropertyAdapter adapter = this.m_adapterElement;
        for (int i = 0; i < c; ++i) {
            Object oElement = ao[i];
            boolean fExists = oElement != null;
            out.writeBoolean(fExists);
            if (!fExists) continue;
            adapter.writeExternal(out, oElement);
        }
    }

    @Override
    public boolean isEmpty(Object o) {
        return o == null || this.isEmptyIsNull() && ((Object[])o).length == 0;
    }
}

