/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.run.jca;

import com.tangosol.net.cache.CacheMap;
import com.tangosol.util.Base;
import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.TransactionMap;
import com.tangosol.util.Versionable;
import com.tangosol.util.filter.PresentFilter;
import com.tangosol.util.processor.ConditionalProcessor;
import java.io.Serializable;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SimpleValidator
extends Base
implements TransactionMap.Validator {
    private TransactionMap.Validator m_validatorNext;
    protected Map m_mapVersion = new HashMap();

    public Map getVersionMap() {
        return this.m_mapVersion;
    }

    @Override
    public void enlist(TransactionMap mapTx, Object oKey) {
        Map mapVersion = this.getVersionMap();
        if (!mapVersion.containsKey(oKey)) {
            mapVersion.put(oKey, this.calculateVersion(mapTx.getBaseMap().get(oKey)));
            TransactionMap.Validator validatorNext = this.getNextValidator();
            if (validatorNext != null) {
                validatorNext.enlist(mapTx, oKey);
            }
        }
    }

    @Override
    public void validate(TransactionMap mapTx, Set setInsert, Set setUpdate, Set setDelete, Set setRead, Set setPhantom) throws ConcurrentModificationException {
        TransactionMap.Validator validatorNext = this.getNextValidator();
        if (validatorNext != null) {
            validatorNext.validate(mapTx, setInsert, setUpdate, setDelete, setRead, setPhantom);
        }
        if (!setInsert.isEmpty()) {
            this.validateInsert(mapTx, setInsert);
        }
        if (!setUpdate.isEmpty()) {
            this.validateVersion(mapTx, setUpdate);
        }
        if (!setDelete.isEmpty()) {
            this.validateVersion(mapTx, setDelete);
        }
        if (!setRead.isEmpty()) {
            this.validateValue(mapTx, setRead);
        }
        if (!setPhantom.isEmpty()) {
            throw new ConcurrentModificationException("Phantom set is not empty: " + String.valueOf(setPhantom));
        }
    }

    @Override
    public TransactionMap.Validator getNextValidator() {
        return this.m_validatorNext;
    }

    @Override
    public void setNextValidator(TransactionMap.Validator validator) {
        this.m_validatorNext = validator;
    }

    protected void validateInsert(TransactionMap mapTx, Set setKey) {
        ConcurrentMap mapBase = mapTx.getBaseMap();
        if (mapBase instanceof InvocableMap) {
            InvocableMap cacheBase = (InvocableMap)((Object)mapBase);
            Map mapExists = cacheBase.invokeAll(setKey, new ConditionalProcessor(PresentFilter.INSTANCE, NullImplementation.getEntryProcessor()));
            for (Map.Entry entry : mapExists.entrySet()) {
                if (entry.getValue() != null) continue;
                setKey.remove(entry.getKey());
            }
        } else {
            Iterator iter = setKey.iterator();
            while (iter.hasNext()) {
                Object oKey = iter.next();
                if (mapBase.containsKey(oKey)) continue;
                iter.remove();
            }
        }
        if (!setKey.isEmpty()) {
            throw new ConcurrentModificationException("Insert conflict for: " + String.valueOf(setKey));
        }
    }

    protected void validateVersion(TransactionMap mapTx, Set setKey) {
        ConcurrentMap mapBase = mapTx.getBaseMap();
        Map mapVersion = this.getVersionMap();
        ConcurrentMap mapCurrent = mapBase instanceof CacheMap ? ((CacheMap)((Object)mapBase)).getAll(setKey) : mapBase;
        Iterator iter = setKey.iterator();
        while (iter.hasNext()) {
            Object oKey = iter.next();
            Comparable oOrig = (Comparable)mapVersion.get(oKey);
            Comparable oCurr = this.calculateVersion(mapCurrent.get(oKey));
            if (oCurr.compareTo(oOrig) != 0) continue;
            iter.remove();
        }
        if (!setKey.isEmpty()) {
            throw new ConcurrentModificationException("Version conflict for: " + String.valueOf(setKey));
        }
    }

    protected void validateValue(TransactionMap mapTx, Set setKey) {
        ConcurrentMap mapBase = mapTx.getBaseMap();
        ConcurrentMap mapCurrent = mapBase instanceof CacheMap ? ((CacheMap)((Object)mapBase)).getAll(setKey) : mapBase;
        Iterator iter = setKey.iterator();
        while (iter.hasNext()) {
            Object oValCurr;
            Object oKey = iter.next();
            Object oValTx = mapTx.get(oKey);
            if (!SimpleValidator.equals(oValTx, oValCurr = mapCurrent.get(oKey))) continue;
            iter.remove();
        }
        if (!setKey.isEmpty()) {
            throw new ConcurrentModificationException("Value conflict for: " + String.valueOf(setKey));
        }
    }

    protected Comparable calculateVersion(Object oValue) {
        return oValue == null ? Integer.valueOf(0) : (oValue instanceof Versionable ? ((Versionable)oValue).getVersionIndicator() : (oValue instanceof Serializable ? Integer.valueOf(ExternalizableHelper.toBinary(oValue).hashCode()) : Integer.valueOf(oValue.hashCode())));
    }
}

