/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.persistence.bdb;

import com.oracle.coherence.common.io.Files;
import com.oracle.coherence.persistence.ConcurrentAccessException;
import com.oracle.coherence.persistence.FatalAccessException;
import com.oracle.coherence.persistence.OfflinePersistenceInfo;
import com.oracle.coherence.persistence.PersistenceException;
import com.oracle.coherence.persistence.PersistenceTools;
import com.oracle.coherence.persistence.PersistentStore;
import com.tangosol.coherence.config.Config;
import com.tangosol.internal.sleepycat.je.CacheMode;
import com.tangosol.internal.sleepycat.je.CheckpointConfig;
import com.tangosol.internal.sleepycat.je.Cursor;
import com.tangosol.internal.sleepycat.je.Database;
import com.tangosol.internal.sleepycat.je.DatabaseConfig;
import com.tangosol.internal.sleepycat.je.DatabaseEntry;
import com.tangosol.internal.sleepycat.je.DatabaseException;
import com.tangosol.internal.sleepycat.je.DiskOrderedCursor;
import com.tangosol.internal.sleepycat.je.DiskOrderedCursorConfig;
import com.tangosol.internal.sleepycat.je.Durability;
import com.tangosol.internal.sleepycat.je.Environment;
import com.tangosol.internal.sleepycat.je.EnvironmentConfig;
import com.tangosol.internal.sleepycat.je.EnvironmentFailureException;
import com.tangosol.internal.sleepycat.je.EnvironmentLockedException;
import com.tangosol.internal.sleepycat.je.OperationStatus;
import com.tangosol.internal.sleepycat.je.StatsConfig;
import com.tangosol.internal.sleepycat.je.Transaction;
import com.tangosol.internal.sleepycat.je.VerifyConfig;
import com.tangosol.internal.sleepycat.je.config.EnvironmentParams;
import com.tangosol.internal.sleepycat.je.dbi.EnvironmentFailureReason;
import com.tangosol.internal.sleepycat.je.util.DbBackup;
import com.tangosol.internal.sleepycat.je.util.LogVerificationInputStream;
import com.tangosol.internal.util.DaemonPool;
import com.tangosol.io.ByteArrayReadBuffer;
import com.tangosol.io.FileHelper;
import com.tangosol.io.ReadBuffer;
import com.tangosol.net.GuardSupport;
import com.tangosol.net.Guardian;
import com.tangosol.net.cache.KeyAssociation;
import com.tangosol.persistence.AbstractPersistenceManager;
import com.tangosol.persistence.CachePersistenceHelper;
import com.tangosol.persistence.SafePersistenceWrappers;
import com.tangosol.util.Binary;
import com.tangosol.util.Unsafe;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.AccessController;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BerkeleyDBManager
extends AbstractPersistenceManager<BerkeleyDBStore> {
    protected final boolean f_fRemoteData;
    public static final String SYS_PROP_PREFIX = "coherence.distributed.persistence.bdb.";
    protected static final int MAX_LOCK_TIMEOUT = 4500000;
    protected static final String LOCK_FILENAME = "je.lck";
    protected static final boolean MAINTENANCE_ENABLED = Config.getBoolean("coherence.distributed.persistence.bdb.maintenance.enabled", true) && System.getProperty("je.env.runCheckpointer", null) == null && System.getProperty("je.env.runCleaner", null) == null && System.getProperty("je.env.runINCompressor", null) == null;
    protected static final boolean STATS_ENABLED = Config.getBoolean("coherence.distributed.persistence.bdb.stats.enabled", false);
    protected static final boolean MAINTENANCE_DEBUG_ENABLED = Config.getBoolean("coherence.distributed.persistence.bdb.maintenance.debug", false);
    protected static final long LOG_BUFFER_SIZE = BerkeleyDBManager.parseMemorySize("25KB");
    protected static final int LOG_NUM_BUFFERS = 3;
    protected static final long CHECKPOINT_INTERVAL = (long)((double)Long.valueOf(EnvironmentParams.LOG_FILE_MAX.getDefault()).longValue() * 0.75);
    protected static final long CLEAN_INTERVAL = Long.valueOf(EnvironmentParams.LOG_FILE_MAX.getDefault()) / 4L;
    protected static final long COMPRESS_INTERVAL = 15000L;
    protected static final long STATS_CHECK_BYTES = Math.min(CLEAN_INTERVAL, CHECKPOINT_INTERVAL) / 2L;
    protected static final long STATS_CHECK_COUNT = 1000L;
    protected static final EnvironmentConfig ENVIRONMENT_CONFIG;
    private static final DatabaseConfig DATABASE_CONFIG;
    private static final DiskOrderedCursorConfig CURSOR_CONFIG;
    private static final CheckpointConfig CHECKPOINT_CONFIG;
    private static final Unsafe UNSAFE;
    private static final Properties USER_SPECIFIED_PROPERTIES;

    public BerkeleyDBManager(File fileData, File fileTrash, String sName) throws IOException {
        super(fileData, fileTrash, sName);
        this.f_fRemoteData = !Files.isLocal(fileData);
        String sProp = EnvironmentParams.LOG_USE_ODSYNC.getName();
        if (this.f_fRemoteData && (USER_SPECIFIED_PROPERTIES == null || !USER_SPECIFIED_PROPERTIES.containsKey(sProp))) {
            com.oracle.coherence.common.base.Logger.info("\"" + String.valueOf(fileData) + "\" appears to reference a remote file-system and as such Coherence persistence is enabling \"coherence.distributed.persistence.bdb." + sProp + "\" in order ensure the integrity of remote commits. As this may impact write performance you may explicitly set the system property to \"false\" to override this decision; though this is only recommended if the location is actually a local file-system.");
        }
    }

    @Override
    protected int getImplVersion() {
        return 0;
    }

    @Override
    protected String getStorageFormat() {
        return "BDB";
    }

    @Override
    public synchronized void maintainEnvironment() {
        Map map = this.getPersistentStoreMap();
        for (BerkeleyDBStore store : map.values()) {
            store.maintainEnvironment();
        }
    }

    @Override
    protected int getStorageVersion() {
        return 0;
    }

    protected void createSnapshot(final File fileSnapshot) {
        this.executeTaskExclusive(new AbstractPersistenceManager.Task(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                Map map = BerkeleyDBManager.this.getPersistentStoreMap();
                for (BerkeleyDBStore store : map.values()) {
                    GuardSupport.heartbeat();
                    File fileDirFrom = store.getDataDirectory();
                    try {
                        File fileDirTo = FileHelper.ensureDir(new File(fileSnapshot, fileDirFrom.getName()));
                        store.checkPoint();
                        File fileLock = new File(fileDirTo, BerkeleyDBManager.LOCK_FILENAME);
                        if (!fileLock.createNewFile()) {
                            throw BerkeleyDBManager.this.ensurePersistenceException(new IOException("cannot create new lock file\"" + String.valueOf(fileLock) + "\""));
                        }
                        CachePersistenceHelper.copyMetadata(fileDirFrom, fileDirTo);
                        Environment env = store.m_env;
                        DbBackup backup = new DbBackup(env);
                        backup.startBackup();
                        try {
                            BerkeleyDBManager.copyLogFiles(env, backup.getLogFilesInBackupSet(), fileDirTo);
                        }
                        finally {
                            backup.endBackup();
                        }
                    }
                    catch (Exception e) {
                        throw BerkeleyDBManager.this.ensurePersistenceException(e, "error creating snapshot \"" + String.valueOf(fileSnapshot) + "\" while copying persistent store \"" + String.valueOf(fileDirFrom) + "\"");
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void copyLogFiles(Environment env, String[] asFiles, File fileDir) throws IOException, DatabaseException {
        int cFiles;
        File fileEnv = env.getHome();
        int n = cFiles = asFiles == null ? 0 : asFiles.length;
        if (cFiles > 0) {
            byte[] BUF = new byte[10240];
            block11: for (int i = 0; i < cFiles; ++i) {
                String sFile = asFiles[i];
                if (sFile == null || (sFile = sFile.trim()).isEmpty()) continue;
                File fileFrom = new File(fileEnv, sFile);
                File fileTo = new File(fileDir, sFile);
                InputStream in = null;
                OutputStream out = null;
                try {
                    in = new LogVerificationInputStream(env, new FileInputStream(fileFrom), sFile);
                    out = new FileOutputStream(fileTo);
                    while (true) {
                        int cb;
                        if ((cb = in.read(BUF)) < 0) {
                            continue block11;
                        }
                        out.write(BUF, 0, cb);
                    }
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
    }

    protected static void setConfigParam(EnvironmentConfig cfg, String sName, String sValue) {
        if (System.getProperty(sName, null) == null) {
            cfg.setConfigParam(sName, sValue);
        }
    }

    @Override
    protected PersistenceTools instantiatePersistenceTools(OfflinePersistenceInfo info) {
        return new AbstractPersistenceManager.AbstractPersistenceSnapshotTools(this.getDataDirectory(), info){

            @Override
            public void validate() {
                String[] asFileList = this.f_info.getGUIDs();
                int nImplVersion = -1;
                int nStorageVersion = -1;
                for (String sFileName : asFileList) {
                    File fileStore = new File(this.f_dirSnapshot, sFileName);
                    if (FileHelper.isEmpty(fileStore)) continue;
                    this.validateBDBEnvironment(fileStore);
                    this.validateStoreSealed(sFileName);
                    try {
                        Properties props = CachePersistenceHelper.readMetadata(fileStore);
                        int nThisImplVersion = Integer.valueOf(props.getProperty("implementation.version"));
                        int nThisStorageVersion = Integer.valueOf(props.getProperty("storage.version"));
                        if (nImplVersion == -1) {
                            nImplVersion = nThisImplVersion;
                            nStorageVersion = nThisStorageVersion;
                            continue;
                        }
                        if (nThisImplVersion == nImplVersion && nThisStorageVersion == nStorageVersion) continue;
                        throw new IllegalStateException("Implementation and storage versions are inconsistent across stores in directory: " + this.f_dirSnapshot.getCanonicalPath());
                    }
                    catch (IOException ioe) {
                        throw CachePersistenceHelper.ensurePersistenceException(ioe, "Unable to read metadata for " + String.valueOf(fileStore));
                    }
                }
            }

            protected void validateBDBEnvironment(File fileEnvironment) {
                try (Environment env = new Environment(fileEnvironment, ENVIRONMENT_CONFIG);){
                    env.verify(VerifyConfig.DEFAULT, new PrintStream(System.out));
                }
                catch (Exception e) {
                    throw CachePersistenceHelper.ensurePersistenceException(e, "Unable to validate BDB Environment at " + fileEnvironment.getAbsolutePath());
                }
            }
        };
    }

    @Override
    protected BerkeleyDBStore instantiatePersistentStore(String sId) {
        return new BerkeleyDBStore(sId);
    }

    static {
        DATABASE_CONFIG = new DatabaseConfig().setAllowCreate(true).setTransactional(true);
        CURSOR_CONFIG = new DiskOrderedCursorConfig();
        CHECKPOINT_CONFIG = new CheckpointConfig().setForce(true);
        UNSAFE = AccessController.doPrivileged(Unsafe::getUnsafe);
        Level logLevel = Level.parse(System.getProperty("com.tangosol.internal.sleepycat.je.level", Level.WARNING.getName()));
        Logger.getLogger("com.tangosol.internal.sleepycat.je").setLevel(logLevel);
        Properties props = null;
        for (String sKey : EnvironmentParams.SUPPORTED_PARAMS.keySet()) {
            String sValue = System.getProperty(SYS_PROP_PREFIX + sKey, System.getProperty(sKey));
            if (sValue == null) continue;
            if (props == null) {
                props = new Properties();
            }
            props.put(sKey, sValue);
        }
        USER_SPECIFIED_PROPERTIES = props;
        ENVIRONMENT_CONFIG = props == null ? new EnvironmentConfig() : new EnvironmentConfig(props);
        EnvironmentConfig cfg = ENVIRONMENT_CONFIG;
        cfg.setAllowCreate(true).setCacheMode(CacheMode.EVICT_LN).setDurability(Durability.COMMIT_WRITE_NO_SYNC);
        BerkeleyDBManager.setConfigParam(cfg, "je.log.bufferSize", String.valueOf(LOG_BUFFER_SIZE));
        BerkeleyDBManager.setConfigParam(cfg, "je.log.numBuffers", String.valueOf(3));
        BerkeleyDBManager.setConfigParam(cfg, "je.log.useWriteQueue", Boolean.FALSE.toString());
        BerkeleyDBManager.setConfigParam(cfg, "je.haltOnCommitAfterChecksumException", Boolean.TRUE.toString());
        BerkeleyDBManager.setConfigParam(cfg, "je.stats.collect", Boolean.FALSE.toString());
        cfg.setSharedCache(true);
        cfg.setTransactional(true);
        cfg.setLockTimeout(305L, TimeUnit.SECONDS);
        if (MAINTENANCE_ENABLED) {
            BerkeleyDBManager.setConfigParam(cfg, "je.env.runCheckpointer", Boolean.FALSE.toString());
            BerkeleyDBManager.setConfigParam(cfg, "je.env.runCleaner", Boolean.FALSE.toString());
            BerkeleyDBManager.setConfigParam(cfg, "je.env.runINCompressor", Boolean.FALSE.toString());
        }
    }

    protected class BerkeleyDBStore
    extends AbstractPersistenceManager.AbstractPersistentStore {
        protected final Map<Long, Database> f_mapDB;
        protected Environment m_env;
        protected long m_cbLogCheckpoint;
        protected long m_cbLogClean;
        protected volatile long m_cbLastCheckpoint;
        protected volatile long m_cbLastClean;
        protected volatile long m_ldtLastCompress;
        protected volatile boolean m_fMaintenanceScheduled;
        protected final AtomicInteger f_cChecks;
        protected final AtomicLong f_cbWritten;
        protected volatile long m_ltdLastErase;

        protected BerkeleyDBStore(String sId) {
            super(sId);
            this.f_mapDB = new HashMap<Long, Database>();
            this.f_cChecks = new AtomicInteger();
            this.f_cbWritten = new AtomicLong();
        }

        @Override
        protected void copyAndOpenInternal(PersistentStore<ReadBuffer> storeFrom) {
            if ((storeFrom = SafePersistenceWrappers.unwrap(storeFrom)) instanceof BerkeleyDBStore) {
                try {
                    BerkeleyDBStore storeBDB = (BerkeleyDBStore)storeFrom;
                    storeBDB.validateMetadata();
                    Path dirStore = storeBDB.f_dirStore.toPath();
                    java.nio.file.Files.walkFileTree(dirStore, EnumSet.noneOf(FileVisitOption.class), 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                            File fileSrc = path.toFile();
                            if (fileSrc.isFile() && fileSrc.getName().endsWith(".jdb")) {
                                java.nio.file.Files.copy(path, BerkeleyDBStore.this.f_dirStore.toPath().resolve(fileSrc.getName()), new CopyOption[0]);
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                            return FileVisitResult.CONTINUE;
                        }
                    });
                    this.openInternal();
                }
                catch (PersistenceException | IOException e) {
                    this.delete(false);
                    throw e instanceof PersistenceException ? (PersistenceException)e : this.ensurePersistenceException(e, "Unable to copy from previous store to new store; from " + String.valueOf(storeFrom) + " to " + String.valueOf(this));
                }
            } else {
                super.copyAndOpenInternal(storeFrom);
            }
        }

        protected void checkPoint() {
            this.ensureEnvironment().checkpoint(CHECKPOINT_CONFIG);
        }

        @Override
        protected void openInternal() {
            if (this.m_env == null) {
                long cMillis;
                Guardian guardian;
                DaemonPool pool;
                EnvironmentConfig cfg = ENVIRONMENT_CONFIG.clone();
                if (BerkeleyDBManager.this.f_fRemoteData) {
                    String sProp = EnvironmentParams.LOG_USE_ODSYNC.getName();
                    if (USER_SPECIFIED_PROPERTIES == null || !USER_SPECIFIED_PROPERTIES.containsKey(sProp)) {
                        cfg.setConfigParam(sProp, Boolean.TRUE.toString());
                    }
                }
                if ((pool = BerkeleyDBManager.this.getDaemonPool()) != null && (guardian = pool.getGuardian()) != null && (cMillis = guardian.getDefaultGuardTimeout()) != cfg.getLockTimeout(TimeUnit.MILLISECONDS)) {
                    cfg.setLockTimeout(Math.min(cMillis, 4500000L), TimeUnit.MILLISECONDS);
                }
                while (true) {
                    try {
                        this.m_env = new Environment(this.f_dirStore, cfg);
                    }
                    catch (DatabaseException | AssertionError eTop) {
                        if (eTop instanceof EnvironmentFailureException && EnvironmentFailureReason.FOUND_COMMITTED_TXN == ((EnvironmentFailureException)eTop).getReason()) {
                            com.oracle.coherence.common.base.Logger.err("The persistence store " + FileHelper.getPath(this.f_dirStore) + " appears to be corrupt and could only be partially read\n" + ((Throwable)eTop).getMessage() + "\n", (Throwable)eTop);
                            cfg = cfg.clone().setConfigParam("je.haltOnCommitAfterChecksumException", Boolean.FALSE.toString());
                            continue;
                        }
                        String sMessage = "error opening the BerkeleyDB environment in directory \"" + String.valueOf(this.f_dirStore) + "\"";
                        if (eTop instanceof EnvironmentLockedException) {
                            throw this.ensurePersistenceException(new ConcurrentAccessException(sMessage, (Throwable)eTop));
                        }
                        throw this.ensurePersistenceException(new FatalAccessException(sMessage, (Throwable)eTop));
                    }
                    break;
                }
            }
        }

        @Override
        protected void releaseInternal() {
            for (Database db : this.f_mapDB.values()) {
                try {
                    db.close();
                }
                catch (Throwable throwable) {}
            }
            this.f_mapDB.clear();
            Environment env = this.m_env;
            if (env != null) {
                try {
                    env.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.m_env = null;
            }
        }

        @Override
        protected boolean deleteInternal() {
            return true;
        }

        @Override
        protected void loadExtentIdsInternal(Set<Long> set) {
            try {
                for (String sName : this.ensureEnvironment().getDatabaseNames()) {
                    Long LId = Long.valueOf(sName);
                    if (!set.add(Long.valueOf(sName))) continue;
                    this.openDatabase(LId);
                }
            }
            catch (DatabaseException e) {
                throw this.ensurePersistenceException(e);
            }
        }

        @Override
        protected void createExtentInternal(long lExtentId) {
            this.openDatabase(lExtentId);
        }

        @Override
        protected void deleteExtentInternal(long lExtentId) {
            this.removeDatabase(lExtentId);
        }

        @Override
        protected void moveExtentInternal(long lOldExtentId, long lNewExtentId) {
            this.renameDatabase(lOldExtentId, lNewExtentId);
        }

        @Override
        protected void truncateExtentInternal(long lExtentId) {
            this.truncateDatabase(lExtentId);
            this.m_ltdLastErase = BerkeleyDBStore.getSafeTimeMillis();
        }

        @Override
        protected ReadBuffer loadInternal(long lExtentId, ReadBuffer bufKey) {
            DatabaseEntry entryKey = new DatabaseEntry(this.getByteArrayUnsafe(bufKey));
            DatabaseEntry entryValue = new DatabaseEntry();
            try {
                OperationStatus status = this.ensureDatabase(lExtentId).get(null, entryKey, entryValue, null);
                return status == OperationStatus.SUCCESS ? this.newBinaryUnsafe(entryValue.getData()) : null;
            }
            catch (DatabaseException e) {
                throw this.ensurePersistenceException(e);
            }
        }

        @Override
        protected void storeInternal(long lExtentId, ReadBuffer bufKey, ReadBuffer bufValue, Object oToken) {
            try {
                this.ensureDatabase(lExtentId).put(this.ensureTransaction(oToken), new DatabaseEntry(this.getByteArrayUnsafe(bufKey)), new DatabaseEntry(this.getByteArrayUnsafe(bufValue)));
            }
            catch (DatabaseException e) {
                throw this.ensurePersistenceException(e);
            }
            this.maintainEnvironment(bufKey, bufValue);
        }

        @Override
        protected void eraseInternal(long lExtentId, ReadBuffer bufKey, Object oToken) {
            try {
                this.ensureDatabase(lExtentId).delete(this.ensureTransaction(oToken), new DatabaseEntry(this.getByteArrayUnsafe(bufKey)));
            }
            catch (DatabaseException e) {
                throw this.ensurePersistenceException(e);
            }
            this.maintainEnvironment(bufKey, null);
        }

        @Override
        public void iterateInternal(PersistentStore.Visitor<ReadBuffer> visitor) {
            for (Database db : this.f_mapDB.values()) {
                long lExtentId = Long.valueOf(db.getDatabaseName());
                if (!visitor.visitExtent(lExtentId)) continue;
                DatabaseEntry entryKey = new DatabaseEntry();
                DatabaseEntry entryValue = new DatabaseEntry();
                ReadBuffer bufStart = visitor.visitFromKey();
                try {
                    if (bufStart == null) {
                        DiskOrderedCursor cursor = db.openCursor(CURSOR_CONFIG);
                        try {
                            while (cursor.getNext(entryKey, entryValue, null) == OperationStatus.SUCCESS) {
                                Binary bufValue;
                                Binary bufKey = this.newBinaryUnsafe(entryKey.getData());
                                if (visitor.visit(lExtentId, bufKey, bufValue = this.newBinaryUnsafe(entryValue.getData()))) continue;
                                return;
                            }
                            continue;
                        }
                        finally {
                            if (cursor == null) continue;
                            cursor.close();
                            continue;
                        }
                    }
                    boolean fLast = bufStart.equals(CachePersistenceHelper.LAST_ENTRY);
                    Cursor cursor = db.openCursor(null, null);
                    try {
                        OperationStatus status;
                        if (fLast) {
                            status = cursor.getLast(entryKey, entryValue, null);
                        } else {
                            entryKey.setData(bufStart.toByteArray());
                            status = cursor.getSearchKey(entryKey, entryValue, null);
                        }
                        while (status == OperationStatus.SUCCESS) {
                            Binary bufValue;
                            Binary bufKey = this.newBinaryUnsafe(entryKey.getData());
                            if (!visitor.visit(lExtentId, bufKey, bufValue = this.newBinaryUnsafe(entryValue.getData())) || fLast) {
                                return;
                            }
                            status = cursor.getNext(entryKey, entryValue, null);
                        }
                    }
                    finally {
                        if (cursor == null) continue;
                        cursor.close();
                    }
                }
                catch (Throwable e) {
                    throw this.ensurePersistenceException(e);
                }
            }
        }

        @Override
        public Object beginInternal() {
            try {
                return this.ensureEnvironment().beginTransaction(null, null);
            }
            catch (DatabaseException e) {
                throw this.ensurePersistenceException(e);
            }
        }

        @Override
        public void commitInternal(Object oToken) {
            try {
                this.ensureTransaction(oToken).commit();
            }
            catch (DatabaseException e) {
                throw this.ensurePersistenceException(e);
            }
            this.maintainEnvironment();
        }

        @Override
        public void abortInternal(Object oToken) {
            try {
                this.ensureTransaction(oToken).abort();
            }
            catch (DatabaseException e) {
                throw this.ensurePersistenceException(e);
            }
            this.maintainEnvironment();
        }

        public long getTotalLogFileSize() {
            try {
                return this.ensureEnvironment().getStats(StatsConfig.DEFAULT).getTotalLogSize();
            }
            catch (DatabaseException e) {
                throw this.ensurePersistenceException(e);
            }
        }

        private byte[] getByteArrayUnsafe(ReadBuffer buf) {
            byte[] ab;
            ByteArrayReadBuffer babuf;
            if (buf instanceof Binary) {
                byte[] ab2;
                Binary bin = (Binary)buf;
                if (UNSAFE.getArrayOffset(bin) == 0 && (ab2 = UNSAFE.getByteArray(bin)).length == bin.length()) {
                    return ab2;
                }
            } else if (buf instanceof ByteArrayReadBuffer && (babuf = (ByteArrayReadBuffer)buf).getRawOffset() == 0 && (ab = babuf.getRawByteArray()).length == babuf.length()) {
                return ab;
            }
            return buf.toByteArray();
        }

        private Binary newBinaryUnsafe(byte[] ab) {
            return UNSAFE.newBinary(ab, 0, ab.length);
        }

        protected Environment ensureEnvironment() {
            Environment env = this.m_env;
            if (env == null) {
                throw new IllegalStateException("the BerkeleyDB environment \"" + String.valueOf(this.f_dirStore) + "\" is not open");
            }
            return env;
        }

        protected Database ensureDatabase(long lExtentId) {
            Database db = this.f_mapDB.get(lExtentId);
            if (db == null) {
                throw new IllegalStateException("the BerkeleyDB database \"" + lExtentId + "\" is not open");
            }
            return db;
        }

        protected Database openDatabase(long lExtentId) {
            try {
                Database db = this.ensureEnvironment().openDatabase(null, String.valueOf(lExtentId), DATABASE_CONFIG);
                this.f_mapDB.put(lExtentId, db);
                return db;
            }
            catch (DatabaseException e) {
                throw this.ensurePersistenceException(e);
            }
        }

        protected void closeDatabase(long lExtentId) {
            Database db = this.f_mapDB.remove(lExtentId);
            if (db != null) {
                try {
                    db.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        protected void removeDatabase(long lExtentId) {
            this.closeDatabase(lExtentId);
            try {
                this.ensureEnvironment().removeDatabase(null, String.valueOf(lExtentId));
            }
            catch (DatabaseException e) {
                throw this.ensurePersistenceException(e);
            }
        }

        protected void renameDatabase(long lOldExtentId, long lNewExtentId) {
            this.closeDatabase(lOldExtentId);
            try {
                this.ensureEnvironment().renameDatabase(null, String.valueOf(lOldExtentId), String.valueOf(lNewExtentId));
            }
            catch (DatabaseException e) {
                throw this.ensurePersistenceException(e);
            }
        }

        protected void truncateDatabase(long lExtentId) {
            this.closeDatabase(lExtentId);
            try {
                this.ensureEnvironment().truncateDatabase(null, String.valueOf(lExtentId), false);
            }
            catch (DatabaseException e) {
                throw this.ensurePersistenceException(e);
            }
            finally {
                this.openDatabase(lExtentId);
            }
        }

        protected Transaction ensureTransaction(Object oToken) {
            if (oToken instanceof Transaction) {
                return (Transaction)oToken;
            }
            throw new IllegalArgumentException("illegal token: " + String.valueOf(oToken));
        }

        @Override
        protected AutoCloseable instantiateExclusiveClosable() {
            AutoCloseable parent = super.instantiateExclusiveClosable();
            return () -> {
                parent.close();
                this.maintainEnvironment();
            };
        }

        protected void maintainEnvironment(ReadBuffer bufKey, ReadBuffer bufValue) {
            if (MAINTENANCE_ENABLED) {
                this.f_cbWritten.getAndAdd(bufKey.length() + (bufValue == null ? 0 : bufValue.length()));
                if (bufValue == null) {
                    this.m_ltdLastErase = BerkeleyDBStore.getSafeTimeMillis();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void maintainEnvironment() {
            if (MAINTENANCE_ENABLED) {
                boolean fStatsRequired;
                if (this.isExclusive() || this.m_fMaintenanceScheduled) {
                    return;
                }
                long cbWritten = this.f_cbWritten.get();
                boolean fCheckpointRequired = this.m_cbLastCheckpoint >= CHECKPOINT_INTERVAL;
                boolean fCleanRequired = this.m_cbLastClean >= CLEAN_INTERVAL;
                boolean fCompressRequired = BerkeleyDBStore.getSafeTimeMillis() >= this.m_ldtLastCompress + 15000L;
                boolean bl = fStatsRequired = (long)this.f_cChecks.incrementAndGet() == 1000L || cbWritten >= STATS_CHECK_BYTES;
                if (this.m_ltdLastErase != 0L && BerkeleyDBStore.getSafeTimeMillis() > this.m_ltdLastErase + 60000L) {
                    fCheckpointRequired = true;
                    fCleanRequired = true;
                }
                if (fCheckpointRequired || fCleanRequired || fCompressRequired || fStatsRequired) {
                    BerkeleyDBStore berkeleyDBStore = this;
                    synchronized (berkeleyDBStore) {
                        if (!this.m_fMaintenanceScheduled) {
                            this.m_fMaintenanceScheduled = true;
                            BerkeleyDBManager.this.submitTask(new MaintenanceTask(fCheckpointRequired, fCleanRequired, fCompressRequired));
                        }
                    }
                }
            }
        }

        protected class MaintenanceTask
        extends AbstractPersistenceManager.Task
        implements KeyAssociation {
            protected final boolean f_fCheckpoint;
            protected final boolean f_fClean;
            protected final boolean f_fCompress;

            public MaintenanceTask(boolean fCheckpoint, boolean fClean, boolean fCompress) {
                this.f_fCheckpoint = fCheckpoint;
                this.f_fClean = fClean;
                this.f_fCompress = fCompress;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                long ldtStart = -1L;
                long ldtLastCompress = -1L;
                if (MAINTENANCE_DEBUG_ENABLED) {
                    ldtStart = MaintenanceTask.getSafeTimeMillis();
                    ldtLastCompress = BerkeleyDBStore.this.m_ldtLastCompress;
                }
                BerkeleyDBStore store = BerkeleyDBStore.this;
                store.lockRead();
                try {
                    Environment env = store.m_env;
                    if (env != null && env.isValid()) {
                        if (this.f_fClean) {
                            while (env.cleanLog() > 0) {
                            }
                        }
                        if (this.f_fCheckpoint) {
                            env.checkpoint(CHECKPOINT_CONFIG);
                        }
                        if (this.f_fCompress) {
                            env.compress();
                            store.m_ldtLastCompress = MaintenanceTask.getSafeTimeMillis();
                        }
                        long cbLog = store.getTotalLogFileSize();
                        long cbLogCheckpoint = store.m_cbLogCheckpoint;
                        long cbLogClean = store.m_cbLogClean;
                        if (this.f_fCheckpoint || cbLog < cbLogCheckpoint) {
                            store.m_cbLastCheckpoint = 0L;
                            store.m_cbLogCheckpoint = cbLog;
                        } else {
                            store.m_cbLastCheckpoint = cbLog - cbLogCheckpoint;
                        }
                        if (this.f_fClean || cbLog < cbLogClean) {
                            store.m_cbLastClean = 0L;
                            store.m_cbLogClean = cbLog;
                        } else {
                            store.m_cbLastClean = cbLog - cbLogClean;
                        }
                    }
                }
                catch (Throwable e) {
                    com.oracle.coherence.common.base.Logger.warn("Error maintaining the BerkeleyDB environment in directory " + String.valueOf(store.f_dirStore) + "\":", e);
                }
                finally {
                    this.reset();
                    store.unlockRead();
                }
                if (ldtStart != -1L && (this.f_fCheckpoint || this.f_fClean || this.f_fCompress)) {
                    com.oracle.coherence.common.base.Logger.fine("Maintenance of BDB Environment: Store=" + BerkeleyDBStore.this.getId() + ", Clean=" + this.f_fClean + ", Checkpoint=" + this.f_fCheckpoint + ", Compress=" + this.f_fCompress + " took " + (MaintenanceTask.getSafeTimeMillis() - ldtStart) + " ms" + (String)(ldtLastCompress == -1L ? "" : ", last compress=" + String.valueOf(new Date(ldtLastCompress))));
                }
            }

            @Override
            public void notifyCanceled(Throwable eCause) {
                this.reset();
            }

            @Override
            public Object getAssociatedKey() {
                return BerkeleyDBStore.this.getId();
            }

            protected void reset() {
                BerkeleyDBStore store = BerkeleyDBStore.this;
                if (this.f_fCheckpoint && this.f_fClean) {
                    store.m_ltdLastErase = 0L;
                }
                store.f_cChecks.set(0);
                store.f_cbWritten.set(0L);
                store.m_fMaintenanceScheduled = false;
            }
        }
    }
}

