/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.persistence.bdb;

import com.oracle.coherence.persistence.PersistenceException;
import com.oracle.coherence.persistence.PersistenceManager;
import com.tangosol.io.ReadBuffer;
import com.tangosol.persistence.AbstractPersistenceEnvironment;
import com.tangosol.persistence.AbstractPersistenceManager;
import com.tangosol.persistence.bdb.BerkeleyDBManager;
import java.io.File;
import java.io.IOException;

public class BerkeleyDBEnvironment
extends AbstractPersistenceEnvironment {
    public BerkeleyDBEnvironment(File fileActive, File fileSnapshot, File fileTrash) throws IOException {
        this(fileActive, fileSnapshot, fileTrash, null);
    }

    public BerkeleyDBEnvironment(File fileActive, File fileSnapshot, File fileTrash, File fileEvents) throws IOException {
        this(fileActive, null, fileEvents, fileSnapshot, fileTrash);
    }

    public BerkeleyDBEnvironment(File fileActive, File fileBackup, File fileEvents, File fileSnapshot, File fileTrash) throws IOException {
        super(fileActive, fileBackup, fileEvents, fileSnapshot, fileTrash);
    }

    @Override
    protected AbstractPersistenceManager openActiveInternal() {
        try {
            return new BerkeleyDBManager(this.getPersistenceActiveDirectory(), this.getPersistenceTrashDirectory(), null);
        }
        catch (IOException e) {
            throw this.ensurePersistenceException(e);
        }
    }

    @Override
    protected AbstractPersistenceManager openBackupInternal() {
        try {
            return new BerkeleyDBManager(this.getPersistenceBackupDirectory(), this.getPersistenceTrashDirectory(), null);
        }
        catch (IOException e) {
            throw this.ensurePersistenceException(e);
        }
    }

    @Override
    protected AbstractPersistenceManager openEventsInternal() {
        try {
            return new BerkeleyDBManager(this.getPersistenceEventsDirectory(), this.getPersistenceTrashDirectory(), null);
        }
        catch (IOException e) {
            throw this.ensurePersistenceException(e);
        }
    }

    @Override
    protected AbstractPersistenceManager openSnapshotInternal(File fileSnapshot, String sSnapshot) {
        try {
            return new BerkeleyDBManager(fileSnapshot, null, sSnapshot);
        }
        catch (IOException e) {
            throw this.ensurePersistenceException(e);
        }
    }

    @Override
    protected AbstractPersistenceManager createSnapshotInternal(File fileSnapshot, String sSnapshot, PersistenceManager<ReadBuffer> manager) {
        if (manager != null && !(manager instanceof BerkeleyDBManager)) {
            throw new IllegalArgumentException("incompatible persistence manager type: " + String.valueOf(manager.getClass()));
        }
        BerkeleyDBManager snapshot = (BerkeleyDBManager)this.openSnapshotInternal(fileSnapshot, sSnapshot);
        if (manager instanceof BerkeleyDBManager) {
            try {
                ((BerkeleyDBManager)manager).createSnapshot(fileSnapshot);
            }
            catch (PersistenceException e) {
                snapshot.release();
                throw e;
            }
        }
        return snapshot;
    }
}

