/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.persistence;

import com.oracle.coherence.common.base.Collector;
import com.oracle.coherence.common.base.Continuation;
import com.oracle.coherence.persistence.PersistenceEnvironment;
import com.oracle.coherence.persistence.PersistenceManager;
import com.oracle.coherence.persistence.PersistentStore;
import com.oracle.coherence.persistence.PersistentStoreInfo;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.util.NullImplementation;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SafePersistenceWrappers {
    public static final FailureContinuationFactory DEFAULT_FACTORY = new FailureContinuationFactory(){

        public Continuation getEnvironmentContinuation(PersistenceEnvironment env) {
            return NullImplementation.getContinuation();
        }

        public Continuation getManagerContinuation(PersistenceManager mgr) {
            return NullImplementation.getContinuation();
        }

        public Continuation getStoreContinuation(PersistentStore store) {
            return NullImplementation.getContinuation();
        }
    };

    public static <R> PersistenceEnvironment<R> unwrap(PersistenceEnvironment<R> env) {
        while (env instanceof SafePersistenceEnvironment) {
            env = ((SafePersistenceEnvironment)env).getEnvironment();
        }
        return env;
    }

    public static <R> PersistenceManager<R> unwrap(PersistenceManager<R> mgr) {
        while (mgr instanceof SafePersistenceManager) {
            mgr = ((SafePersistenceManager)mgr).getManager();
        }
        return mgr;
    }

    public static <R> PersistentStore<R> unwrap(PersistentStore<R> store) {
        while (store instanceof SafePersistentStore) {
            store = ((SafePersistentStore)store).getStore();
        }
        return store;
    }

    protected static <R, T extends Throwable> FailureContinuationFactory<R, T> getSimpleFactory(final Continuation<? super T> cont) {
        return new FailureContinuationFactory<R, T>(){

            @Override
            public Continuation<? super T> getEnvironmentContinuation(PersistenceEnvironment<R> env) {
                return cont;
            }

            @Override
            public Continuation<? super T> getManagerContinuation(PersistenceManager<R> mgr) {
                return cont;
            }

            @Override
            public Continuation<? super T> getStoreContinuation(PersistentStore<R> store) {
                return cont;
            }
        };
    }

    public static class SafePersistenceEnvironment<R, T extends Throwable>
    extends NullImplementation.NullPersistenceEnvironment<R> {
        protected final PersistenceEnvironment<R> f_env;
        protected final Continuation<? super T> f_contFailure;
        protected final FailureContinuationFactory<R, ? super T> f_factoryCont;

        public SafePersistenceEnvironment(PersistenceEnvironment<R> env) {
            this(env, DEFAULT_FACTORY);
        }

        public SafePersistenceEnvironment(PersistenceEnvironment<R> env, Continuation<? super Throwable> cont) {
            this(env, SafePersistenceWrappers.getSimpleFactory(cont));
        }

        public SafePersistenceEnvironment(PersistenceEnvironment<R> env, FailureContinuationFactory<R, ? super T> factory) {
            this.f_env = env;
            this.f_factoryCont = factory;
            this.f_contFailure = factory.getEnvironmentContinuation(env);
        }

        public PersistenceEnvironment<R> getEnvironment() {
            return this.f_env;
        }

        protected void onException(T t) {
            this.f_contFailure.proceed(t);
        }

        protected PersistenceManager wrap(PersistenceManager<R> mgr) {
            return mgr == null ? null : new SafePersistenceManager<R, T>(mgr, this.f_factoryCont);
        }

        @Override
        public PersistenceManager<R> openBackup() {
            try {
                return this.wrap(this.getEnvironment().openBackup());
            }
            catch (Throwable t) {
                this.onException(t);
                return NullImplementation.getPersistenceManager();
            }
        }

        @Override
        public PersistenceManager<R> openEvents() {
            try {
                return this.wrap(this.getEnvironment().openEvents());
            }
            catch (Throwable t) {
                this.onException(t);
                return NullImplementation.getPersistenceManager();
            }
        }

        @Override
        public PersistenceManager<R> openActive() {
            try {
                return this.wrap(this.getEnvironment().openActive());
            }
            catch (Throwable t) {
                this.onException(t);
                return NullImplementation.getPersistenceManager();
            }
        }

        @Override
        public PersistenceManager<R> openSnapshot(String sSnapshot) {
            try {
                return this.wrap(this.getEnvironment().openSnapshot(sSnapshot));
            }
            catch (Throwable t) {
                this.onException(t);
                return NullImplementation.getPersistenceManager();
            }
        }

        @Override
        public PersistenceManager<R> createSnapshot(String sSnapshot, PersistenceManager<R> manager) {
            try {
                return this.wrap(this.getEnvironment().createSnapshot(sSnapshot, SafePersistenceWrappers.unwrap(manager)));
            }
            catch (Throwable t) {
                this.onException(t);
                return NullImplementation.getPersistenceManager();
            }
        }

        @Override
        public boolean removeSnapshot(String sSnapshot) {
            try {
                return this.getEnvironment().removeSnapshot(sSnapshot);
            }
            catch (Throwable t) {
                this.onException(t);
                return super.removeSnapshot(sSnapshot);
            }
        }

        @Override
        public String[] listSnapshots() {
            try {
                return this.getEnvironment().listSnapshots();
            }
            catch (Throwable t) {
                this.onException(t);
                return super.listSnapshots();
            }
        }

        @Override
        public void release() {
            try {
                this.getEnvironment().release();
            }
            catch (Throwable t) {
                this.onException(t);
            }
        }

        public String toString() {
            return "Safe" + String.valueOf(this.getEnvironment());
        }
    }

    public static class SafePersistenceManager<R, T extends Throwable>
    extends NullImplementation.NullPersistenceManager<R> {
        protected final PersistenceManager<R> f_manager;
        protected final Continuation<? super T> f_contFailure;
        protected final FailureContinuationFactory<R, ? super T> f_factoryCont;

        public SafePersistenceManager(PersistenceManager<R> mgr) {
            this(mgr, DEFAULT_FACTORY);
        }

        public SafePersistenceManager(PersistenceManager<R> mgr, Continuation<? super Throwable> cont) {
            this(mgr, SafePersistenceWrappers.getSimpleFactory(cont));
        }

        public SafePersistenceManager(PersistenceManager<R> mgr, FailureContinuationFactory<R, ? super T> factory) {
            this.f_manager = mgr;
            this.f_factoryCont = factory;
            this.f_contFailure = factory.getManagerContinuation(mgr);
        }

        public PersistenceManager getManager() {
            return this.f_manager;
        }

        public void onException(T t) {
            this.f_contFailure.proceed(t);
        }

        protected PersistentStore<R> wrap(PersistentStore<R> store) {
            return store == null ? null : new SafePersistentStore<R, T>(store, this.f_factoryCont);
        }

        @Override
        public String getName() {
            try {
                return this.getManager().getName();
            }
            catch (Throwable t) {
                this.onException(t);
                return super.getName();
            }
        }

        @Override
        public PersistentStore<R> createStore(String sId) {
            try {
                return this.wrap(this.getManager().createStore(sId));
            }
            catch (Throwable t) {
                this.onException(t);
                return null;
            }
        }

        @Override
        public PersistentStore<R> open(String sId, PersistentStore<R> store) {
            try {
                return this.wrap(this.getManager().open(sId, store));
            }
            catch (Throwable t) {
                this.onException(t);
                return super.open(sId, store);
            }
        }

        @Override
        public PersistentStore<R> open(String sId, PersistentStore<R> store, Collector<Object> collector) {
            try {
                return this.wrap(this.getManager().open(sId, store, collector));
            }
            catch (Throwable t) {
                this.onException(t);
                return super.open(sId, store);
            }
        }

        @Override
        public void close(String sId) {
            try {
                this.getManager().close(sId);
            }
            catch (Throwable t) {
                this.onException(t);
            }
        }

        @Override
        public boolean delete(String sId, boolean fSafe) {
            try {
                return this.getManager().delete(sId, fSafe);
            }
            catch (Throwable t) {
                this.onException(t);
                return super.delete(sId, fSafe);
            }
        }

        @Override
        public PersistentStoreInfo[] listStoreInfo() {
            try {
                return this.getManager().listStoreInfo();
            }
            catch (Throwable t) {
                this.onException(t);
                return super.listStoreInfo();
            }
        }

        @Override
        public String[] listOpen() {
            try {
                return this.getManager().listOpen();
            }
            catch (Throwable t) {
                this.onException(t);
                return super.listOpen();
            }
        }

        @Override
        public boolean isEmpty(String sId) {
            try {
                return this.getManager().isEmpty(sId);
            }
            catch (Throwable t) {
                this.onException(t);
                return super.isEmpty(sId);
            }
        }

        @Override
        public void read(String sId, InputStream in) throws IOException {
            try {
                this.getManager().read(sId, in);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Throwable t) {
                this.onException(t);
            }
        }

        @Override
        public void write(String sId, OutputStream out) throws IOException {
            try {
                this.getManager().write(sId, out);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Throwable t) {
                this.onException(t);
            }
        }

        @Override
        public void writeSafe(String sId) {
            try {
                this.getManager().writeSafe(sId);
            }
            catch (Throwable t) {
                this.onException(t);
            }
        }

        @Override
        public void read(String sId, ReadBuffer.BufferInput in) throws IOException {
            try {
                this.getManager().read(sId, in);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Throwable t) {
                this.onException(t);
            }
        }

        @Override
        public void write(String sId, WriteBuffer.BufferOutput out) throws IOException {
            try {
                this.getManager().write(sId, out);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Throwable t) {
                this.onException(t);
            }
        }

        @Override
        public void release() {
            try {
                this.getManager().release();
            }
            catch (Throwable t) {
                this.onException(t);
            }
        }

        @Override
        public void maintainEnvironment() {
            try {
                this.getManager().maintainEnvironment();
            }
            catch (Throwable t) {
                this.onException(t);
            }
        }

        public String toString() {
            return "Safe" + String.valueOf(this.getManager());
        }
    }

    public static class SafePersistentStore<R, T extends Throwable>
    extends NullImplementation.NullPersistentStore<R> {
        protected final PersistentStore<R> f_store;
        protected final Continuation<? super T> f_contFailure;

        public SafePersistentStore(PersistentStore<R> store) {
            this(store, DEFAULT_FACTORY);
        }

        public SafePersistentStore(PersistentStore<R> store, Continuation<? super T> cont) {
            this(store, SafePersistenceWrappers.getSimpleFactory(cont));
        }

        public SafePersistentStore(PersistentStore<R> store, FailureContinuationFactory<R, ? super T> factory) {
            this.f_store = store;
            this.f_contFailure = factory.getStoreContinuation(store);
        }

        public PersistentStore<R> getStore() {
            return this.f_store;
        }

        public void onException(T t) {
            this.f_contFailure.proceed(t);
        }

        @Override
        public String getId() {
            try {
                return this.getStore().getId();
            }
            catch (Throwable t) {
                this.onException(t);
                return super.getId();
            }
        }

        @Override
        public boolean ensureExtent(long lExtentId) {
            try {
                return this.getStore().ensureExtent(lExtentId);
            }
            catch (Throwable t) {
                this.onException(t);
                return super.ensureExtent(lExtentId);
            }
        }

        @Override
        public void deleteExtent(long lExtentId) {
            try {
                this.getStore().deleteExtent(lExtentId);
            }
            catch (Throwable t) {
                this.onException(t);
            }
        }

        @Override
        public void moveExtent(long lOldExtentId, long lNewExtentId) {
            try {
                this.getStore().moveExtent(lOldExtentId, lNewExtentId);
            }
            catch (Throwable t) {
                this.onException(t);
            }
        }

        @Override
        public void truncateExtent(long lExtentId) {
            try {
                this.getStore().truncateExtent(lExtentId);
            }
            catch (Throwable t) {
                this.onException(t);
            }
        }

        @Override
        public long[] extents() {
            try {
                return this.getStore().extents();
            }
            catch (Throwable t) {
                this.onException(t);
                return super.extents();
            }
        }

        @Override
        public AutoCloseable exclusively() {
            try {
                return this.getStore().exclusively();
            }
            catch (Throwable t) {
                this.onException(t);
                return super.exclusively();
            }
        }

        @Override
        public R load(long lExtentId, R key) {
            try {
                return this.getStore().load(lExtentId, key);
            }
            catch (Throwable t) {
                this.onException(t);
                return super.load(lExtentId, key);
            }
        }

        @Override
        public boolean containsExtent(long lExtentId) {
            try {
                return this.getStore().containsExtent(lExtentId);
            }
            catch (Throwable t) {
                this.onException(t);
                return super.containsExtent(lExtentId);
            }
        }

        @Override
        public void store(long lExtentId, R key, R value, Object oToken) {
            if (oToken instanceof NullImplementation.NullPersistentStore.Token) {
                super.store(lExtentId, key, value, oToken);
            } else {
                try {
                    this.getStore().store(lExtentId, key, value, oToken);
                }
                catch (Throwable t) {
                    this.onException(t);
                }
            }
        }

        @Override
        public void erase(long lExtentId, R key, Object oToken) {
            if (oToken instanceof NullImplementation.NullPersistentStore.Token) {
                super.erase(lExtentId, key, oToken);
            } else {
                try {
                    this.getStore().erase(lExtentId, key, oToken);
                }
                catch (Throwable t) {
                    this.onException(t);
                }
            }
        }

        @Override
        public void iterate(PersistentStore.Visitor<R> visitor) {
            try {
                this.getStore().iterate(visitor);
            }
            catch (Throwable t) {
                this.onException(t);
            }
        }

        @Override
        public Object begin() {
            try {
                return this.getStore().begin();
            }
            catch (Throwable t) {
                this.onException(t);
                return super.begin();
            }
        }

        @Override
        public Object begin(Collector<Object> collector, Object oReceipt) {
            try {
                return this.getStore().begin(collector, oReceipt);
            }
            catch (Throwable t) {
                this.onException(t);
                return super.begin(collector, oReceipt);
            }
        }

        @Override
        public void commit(Object oToken) {
            if (oToken instanceof NullImplementation.NullPersistentStore.Token) {
                super.commit(oToken);
            } else {
                try {
                    this.getStore().commit(oToken);
                }
                catch (Throwable t) {
                    this.onException(t);
                }
            }
        }

        @Override
        public void abort(Object oToken) {
            if (oToken instanceof NullImplementation.NullPersistentStore.Token) {
                super.abort(oToken);
            } else {
                try {
                    this.getStore().abort(oToken);
                }
                catch (Throwable t) {
                    this.onException(t);
                }
            }
        }

        @Override
        public boolean isOpen() {
            try {
                return this.getStore().isOpen();
            }
            catch (Throwable t) {
                this.onException(t);
                return false;
            }
        }

        public String toString() {
            return "Safe" + String.valueOf(this.getStore());
        }
    }

    public static interface FailureContinuationFactory<R, T extends Throwable> {
        public Continuation<? super T> getEnvironmentContinuation(PersistenceEnvironment<R> var1);

        public Continuation<? super T> getManagerContinuation(PersistenceManager<R> var1);

        public Continuation<? super T> getStoreContinuation(PersistentStore<R> var1);
    }
}

