/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.persistence;

import com.tangosol.net.management.annotation.Description;
import com.tangosol.net.management.annotation.Notification;

@Notification(description="PersistenceManager notifications.", types={"create.snapshot.begin", "create.snapshot.end", "recover.snapshot.begin", "recover.snapshot.end", "remove.snapshot.begin", "remove.snapshot.end", "archive.snapshot.begin", "archive.snapshot.end", "retrieve.archived.snapshot.begin", "retrieve.archived.snapshot.end", "remove.archived.snapshot.begin", "remove.archived.snapshot.end", "recover.begin", "recover.end", "recover.disallowed"})
public interface PersistenceManagerMBean {
    public static final String PERSISTENCE_COORDINATOR = "PersistenceCoordinator";
    public static final String CREATE_SNAPSHOT_BEGIN = "create.snapshot.begin";
    public static final String CREATE_SNAPSHOT_END = "create.snapshot.end";
    public static final String RECOVER_SNAPSHOT_BEGIN = "recover.snapshot.begin";
    public static final String RECOVER_SNAPSHOT_END = "recover.snapshot.end";
    public static final String REMOVE_SNAPSHOT_BEGIN = "remove.snapshot.begin";
    public static final String REMOVE_SNAPSHOT_END = "remove.snapshot.end";
    public static final String ARCHIVE_SNAPSHOT_BEGIN = "archive.snapshot.begin";
    public static final String ARCHIVE_SNAPSHOT_END = "archive.snapshot.end";
    public static final String RETRIEVE_ARCHIVED_SNAPSHOT_BEGIN = "retrieve.archived.snapshot.begin";
    public static final String RETRIEVE_ARCHIVED_SNAPSHOT_END = "retrieve.archived.snapshot.end";
    public static final String REMOVE_ARCHIVED_SNAPSHOT_BEGIN = "remove.archived.snapshot.begin";
    public static final String REMOVE_ARCHIVED_SNAPSHOT_END = "remove.archived.snapshot.end";
    public static final String RECOVER_BEGIN = "recover.begin";
    public static final String RECOVER_END = "recover.end";
    public static final String RECOVER_DISALLOWED = "recover.disallowed";

    @Description(value="The member id of the service node that is the persistence coordinator.")
    public int getCoordinatorId();

    @Description(value="The status of the current operation issued by the persistence coordinator.")
    public String getOperationStatus();

    @Description(value="Specifies whether or not the persistence coordinator is idle.")
    public boolean isIdle();

    @Description(value="The list of snapshot identifiers that are available to recover from.")
    public String[] getSnapshots();

    @Description(value="Asynchronously create a snapshot of the service with the specified name. Subscribe to JMX notifications to see the status of the operation.")
    public void createSnapshot(@Description(value="sName") String var1);

    @Description(value="Asynchronously recover the entire service from a snapshot with the specified name. Subscribe to JMX notifications to see the status of the operation.")
    public void recoverSnapshot(@Description(value="sName") String var1);

    @Description(value="Asynchronously remove the snapshot of the service with the specified name. Subscribe to JMX notifications to see the status of the operation.")
    public void removeSnapshot(@Description(value="sName") String var1);

    @Description(value="Asynchronously archive the snapshot to a centralized location. Subscribe to JMX notifications to see the status of the operation.")
    public void archiveSnapshot(@Description(value="sName") String var1);

    @Description(value="Asynchronously retrieve the archived snapshot from a centralized location. Subscribe to JMX notifications to see the status of the operation.")
    public void retrieveArchivedSnapshot(@Description(value="sName") String var1);

    @Description(value="Remove the archived snapshot from a centralized location.")
    public void removeArchivedSnapshot(@Description(value="sName") String var1);

    @Description(value="Proceed with recovery despite the dynamic quorum policy objections. This may lead to the partial or full data loss of the corresponding cache service.")
    public void forceRecovery();

    @Description(value="Return a list of archived snapshots for the service.")
    public String[] listArchivedSnapshots();

    @Description(value="Return a list of stores for the archived snapshot with the specified name.")
    public String[] listArchivedSnapshotStores(@Description(value="sName") String var1);
}

