/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.persistence;

import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.persistence.PersistentStoreInfo;
import com.tangosol.net.Member;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.util.Base;
import com.tangosol.util.ConverterCollections;
import com.tangosol.util.ImmutableMultiList;
import com.tangosol.util.NullImplementation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class GUIDHelper {
    public static String generateGUID(int nPartition, long lVersion, long ldt, Member member) {
        return String.format("%d-%x-%x-%d", nPartition, lVersion, ldt, member.getId());
    }

    public static boolean validateGUID(String sGUID) {
        return sGUID != null && sGUID.matches("\\d+-[0-9a-f]+-[0-9a-f]+-\\d+");
    }

    public static int getPartition(String sGUID) {
        return Integer.parseInt(GUIDHelper.parseAttribute(sGUID, 0));
    }

    public static long getVersion(String sGUID) {
        return Long.parseLong(GUIDHelper.parseAttribute(sGUID, 1), 16);
    }

    public static long getServiceJoinTime(String sGUID) {
        return Long.parseLong(GUIDHelper.parseAttribute(sGUID, 2), 16);
    }

    public static int getMemberId(String sGUID) {
        return Integer.parseInt(GUIDHelper.parseAttribute(sGUID, 3));
    }

    public static String getGUID(List<PersistentStoreInfo> listInfo, int nPartition) {
        for (PersistentStoreInfo p : listInfo) {
            String s = p.getId();
            if (GUIDHelper.getPartition(s) != nPartition) continue;
            return s;
        }
        return null;
    }

    public static Map<Integer, String[]> assignStores(Map<Integer, Object[]> mapConstraints, int cDistinctStores) {
        if (mapConstraints == null || mapConstraints.size() == 0) {
            throw new IllegalArgumentException("Unexpected empty map of member to persistent stores");
        }
        HashMap<List<Object>, Integer[]> mapGUIDMembers = new HashMap<List<Object>, Integer[]>();
        HashSet<String> setSharedGUIDs = new HashSet<String>();
        HashSet<String> setAssignedGUIDs = new HashSet<String>();
        Map.Entry<Integer, Object[]>[] aEntry = GUIDHelper.createSortedEntries(mapConstraints);
        int c = aEntry.length;
        for (int i = 0; i < c; ++i) {
            List[] NMemberCurrent = aEntry[i].getKey();
            Object[] aoGUIDs = aEntry[i].getValue();
            List<Object> listGUIDs2 = Arrays.asList(aoGUIDs);
            if (mapGUIDMembers.containsKey(listGUIDs2)) continue;
            ArrayList<Object> listMembers = new ArrayList<Object>();
            listMembers.add(NMemberCurrent);
            for (int j = i + 1; j < c; ++j) {
                int cIntersection;
                Object[] aoGUIDThat = aEntry[j].getValue();
                List<String> listIntersection = GUIDHelper.intersects(aoGUIDs, aoGUIDThat);
                int n = cIntersection = listIntersection == null ? 0 : listIntersection.size();
                if (cIntersection == aoGUIDs.length && cIntersection == aoGUIDThat.length) {
                    listMembers.add(aEntry[j].getKey());
                    if (j != i + 1) continue;
                    ++i;
                    continue;
                }
                if (cIntersection <= 0) continue;
                setSharedGUIDs.addAll(listIntersection);
            }
            mapGUIDMembers.put(listGUIDs2, listMembers.toArray(new Integer[listMembers.size()]));
        }
        List[] alistGUIDs = mapGUIDMembers.keySet().toArray(new List[mapGUIDMembers.size()]);
        Arrays.sort(alistGUIDs, (listThis, listThat) -> listThis.size() - listThat.size());
        HashMap<Integer, List> mapMemberGUID = new HashMap<Integer, List>();
        for (List listGUIDs3 : alistGUIDs) {
            Integer[] aNMembers = (Integer[])mapGUIDMembers.get(listGUIDs3);
            int c2 = listGUIDs3.size();
            int cMembers = aNMembers.length;
            for (int i = 0; i < c2; ++i) {
                String sGUID = (String)listGUIDs3.get(i);
                if (setSharedGUIDs.contains(sGUID) && setAssignedGUIDs.contains(sGUID)) continue;
                Integer NMember = aNMembers[i % cMembers];
                mapMemberGUID.computeIfAbsent(NMember, key -> new ArrayList());
                ((List)mapMemberGUID.get(NMember)).add(sGUID);
                boolean fAdded = setAssignedGUIDs.add(sGUID);
                assert (fAdded) : sGUID + " was assigned twice; 2nd assignment to member " + NMember;
            }
        }
        if (setAssignedGUIDs.size() != cDistinctStores) {
            HashSet setDistinctStores = new HashSet(setAssignedGUIDs.size());
            String sMsg = "Unexpected number of distinct stores; expected " + cDistinctStores + " but found " + setAssignedGUIDs.size();
            StringBuilder sb = new StringBuilder("[");
            mapConstraints.forEach((NMemberId, aoStore) -> {
                sb.append(NMemberId).append("->").append(Arrays.toString(aoStore));
                setDistinctStores.addAll(Arrays.asList(aoStore));
            });
            sb.append(']');
            if (setDistinctStores.size() != setAssignedGUIDs.size()) {
                Logger.err("Unexpected number of distinct stores\nassigned: " + String.valueOf(setAssignedGUIDs) + "\npassed: " + sb.toString());
                throw new IllegalStateException(sMsg);
            }
            throw new IllegalArgumentException(sMsg);
        }
        return ConverterCollections.getMap(mapMemberGUID, NullImplementation.getConverter(), NullImplementation.getConverter(), listGUIDs -> listGUIDs == null ? null : listGUIDs.toArray(new String[listGUIDs.size()]), NullImplementation.getConverter());
    }

    public static PartitionSet getPartitions(Map<Integer, Object[]> mapStores, int cParts) {
        PartitionSet parts = new PartitionSet(cParts);
        for (Object[] aoStore : mapStores.values()) {
            for (Object oStore : aoStore) {
                PersistentStoreInfo info = (PersistentStoreInfo)oStore;
                parts.add(GUIDHelper.getPartition(info.getId()));
            }
        }
        return parts;
    }

    protected static String parseAttribute(String sGUID, int id) {
        StringTokenizer tokenizer = new StringTokenizer(sGUID, "-");
        for (int i = 0; i < id; ++i) {
            tokenizer.nextToken();
        }
        return tokenizer.nextToken();
    }

    protected static List<String> intersects(Object[] aoLHS, Object[] aoRHS) {
        assert (aoLHS != null && aoRHS != null);
        if (((String)aoLHS[aoLHS.length - 1]).compareTo((String)aoRHS[0]) < 0 || ((String)aoRHS[aoRHS.length - 1]).compareTo((String)aoLHS[0]) < 0) {
            return null;
        }
        ArrayList<String> listIntersect = null;
        int nCompare = aoLHS.length - aoRHS.length;
        Object[] aoLarger = nCompare == 0 || nCompare < 0 ? aoRHS : aoLHS;
        Object[] aoSmaller = nCompare == 0 || nCompare < 0 ? aoLHS : aoRHS;
        int i = 0;
        int j = 0;
        int cMax = aoLarger.length;
        int cMin = aoSmaller.length;
        while (i < cMax) {
            int n = nCompare = j < cMin ? ((Comparable)aoLarger[i]).compareTo(aoSmaller[j]) : -1;
            if (nCompare == 0) {
                if (listIntersect != null) {
                    listIntersect.add((String)aoLarger[i]);
                }
            } else if (listIntersect == null) {
                listIntersect = new ArrayList<String>();
                if (i > 0) {
                    listIntersect.addAll(Arrays.asList(Arrays.copyOfRange(aoLarger, 0, i)));
                }
            }
            if (nCompare <= 0) {
                ++i;
            }
            if (nCompare < 0) continue;
            ++j;
        }
        return listIntersect == null ? Arrays.asList(aoLHS) : (listIntersect.isEmpty() ? null : listIntersect);
    }

    protected static <K> Map.Entry<K, Object[]>[] createSortedEntries(Map<K, Object[]> map) {
        Map.Entry[] aEntry = new Map.Entry[map.size()];
        int i = 0;
        int cArray = aEntry.length;
        for (Map.Entry<K, Object[]> entry : map.entrySet()) {
            Arrays.sort(entry.getValue());
            if (i >= cArray) {
                Map.Entry[] aOld = aEntry;
                aEntry = new Map.Entry[cArray + (cArray >> 3)];
                System.arraycopy(aOld, 0, aEntry, 0, cArray);
                cArray = aEntry.length;
            }
            aEntry[i++] = entry;
        }
        if (i < cArray) {
            Map.Entry[] aOld = aEntry;
            aEntry = new Map.Entry[i];
            System.arraycopy(aOld, 0, aEntry, 0, i);
        }
        return aEntry;
    }

    public static Map<Integer, String[]> getMapGuids(Map<Integer, Object[]> mapStoreInfo) {
        HashMap<Integer, String[]> mapGUID = new HashMap<Integer, String[]>();
        ArrayList<String> listGUID = new ArrayList<String>();
        for (Map.Entry<Integer, Object[]> entry : mapStoreInfo.entrySet()) {
            Object[] aOInfo;
            for (Object oInfo : aOInfo = entry.getValue()) {
                listGUID.add(((PersistentStoreInfo)oInfo).getId());
            }
            mapGUID.put(entry.getKey(), listGUID.toArray(new String[listGUID.size()]));
            listGUID.clear();
        }
        return mapGUID;
    }

    public static void main(String[] asArg) {
        if (asArg.length > 0) {
            String sGUID = asArg[0];
            Base.out("Partition:  " + GUIDHelper.getPartition(sGUID));
            Base.out("Version:    " + GUIDHelper.getVersion(sGUID));
            Base.out("Timestamp:  " + String.valueOf(new Date(GUIDHelper.getServiceJoinTime(sGUID))));
            Base.out("Member ID:  " + GUIDHelper.getMemberId(sGUID));
        } else {
            Base.out("Usage: com.tangosol.persistence.GUIDHelper <GUID>");
        }
    }

    public static class GUIDResolver
    extends Base {
        protected final Map<Member, PersistentStoreInfo[]> f_mapStoreInfo;
        protected int m_cPartitions;
        protected PersistentStoreInfo[] m_aStoreNewest;
        protected Map<Member, List<String>> m_mapCleanup;
        protected Map<Member, PartitionSet> m_mapResolved;
        protected PartitionSet m_partsUnresolved;
        protected boolean m_fSharedStorage;

        public GUIDResolver(int cPartitions) {
            this.m_cPartitions = cPartitions;
            this.f_mapStoreInfo = new HashMap<Member, PersistentStoreInfo[]>();
        }

        public void registerStoreInfo(Member member, PersistentStoreInfo[] aInfo) {
            this.f_mapStoreInfo.put(member, aInfo);
            this.m_mapResolved = null;
        }

        public String getNewestGUID(int nPartition) {
            this.resolve();
            return this.m_aStoreNewest[nPartition].getId();
        }

        public String[] getNewestGUIDs(PartitionSet parts) {
            this.resolve();
            int cPartitions = parts.cardinality();
            PersistentStoreInfo[] aStoreNewest = this.m_aStoreNewest;
            String[] asGUIDResult = new String[cPartitions];
            int cResults = 0;
            int iPart = parts.next(0);
            while (iPart >= 0) {
                PersistentStoreInfo info = aStoreNewest[iPart];
                if (info != null) {
                    asGUIDResult[cResults++] = info.getId();
                }
                iPart = parts.next(iPart + 1);
            }
            if (cResults < cPartitions) {
                String[] asNew = new String[cResults];
                System.arraycopy(asGUIDResult, 0, asNew, 0, cResults);
                asGUIDResult = asNew;
            }
            return asGUIDResult;
        }

        public PersistentStoreInfo[] getNewestStoreInfos(PartitionSet parts) {
            this.resolve();
            int cPartitions = parts.cardinality();
            PersistentStoreInfo[] asStoreNewest = this.m_aStoreNewest;
            PersistentStoreInfo[] asStoreResult = new PersistentStoreInfo[cPartitions];
            int cResults = 0;
            int iPart = parts.next(0);
            while (iPart >= 0) {
                PersistentStoreInfo info = asStoreNewest[iPart];
                if (info != null) {
                    asStoreResult[cResults++] = info;
                }
                iPart = parts.next(iPart + 1);
            }
            if (cResults < cPartitions) {
                PersistentStoreInfo[] aNew = new PersistentStoreInfo[cResults];
                System.arraycopy(asStoreResult, 0, aNew, 0, cResults);
                asStoreResult = aNew;
            }
            return asStoreResult;
        }

        public PartitionSet getUnresolvedPartitions() {
            this.resolve();
            return this.m_partsUnresolved;
        }

        public Map<Member, List<String>> getInvalidGUIDs() {
            this.resolve();
            return this.m_mapCleanup;
        }

        public Map<Integer, PersistentStoreInfo[]> getMemberStoreInfo() {
            return ConverterCollections.getMap(this.f_mapStoreInfo, Member::getId, NullImplementation.getConverter(), NullImplementation.getConverter(), NullImplementation.getConverter());
        }

        public boolean isSharedStorage() {
            this.resolve();
            return this.m_fSharedStorage;
        }

        public Map<Member, PartitionSet> resolve() {
            boolean bl;
            Map<Member, PartitionSet> mapResolved = this.m_mapResolved;
            if (mapResolved != null) {
                return mapResolved;
            }
            int cPartitions = this.m_cPartitions;
            PartitionSet partsResolved = new PartitionSet(cPartitions);
            ArrayList<String> listDelete = new ArrayList<String>();
            HashSet<String> setPrevGUIDs = new HashSet<String>();
            PersistentStoreInfo[] aStoreNewest = new PersistentStoreInfo[cPartitions];
            HashMap<Member, PartitionSet> mapOwnershipRecover = new HashMap<Member, PartitionSet>();
            ImmutableMultiList colStoreInfo = new ImmutableMultiList(this.f_mapStoreInfo.values());
            for (PersistentStoreInfo persistentStoreInfo : colStoreInfo) {
                String sGUID = persistentStoreInfo.getId();
                int iPartition = GUIDHelper.getPartition(sGUID);
                if (iPartition >= cPartitions) {
                    setPrevGUIDs.add(sGUID);
                    continue;
                }
                PersistentStoreInfo infoLatest = aStoreNewest[iPartition];
                if (infoLatest == null) {
                    infoLatest = persistentStoreInfo;
                } else if (infoLatest.isEmpty() ^ persistentStoreInfo.isEmpty()) {
                    listDelete.add((persistentStoreInfo.isEmpty() ? persistentStoreInfo : infoLatest).getId());
                    infoLatest = persistentStoreInfo.isEmpty() ? infoLatest : persistentStoreInfo;
                } else if (GUIDHelper.getVersion(persistentStoreInfo.getId()) > GUIDHelper.getVersion(infoLatest.getId())) {
                    setPrevGUIDs.add(infoLatest.getId());
                    infoLatest = persistentStoreInfo;
                } else if (GUIDHelper.getVersion(persistentStoreInfo.getId()) < GUIDHelper.getVersion(infoLatest.getId())) {
                    setPrevGUIDs.add(persistentStoreInfo.getId());
                }
                aStoreNewest[iPartition] = infoLatest;
            }
            for (Map.Entry entry : this.f_mapStoreInfo.entrySet()) {
                Member member = (Member)entry.getKey();
                PersistentStoreInfo[] aStoreInfo = (PersistentStoreInfo[])entry.getValue();
                PartitionSet parts = new PartitionSet(cPartitions);
                for (PersistentStoreInfo storeInfo : aStoreInfo) {
                    if (setPrevGUIDs.contains(storeInfo.getId())) continue;
                    parts.add(GUIDHelper.getPartition(storeInfo.getId()));
                }
                mapOwnershipRecover.put(member, parts);
                partsResolved.add(parts);
            }
            HashMap<Member, List<String>> mapOwnershipCleanup = new HashMap<Member, List<String>>();
            for (String sGUID : listDelete) {
                block4: for (Map.Entry<Member, PersistentStoreInfo[]> entry : this.f_mapStoreInfo.entrySet()) {
                    PersistentStoreInfo[] aInfoThis = entry.getValue();
                    int c = aInfoThis.length;
                    for (int i = 0; i < c; ++i) {
                        if (!GUIDResolver.equals(sGUID, aInfoThis[i].getId())) continue;
                        Member member = entry.getKey();
                        ArrayList<String> list = (ArrayList<String>)mapOwnershipCleanup.get(member);
                        if (list == null) {
                            list = new ArrayList<String>();
                            mapOwnershipCleanup.put(member, list);
                        }
                        list.add(sGUID);
                        continue block4;
                    }
                }
            }
            boolean bl2 = true;
            for (PartitionSet partsMember : mapOwnershipRecover.values()) {
                if (partsMember.equals(partsResolved)) continue;
                bl = false;
                break;
            }
            this.m_mapResolved = mapOwnershipRecover;
            this.m_partsUnresolved = partsResolved.invert();
            this.m_aStoreNewest = aStoreNewest;
            this.m_fSharedStorage = bl;
            this.m_mapCleanup = mapOwnershipCleanup;
            return mapOwnershipRecover;
        }
    }
}

