/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.persistence;

import com.tangosol.io.FileHelper;
import com.tangosol.persistence.DirectorySnapshotArchiver;
import com.tangosol.persistence.SnapshotArchiver;
import com.tangosol.persistence.SnapshotArchiverFactory;
import com.tangosol.run.xml.XmlConfigurable;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import java.io.File;

public class ConfigurableSnapshotArchiverFactory
implements SnapshotArchiverFactory,
XmlConfigurable {
    private XmlElement m_xmlConfig;

    @Override
    public SnapshotArchiver createSnapshotArchiver(String sClusterName, String sServiceName) {
        if (sClusterName == null || (sClusterName = sClusterName.trim()).length() == 0) {
            throw new IllegalArgumentException("invalid cluster name");
        }
        final String sCluster = FileHelper.toFilename(sClusterName);
        if (sServiceName == null || (sServiceName = sServiceName.trim()).length() == 0) {
            throw new IllegalArgumentException("invalid service name");
        }
        final String sService = FileHelper.toFilename(sServiceName);
        XmlElement xmlConfig = this.getConfig();
        if (xmlConfig == null) {
            throw new IllegalStateException("missing configuration");
        }
        SnapshotArchiver archiver = null;
        boolean fCustomArchiver = false;
        try {
            if (xmlConfig.getName().equals("directory-archiver")) {
                String sDirectory = xmlConfig.getSafeElement("archive-directory").getString().trim();
                File fileArchive = new File(new File(new File(sDirectory), sCluster), sService);
                archiver = new DirectorySnapshotArchiver(sClusterName, sServiceName, fileArchive);
            } else if (xmlConfig.getName().equals("custom-archiver")) {
                fCustomArchiver = true;
                archiver = (SnapshotArchiver)XmlHelper.createInstance(xmlConfig, Base.getContextClassLoader(), new XmlHelper.ParameterResolver(){

                    @Override
                    public Object resolveParameter(String sType, String sValue) {
                        switch (sValue) {
                            case "{cluster-name}": {
                                return sCluster;
                            }
                            case "{service-name}": {
                                return sService;
                            }
                        }
                        return sValue;
                    }
                }, SnapshotArchiver.class);
            }
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e, "Error creating " + (fCustomArchiver ? "custom" : "") + " SnapshotArchiver with config: " + String.valueOf(xmlConfig));
        }
        if (archiver == null) {
            throw new IllegalArgumentException("unknown snapshot archiver type: " + String.valueOf(xmlConfig));
        }
        return archiver;
    }

    @Override
    public void setConfig(XmlElement xml) {
        this.m_xmlConfig = xml;
    }

    @Override
    public XmlElement getConfig() {
        return this.m_xmlConfig;
    }

    public String toString() {
        return "ConfigurableSnapshotArchiverFactory";
    }
}

