/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.persistence;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.util.Base;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@Deprecated
public class ArchiverHelper {
    public static void allocateSnapshotPartitions(Map<Integer, Object[]> mapStores, int cPartitions) {
        try {
            if (mapStores == null || mapStores.size() == 0) {
                throw new IllegalArgumentException("You must supply a collected map of partitions");
            }
            int nMemberCount = mapStores.size();
            Object[] asStoresAll = ArchiverHelper.getDistinctStores(mapStores);
            if (asStoresAll.length != cPartitions) {
                String sMessage = "Number of unique stores is " + asStoresAll.length + " and does not match partition count of " + cPartitions + ". This means that some stores are missing or the snapshot is corrupted.";
                Logger.err(sMessage);
                Logger.warn("Dumping distinct store list because of error");
                for (String string : asStoresAll) {
                    Logger.warn(string);
                }
                throw new IllegalArgumentException(sMessage);
            }
            boolean fSharedPartitions = true;
            for (Map.Entry<Integer, Object[]> entry : mapStores.entrySet()) {
                Object[] asSorted = entry.getValue();
                if (asSorted != null) {
                    Arrays.sort(asSorted);
                }
                if (Arrays.equals(asSorted, asStoresAll)) continue;
                fSharedPartitions = false;
                break;
            }
            if (fSharedPartitions) {
                int nFairShare = cPartitions / nMemberCount;
                int nPartitionStart = 0;
                int nEntriesProcessed = 0;
                for (Map.Entry<Integer, Object[]> entry : mapStores.entrySet()) {
                    int nLastPartition = ++nEntriesProcessed < nMemberCount ? nPartitionStart + nFairShare - 1 : cPartitions - 1;
                    String[] asStores = new String[nLastPartition - nPartitionStart + 1];
                    int j = 0;
                    for (int i = nPartitionStart; i <= nLastPartition; ++i) {
                        asStores[j++] = asStoresAll[i];
                    }
                    mapStores.put(entry.getKey(), asStores);
                    nPartitionStart += nFairShare;
                }
            } else {
                for (int iPart = 0; iPart < cPartitions; ++iPart) {
                    Set<Integer> setMembers = ArchiverHelper.getMembersOwningPartition(mapStores, asStoresAll[iPart]);
                    while (setMembers.size() > 1) {
                        int nMemberMaxPartitions = -1;
                        int n = -1;
                        for (Integer nMember : setMembers) {
                            int nMax = mapStores.get(nMember).length;
                            if (nMax <= n) continue;
                            n = nMax;
                            nMemberMaxPartitions = nMember;
                        }
                        Object[] aoStores = mapStores.get(nMemberMaxPartitions);
                        mapStores.put(nMemberMaxPartitions, ArchiverHelper.removeStoreFromArray((String)asStoresAll[iPart], aoStores));
                        setMembers = ArchiverHelper.getMembersOwningPartition(mapStores, (String)asStoresAll[iPart]);
                    }
                }
            }
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e, "Error in ArchiverHelper.allocateSnapshotPartitions");
        }
    }

    public static Set<Integer> getMembersOwningPartition(Map<Integer, Object[]> mapStores, String sStore) {
        HashSet<Integer> setMembers = new HashSet<Integer>();
        block0: for (Map.Entry<Integer, Object[]> entry : mapStores.entrySet()) {
            Object[] aoValue = entry.getValue();
            if (aoValue == null) continue;
            for (int i = 0; i < aoValue.length; ++i) {
                if (!sStore.equals(aoValue[i])) continue;
                setMembers.add(entry.getKey());
                continue block0;
            }
        }
        return setMembers;
    }

    private static String[] getDistinctStores(Map<Integer, Object[]> mapStores) {
        HashSet<String> setStores = new HashSet<String>();
        for (Map.Entry<Integer, Object[]> entry : mapStores.entrySet()) {
            Object[] aoValue = entry.getValue();
            if (aoValue == null) continue;
            for (int i = 0; i < aoValue.length; ++i) {
                String sStore = (String)aoValue[i];
                if (setStores.contains(sStore)) continue;
                setStores.add(sStore);
            }
        }
        Object[] asResults = setStores.toArray(new String[setStores.size()]);
        Arrays.sort(asResults);
        return asResults;
    }

    private static Object[] removeStoreFromArray(String sStoreToRemove, Object[] aoArray) {
        Object[] aoNewArray = new Object[aoArray.length - 1];
        int i = 0;
        for (int j = 0; j < aoArray.length; ++j) {
            String sStore = (String)aoArray[j];
            if (sStore.equals(sStoreToRemove)) continue;
            aoNewArray[i++] = sStore;
        }
        return aoNewArray;
    }

    public static class DirectoryFileFilter
    implements FileFilter {
        public static final FileFilter INSTANCE = new DirectoryFileFilter();

        @Override
        public boolean accept(File file) {
            return file.isDirectory();
        }
    }
}

