/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.persistence;

import com.oracle.coherence.common.base.Blocking;
import com.oracle.coherence.common.base.Collector;
import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.common.base.Timeout;
import com.oracle.coherence.persistence.AsyncPersistenceException;
import com.oracle.coherence.persistence.ConcurrentAccessException;
import com.oracle.coherence.persistence.FatalAccessException;
import com.oracle.coherence.persistence.OfflinePersistenceInfo;
import com.oracle.coherence.persistence.PersistenceException;
import com.oracle.coherence.persistence.PersistenceManager;
import com.oracle.coherence.persistence.PersistenceStatistics;
import com.oracle.coherence.persistence.PersistenceTools;
import com.oracle.coherence.persistence.PersistentStore;
import com.oracle.coherence.persistence.PersistentStoreInfo;
import com.tangosol.internal.util.DaemonPool;
import com.tangosol.io.ByteArrayReadBuffer;
import com.tangosol.io.FileHelper;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.net.GuardSupport;
import com.tangosol.net.cache.KeyAssociation;
import com.tangosol.persistence.AbstractPersistenceEnvironment;
import com.tangosol.persistence.AbstractPersistenceManager;
import com.tangosol.persistence.AbstractPersistenceTools;
import com.tangosol.persistence.CachePersistenceHelper;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.NullImplementation;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class AbstractPersistenceManager<PS extends AbstractPersistentStore>
extends Base
implements PersistenceManager<ReadBuffer> {
    protected static final long[] NO_LONGS = new long[0];
    protected static final String[] NO_STRINGS = AbstractPersistenceEnvironment.NO_STRINGS;
    private static final int MAGIC = 1785214773;
    private static final int VERSION = 0;
    protected static final int STORE_STATE_INITIALIZED = 0;
    protected static final int STORE_STATE_OPENING = 1;
    protected static final int STORE_STATE_READY = 2;
    protected static final int STORE_STATE_CLOSED = 4;
    protected final File f_dirData;
    protected final File f_dirTrash;
    protected final File f_dirLock;
    protected final String f_sName;
    protected final ConcurrentMap<String, PS> f_mapStores = new ConcurrentHashMap<String, PS>();
    protected final Set<Task> f_setTasks = new HashSet<Task>();
    protected volatile boolean m_fReleased;
    protected AbstractPersistenceEnvironment m_env;
    protected DaemonPool m_pool;

    public AbstractPersistenceManager(File fileData, File fileTrash, String sName) throws IOException {
        this.f_dirData = FileHelper.ensureDir(fileData);
        this.f_dirTrash = fileTrash;
        this.f_dirLock = new File(this.f_dirData, ".lock");
        this.f_sName = sName == null ? fileData.toString() : sName;
    }

    @Override
    public String getName() {
        return this.f_sName;
    }

    public PS createStore(String sId) {
        sId = this.validatePersistentStoreId(sId);
        return (PS)this.f_mapStores.computeIfAbsent(sId, s -> {
            this.ensureActive();
            return this.instantiatePersistentStore((String)s);
        });
    }

    @Override
    public PersistentStore<ReadBuffer> open(String sId, PersistentStore<ReadBuffer> storeFrom) {
        return this.open(sId, storeFrom, (Collector<Object>)null);
    }

    @Override
    public PersistentStore<ReadBuffer> open(String sId, PersistentStore<ReadBuffer> storeFrom, Collector<Object> collector) {
        PersistentStore store = this.createStore(sId);
        if (!((AbstractPersistentStore)store).isOpen() && (storeFrom == null || storeFrom.isOpen())) {
            ((AbstractPersistentStore)store).submitOpen(storeFrom, collector);
        }
        return store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(String sId) {
        this.ensureActive();
        sId = this.validatePersistentStoreId(sId);
        AbstractPersistentStore store = (AbstractPersistentStore)this.f_mapStores.remove(sId);
        if (store != null) {
            if (!store.f_setDeletedIds.isEmpty()) {
                Set<Long> set = store.f_setDeletedIds;
                synchronized (set) {
                    long cMillis = 10000L;
                    GuardSupport.heartbeat(cMillis << 1);
                    try (Timeout t = Timeout.after(cMillis);){
                        while (!store.f_setDeletedIds.isEmpty()) {
                            Blocking.wait(store.f_setDeletedIds, 100L);
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                        Logger.finest("Store close interrupted while waiting for delete extent tasks to finish: " + store.getId());
                    }
                }
                GuardSupport.heartbeat();
            }
            store.release();
        }
    }

    @Override
    public boolean delete(String sId, boolean fSafe) {
        this.ensureActive();
        sId = this.validatePersistentStoreId(sId);
        AbstractPersistentStore store = (AbstractPersistentStore)this.f_mapStores.remove(sId);
        if (store == null) {
            store = this.instantiatePersistentStore(sId);
        }
        return store.delete(fSafe);
    }

    @Override
    public boolean isEmpty(String sId) {
        File file = new File(this.f_dirData, sId);
        File[] aFile = file.listFiles();
        return aFile != null && aFile.length == 0;
    }

    @Override
    public boolean contains(String sGUID) {
        return PersistenceManager.super.contains(sGUID);
    }

    @Override
    public String[] listOpen() {
        if (this.f_mapStores.isEmpty()) {
            return NO_STRINGS;
        }
        Set setIds = this.f_mapStores.keySet();
        return setIds.toArray(new String[setIds.size()]);
    }

    @Override
    public PersistentStoreInfo[] listStoreInfo() {
        File[] aFiles = this.f_dirData.listFiles();
        if (aFiles == null) {
            return new PersistentStoreInfo[0];
        }
        ArrayList<PersistentStoreInfo> listInfo = new ArrayList<PersistentStoreInfo>();
        for (File fileEnv : aFiles) {
            String sName = fileEnv.getName();
            PersistentStoreInfo info = null;
            if (fileEnv.isDirectory() && !this.f_dirLock.getName().equals(sName)) {
                if (this.isEmpty(sName)) {
                    info = new PersistentStoreInfo(sName, true);
                } else {
                    try {
                        Properties prop = this.readMetadata(fileEnv);
                        if (this.isMetadataComplete(prop) && !this.isMetadataCompatible(prop)) {
                            Logger.warn("Skipping incompatible persistent store directory \"" + String.valueOf(fileEnv) + "\"");
                        } else {
                            info = new PersistentStoreInfo(sName, false);
                        }
                    }
                    catch (IOException e) {
                        listInfo.add(new PersistentStoreInfo(sName, false));
                    }
                }
            }
            if (info == null) continue;
            listInfo.add(info);
        }
        return listInfo.toArray(new PersistentStoreInfo[listInfo.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(String sId, ReadBuffer.BufferInput in) throws IOException {
        AbstractPersistentStore store;
        this.ensureActive();
        AbstractPersistenceManager abstractPersistenceManager = this;
        synchronized (abstractPersistenceManager) {
            if (this.f_mapStores.containsKey(sId)) {
                throw new ConcurrentAccessException("the store \"" + sId + "\" is currently open");
            }
            store = (AbstractPersistentStore)this.open(sId, (PersistentStore<ReadBuffer>)null);
            store.lockWrite();
        }
        try {
            int cbKey;
            if (in.readInt() != 1785214773) {
                throw new StreamCorruptedException("the data stream is unrecognized");
            }
            byte nVersion = in.readByte();
            if (nVersion > 0) {
                throw new IOException("the data stream is a newer version (" + nVersion + ") than is supported by this manager (0)");
            }
            while ((cbKey = in.readInt()) >= 0) {
                int cbValue = in.readInt();
                if (cbValue < 0) {
                    throw new StreamCorruptedException();
                }
                long lExtentId = in.readLong();
                byte[] ab = new byte[cbKey + cbValue];
                try {
                    in.readFully(ab, 0, cbKey);
                }
                catch (EOFException e) {
                    throw new EOFException("Expected " + cbKey + " bytes for key but reached end of stream");
                }
                try {
                    in.readFully(ab, cbKey, cbValue);
                }
                catch (EOFException e) {
                    throw new EOFException("Expected " + cbValue + " bytes for value but reached end of stream");
                }
                ByteArrayReadBuffer bufKey = new ByteArrayReadBuffer(ab, 0, cbKey);
                ByteArrayReadBuffer bufValue = new ByteArrayReadBuffer(ab, cbKey, cbValue);
                store.ensureExtent(lExtentId);
                store.store(lExtentId, bufKey, bufValue, (Object)null);
            }
        }
        catch (IOException e) {
            this.delete(sId, false);
            throw e;
        }
        finally {
            store.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String sId, WriteBuffer.BufferOutput out) throws IOException {
        block8: {
            this.ensureActive();
            AbstractPersistentStore store = (AbstractPersistentStore)this.open(sId, (PersistentStore<ReadBuffer>)null);
            store.lockRead();
            try {
                out.writeInt(1785214773);
                out.writeByte(0);
                IOException[] ae = new IOException[1];
                store.iterate((lExtentId, bufKey, bufValue) -> {
                    try {
                        out.writeInt(bufKey.length());
                        out.writeInt(bufValue.length());
                        out.writeLong(lExtentId);
                        bufKey.writeTo(out);
                        bufValue.writeTo(out);
                    }
                    catch (IOException e) {
                        ae[0] = e;
                        return false;
                    }
                    return true;
                });
                if (ae[0] == null) {
                    out.writeInt(-1);
                    break block8;
                }
                throw ae[0];
            }
            finally {
                store.unlockRead();
                try {
                    out.flush();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        this.m_fReleased = true;
        boolean fInterrupted = false;
        Set<Task> set = NullImplementation.getSet();
        Iterator iterator = this.f_setTasks;
        synchronized (iterator) {
            try {
                long ldtEnd = AbstractPersistenceManager.getSafeTimeMillis() + 5000L;
                while (!this.f_setTasks.isEmpty()) {
                    Blocking.wait(this.f_setTasks, 1000L);
                    if (AbstractPersistenceManager.getSafeTimeMillis() < ldtEnd) continue;
                    break;
                }
            }
            catch (InterruptedException e) {
                fInterrupted = true;
            }
            if (!this.f_setTasks.isEmpty()) {
                set = new HashSet<Task>(this.f_setTasks);
            }
        }
        for (Task task : set) {
            try {
                task.cancel(null);
            }
            catch (Throwable throwable) {}
        }
        for (AbstractPersistentStore store : this.f_mapStores.values()) {
            store.release();
        }
        this.f_mapStores.clear();
        AbstractPersistenceEnvironment env = this.m_env;
        if (env != null) {
            env.onReleased(this);
        }
        if (fInterrupted) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PersistenceTools getPersistenceTools() {
        int nVersion;
        int cPartitions;
        String[] asGUIDs = this.listOpenStores();
        if (asGUIDs.length == 0) {
            throw new IllegalArgumentException("snapshot must have at least one GUID");
        }
        String sGUID = asGUIDs[0];
        PersistentStore<ReadBuffer> store = null;
        try {
            store = this.open(sGUID, (PersistentStore<ReadBuffer>)null);
            cPartitions = CachePersistenceHelper.getPartitionCount(store);
            nVersion = CachePersistenceHelper.getPersistenceVersion(store);
        }
        finally {
            if (store != null) {
                this.close(sGUID);
            }
        }
        OfflinePersistenceInfo info = new OfflinePersistenceInfo(cPartitions, this.getStorageFormat(), false, this.list(), this.getStorageVersion(), this.getImplVersion(), nVersion);
        return this.instantiatePersistenceTools(info);
    }

    @Override
    public void writeSafe(String sId) {
        this.ensureActive();
        sId = this.validatePersistentStoreId(sId);
        AbstractPersistentStore store = (AbstractPersistentStore)this.f_mapStores.get(sId);
        if (store != null) {
            store.copyToTrash();
        }
    }

    public String toString() {
        return ClassHelper.getSimpleName(this.getClass()) + "(" + (String)(this.f_sName == null ? "" : this.f_sName + ", ") + (this.m_fReleased ? "in" : "") + "active)";
    }

    protected Properties getMetadata() {
        Properties props = new Properties();
        props.setProperty("implementation.version", String.valueOf(this.getImplVersion()));
        props.setProperty("storage.format", this.getStorageFormat());
        props.setProperty("storage.version", String.valueOf(this.getStorageVersion()));
        return props;
    }

    protected Properties readMetadata(File fileDir) throws IOException {
        return CachePersistenceHelper.readMetadata(fileDir);
    }

    protected void writeMetadata(File fileDir) throws IOException {
        CachePersistenceHelper.writeMetadata(fileDir, this.getMetadata());
    }

    protected boolean isMetadataComplete(Properties prop) {
        return CachePersistenceHelper.isMetadataComplete(prop);
    }

    protected boolean isMetadataCompatible(Properties prop) {
        return CachePersistenceHelper.isMetadataCompatible(prop, this.getImplVersion(), this.getStorageFormat(), this.getStorageVersion());
    }

    protected abstract int getImplVersion();

    protected abstract String getStorageFormat();

    protected abstract int getStorageVersion();

    protected String[] list() {
        PersistentStoreInfo[] aInfos = this.listStoreInfo();
        int cSize = aInfos.length;
        String[] asNames = new String[cSize];
        for (int i = 0; i < cSize; ++i) {
            asNames[i] = aInfos[i].getId();
        }
        return asNames;
    }

    protected PersistenceException ensurePersistenceException(Throwable eCause) {
        return this.ensurePersistenceException(eCause, null);
    }

    protected PersistenceException ensurePersistenceException(Throwable eCause, String sMessage) {
        AbstractPersistenceEnvironment env = this.m_env;
        PersistenceException e = env == null ? CachePersistenceHelper.ensurePersistenceException(eCause, sMessage) : env.ensurePersistenceException(eCause, sMessage);
        e.initPersistenceManager(this);
        return e;
    }

    protected void ensureActive() {
        if (this.m_fReleased) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " has been released.");
        }
    }

    protected File ensureTrashDir() throws IOException {
        if (!this.f_dirTrash.exists()) {
            Logger.info("Creating persistence trash directory \"" + this.f_dirTrash.getAbsolutePath() + "\"");
            FileHelper.ensureDir(this.f_dirTrash);
        }
        return this.f_dirTrash;
    }

    protected void submitTasks(List<? extends Task> listTasks) {
        boolean fPool = this.m_pool == null;
        for (Task task : listTasks) {
            if (fPool) {
                task.register();
                continue;
            }
            task.execute();
        }
        if (fPool) {
            this.m_pool.add(new BatchTasks(listTasks));
        }
    }

    public String validatePersistentStoreId(String sId) {
        if (sId == null) {
            throw new IllegalArgumentException("null identifier");
        }
        if ((sId = sId.trim()).length() == 0) {
            throw new IllegalArgumentException("empty identifier");
        }
        return sId;
    }

    protected String[] listOpenStores() {
        String[] asNames = this.f_dirData.list((dir, name) -> {
            File fileEnv = new File(dir, name);
            File[] afile = fileEnv.listFiles();
            return fileEnv.isDirectory() && !this.f_dirLock.getName().equals(fileEnv.getName()) && afile != null && afile.length > 0;
        });
        return asNames == null ? NO_STRINGS : asNames;
    }

    protected void submitTask(Task task) {
        DaemonPool pool = this.getDaemonPool();
        if (pool == null) {
            this.executeTask(task);
        } else {
            this.addTask(task);
            pool.add(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTask(Task task) {
        Set<Task> set = this.f_setTasks;
        synchronized (set) {
            this.f_setTasks.add(task);
        }
    }

    protected void executeTask(Task task) {
        task.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void executeTaskExclusive(Task task) {
        ArrayList<AbstractPersistentStore> list = new ArrayList<AbstractPersistentStore>(this.f_mapStores.size());
        try {
            for (AbstractPersistentStore store : this.f_mapStores.values()) {
                store.lockWrite();
                list.add(store);
            }
            this.executeTask(task);
        }
        finally {
            for (AbstractPersistentStore store : list) {
                store.unlockWrite();
            }
        }
    }

    protected abstract PS instantiatePersistentStore(String var1);

    protected abstract PersistenceTools instantiatePersistenceTools(OfflinePersistenceInfo var1);

    public DaemonPool getDaemonPool() {
        return this.m_pool;
    }

    public void setDaemonPool(DaemonPool pool) {
        this.m_pool = pool;
    }

    public File getDataDirectory() {
        return this.f_dirData;
    }

    public File getTrashDirectory() {
        return this.f_dirTrash;
    }

    protected File getLockDirectory() {
        try {
            return FileHelper.ensureDir(this.f_dirLock);
        }
        catch (IOException iOException) {
            return this.f_dirLock;
        }
    }

    protected AbstractPersistenceEnvironment getPersistenceEnvironment() {
        return this.m_env;
    }

    protected void setPersistenceEnvironment(AbstractPersistenceEnvironment env) {
        this.m_env = env;
        if (env == null) {
            this.setDaemonPool(null);
        } else {
            this.setDaemonPool(env.getDaemonPool());
        }
    }

    public Map<String, PS> getPersistentStoreMap() {
        return this.f_mapStores;
    }

    public abstract class AbstractPersistentStore
    extends Base
    implements PersistentStore<ReadBuffer> {
        protected final String f_sId;
        protected final File f_dirStore;
        protected final File f_fileLock;
        protected volatile int m_nState;
        protected FileLock m_lockFile;
        protected final ReadWriteLock f_lock = new ReentrantReadWriteLock();
        protected final Set<Long> f_setExtentIds = new CopyOnWriteArraySet<Long>();
        protected final Set<Long> f_setDeletedIds = new CopyOnWriteArraySet<Long>();

        public AbstractPersistentStore(String sId) {
            if (sId == null) {
                throw new IllegalArgumentException("null identifier");
            }
            this.f_sId = sId;
            this.f_dirStore = new File(AbstractPersistenceManager.this.f_dirData, sId);
            this.f_fileLock = new File(AbstractPersistenceManager.this.getLockDirectory(), sId + ".lck");
            this.f_dirStore.mkdir();
        }

        @Override
        public String getId() {
            return this.f_sId;
        }

        @Override
        public boolean isOpen() {
            File[] aFile = this.f_dirStore.listFiles();
            return aFile != null && aFile.length > 0 && this.isReady();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean ensureExtent(long lExtentId) {
            if (!this.f_setExtentIds.contains(lExtentId)) {
                this.ensureReady();
                if (this.f_setDeletedIds.contains(lExtentId)) {
                    Set<Long> set = this.f_setDeletedIds;
                    synchronized (set) {
                        long cMillis = 10000L;
                        GuardSupport.heartbeat(cMillis << 1);
                        try (Timeout t = Timeout.after(cMillis);){
                            while (this.f_setDeletedIds.contains(lExtentId)) {
                                Blocking.wait(this.f_setDeletedIds, 100L);
                            }
                        }
                        catch (InterruptedException e) {
                            Thread.interrupted();
                        }
                    }
                    GuardSupport.heartbeat();
                }
                this.lockWrite();
                try {
                    boolean bl = this.ensureExtentInternal(lExtentId);
                    return bl;
                }
                finally {
                    this.unlockWrite();
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void deleteExtent(long lExtentId) {
            Long LId = lExtentId;
            if (this.f_setExtentIds.contains(LId)) {
                this.ensureReady();
                this.lockWrite();
                try {
                    if (this.f_setExtentIds.remove(LId) && this.f_setDeletedIds.add(LId)) {
                        AbstractPersistenceManager.this.submitTask(new DeleteExtentTask(LId));
                    }
                }
                finally {
                    this.unlockWrite();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void moveExtent(long lOldExtentId, long lNewExtentId) {
            Long LId = lOldExtentId;
            boolean fLock = this.f_setExtentIds.contains(LId);
            try {
                this.ensureReady();
                if (fLock) {
                    this.lockWrite();
                    this.moveExtentInternal(lOldExtentId, lNewExtentId);
                    this.f_setExtentIds.remove(LId);
                }
            }
            finally {
                this.ensureExtent(lNewExtentId);
                if (fLock) {
                    this.unlockWrite();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void truncateExtent(long lExtentId) {
            Long LId = lExtentId;
            if (this.f_setExtentIds.contains(LId)) {
                this.ensureReady();
                this.lockWrite();
                try {
                    this.truncateExtentInternal(lExtentId);
                }
                finally {
                    this.unlockWrite();
                }
            }
        }

        @Override
        public long[] extents() {
            if (this.f_setExtentIds.isEmpty()) {
                return NO_LONGS;
            }
            Object[] aL = this.f_setExtentIds.toArray();
            int cL = aL.length;
            long[] al = new long[cL];
            for (int i = 0; i < cL; ++i) {
                al[i] = (Long)aL[i];
            }
            return al;
        }

        @Override
        public AutoCloseable exclusively() {
            this.ensureReady();
            this.lockWrite();
            return this.instantiateExclusiveClosable();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ReadBuffer load(long lExtentId, ReadBuffer bufKey) {
            if (bufKey == null) {
                throw new IllegalArgumentException("null key");
            }
            this.ensureReady();
            this.lockRead();
            try {
                this.validateExtentId(lExtentId);
                ReadBuffer readBuffer = this.loadInternal(lExtentId, bufKey);
                return readBuffer;
            }
            finally {
                this.unlockRead();
            }
        }

        @Override
        public boolean containsExtent(long lExtentId) {
            return this.f_setExtentIds.contains(lExtentId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void store(long lExtentId, ReadBuffer bufKey, ReadBuffer bufValue, Object oToken) {
            block12: {
                if (bufKey == null) {
                    throw new IllegalArgumentException("null key");
                }
                if (bufValue == null) {
                    throw new IllegalArgumentException("null value");
                }
                this.ensureReady();
                this.lockRead();
                try {
                    this.validateExtentId(lExtentId);
                    if (oToken instanceof BatchTask) {
                        ((BatchTask)oToken).store(lExtentId, bufKey, bufValue);
                        break block12;
                    }
                    boolean fAbort = oToken == null;
                    boolean fCommit = fAbort;
                    if (fCommit) {
                        oToken = this.begin();
                    }
                    try {
                        this.storeInternal(lExtentId, bufKey, bufValue, oToken);
                        if (fCommit) {
                            this.commit(oToken);
                            fAbort = false;
                        }
                    }
                    finally {
                        if (fAbort) {
                            this.abort(oToken);
                        }
                    }
                }
                finally {
                    this.unlockRead();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void erase(long lExtentId, ReadBuffer bufKey, Object oToken) {
            block11: {
                if (bufKey == null) {
                    throw new IllegalArgumentException("null key");
                }
                this.ensureReady();
                this.lockRead();
                try {
                    this.validateExtentId(lExtentId);
                    if (oToken instanceof BatchTask) {
                        ((BatchTask)oToken).erase(lExtentId, bufKey);
                        break block11;
                    }
                    boolean fAbort = oToken == null;
                    boolean fCommit = fAbort;
                    if (fCommit) {
                        oToken = this.begin();
                    }
                    try {
                        this.eraseInternal(lExtentId, bufKey, oToken);
                        if (fCommit) {
                            this.commit(oToken);
                            fAbort = false;
                        }
                    }
                    finally {
                        if (fAbort) {
                            this.abort(oToken);
                        }
                    }
                }
                finally {
                    this.unlockRead();
                }
            }
        }

        @Override
        public void iterate(PersistentStore.Visitor<ReadBuffer> visitor) {
            if (!this.isOpen()) {
                return;
            }
            this.ensureReady();
            this.lockRead();
            try {
                this.iterateInternal(visitor);
            }
            finally {
                this.unlockRead();
            }
        }

        @Override
        public Object begin() {
            this.ensureReady();
            this.lockRead();
            try {
                Object object = this.beginInternal();
                return object;
            }
            finally {
                this.unlockRead();
            }
        }

        @Override
        public Object begin(Collector<Object> collector, Object oReceipt) {
            return new BatchTask(this.begin(), collector, oReceipt);
        }

        @Override
        public void commit(Object oToken) {
            if (oToken instanceof List) {
                AbstractPersistenceManager.this.submitTasks((List)oToken);
            } else if (oToken instanceof BatchTask) {
                AbstractPersistenceManager.this.submitTask((BatchTask)oToken);
            } else {
                this.ensureReady();
                this.lockRead();
                try {
                    this.commitInternal(oToken);
                }
                finally {
                    this.unlockRead();
                }
            }
        }

        @Override
        public void abort(Object oToken) {
            if (oToken instanceof BatchTask) {
                ((BatchTask)oToken).abort(null);
            } else {
                try {
                    this.ensureReady();
                    this.lockRead();
                    try {
                        this.abortInternal(oToken);
                    }
                    finally {
                        this.unlockRead();
                    }
                }
                catch (Throwable e) {
                    Logger.finer("Caught an exception while aborting transaction for token \"" + String.valueOf(oToken) + "\":", e);
                }
            }
        }

        public void copyToTrash() {
            this.lockWrite();
            try {
                File dirStore;
                File dirTrash = AbstractPersistenceManager.this.f_dirTrash;
                if (dirTrash != null && !(dirStore = new File(dirTrash = AbstractPersistenceManager.this.ensureTrashDir(), this.f_sId)).exists() && this.isReady()) {
                    FileHelper.copyDir(this.f_dirStore, dirStore);
                }
            }
            catch (Throwable throwable) {
            }
            finally {
                this.unlockWrite();
            }
        }

        protected void submitOpen(PersistentStore<ReadBuffer> storeFrom, Collector<Object> collector) {
            this.setState(1);
            OpenTask task = new OpenTask(storeFrom, collector);
            if (collector == null || storeFrom == null) {
                AbstractPersistenceManager.this.executeTask(task);
            } else {
                AbstractPersistenceManager.this.submitTask(task);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean open(PersistentStore<ReadBuffer> storeFrom) {
            boolean fClosed = true;
            boolean fNew = false;
            this.lockWrite();
            try {
                if (this.isOpen()) {
                    boolean bl = false;
                    return bl;
                }
                if (!this.f_dirStore.exists()) {
                    if (!this.f_dirStore.mkdir() && !this.f_dirStore.exists()) {
                        throw this.ensurePersistenceException(new FatalAccessException("unable to create data directory \"" + String.valueOf(this.f_dirStore) + "\""));
                    }
                    fNew = true;
                } else if (this.f_dirStore.listFiles().length == 0) {
                    fNew = true;
                }
                if (!this.lockStorage()) {
                    throw this.ensurePersistenceException(new ConcurrentAccessException("unable to lock data directory \"" + String.valueOf(this.f_dirStore) + "\""));
                }
                if (!fNew) {
                    this.validateMetadata();
                }
                this.copyAndOpenInternal(storeFrom);
                try {
                    this.loadExtentIdsInternal(this.f_setExtentIds);
                }
                catch (Throwable t) {
                    if (storeFrom != null) {
                        this.delete(false);
                    }
                    throw this.ensurePersistenceException(t, "Error loading database for extend identifiers in directory \"" + String.valueOf(this.f_dirStore) + "\"");
                }
                try {
                    AbstractPersistenceManager.this.writeMetadata(this.f_dirStore);
                }
                catch (IOException e) {
                    throw this.ensurePersistenceException(new FatalAccessException("error writing metadata in directory \"" + String.valueOf(this.f_dirStore) + "\"", e));
                }
                fClosed = false;
                this.setState(2);
            }
            finally {
                if (fClosed) {
                    try {
                        this.releaseInternal();
                    }
                    catch (Throwable throwable) {}
                    this.setState(4);
                }
                this.unlockStorage();
                this.unlockWrite();
            }
            return fNew;
        }

        protected void release() {
            this.lockWrite();
            try {
                try {
                    this.releaseInternal();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.setState(4);
                this.f_setExtentIds.clear();
                this.f_setDeletedIds.clear();
            }
            finally {
                this.unlockWrite();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected boolean delete(boolean fSafe) {
            boolean fDeleted = false;
            this.lockWrite();
            try {
                boolean bl;
                this.release();
                if (!this.lockStorage()) return fDeleted;
                try {
                    File fileTrash = AbstractPersistenceManager.this.f_dirTrash;
                    if (fSafe && fileTrash != null) {
                        fileTrash = AbstractPersistenceManager.this.ensureTrashDir();
                        File fileMeta = new File(this.f_dirStore, "meta.properties");
                        if (fileMeta.exists()) {
                            FileHelper.moveDir(this.f_dirStore, new File(fileTrash, this.f_sId));
                        }
                    }
                    this.deleteInternal();
                    fDeleted = true;
                    this.unlockStorage();
                    bl = fDeleted && this.f_fileLock.delete();
                }
                catch (Throwable throwable) {
                    this.unlockStorage();
                    fDeleted = fDeleted && this.f_fileLock.delete();
                    try {
                        FileHelper.deleteDir(this.f_dirStore);
                        return fDeleted;
                    }
                    catch (IOException iOException) {
                        return fDeleted;
                    }
                }
                catch (Throwable throwable) {
                    this.unlockStorage();
                    fDeleted = fDeleted && this.f_fileLock.delete();
                    try {
                        FileHelper.deleteDir(this.f_dirStore);
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                fDeleted = bl;
                try {
                    FileHelper.deleteDir(this.f_dirStore);
                    return fDeleted;
                }
                catch (IOException iOException) {
                    return fDeleted;
                }
            }
            finally {
                this.unlockWrite();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void ensureReady() {
            while (!this.isReady()) {
                if (this.isClosed()) {
                    throw this.ensurePersistenceException(null, "Store (" + this.toString() + ") has been closed");
                }
                AbstractPersistentStore abstractPersistentStore = this;
                synchronized (abstractPersistentStore) {
                    try {
                        Blocking.wait(this, 10L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw this.ensurePersistenceException(e, "Interrupted while waiting for store to be opened");
                    }
                }
            }
        }

        protected boolean isReady() {
            return (this.m_nState & 2) != 0;
        }

        protected boolean isClosed() {
            return (this.m_nState & 4) != 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setState(int nState) {
            if (nState != this.m_nState) {
                AbstractPersistentStore abstractPersistentStore = this;
                synchronized (abstractPersistentStore) {
                    this.m_nState = nState;
                    this.notifyAll();
                }
            }
        }

        protected boolean isExclusive() {
            return ((ReentrantReadWriteLock.WriteLock)this.f_lock.writeLock()).isHeldByCurrentThread();
        }

        protected AutoCloseable instantiateExclusiveClosable() {
            return this::unlockWrite;
        }

        public String toString() {
            return ClassHelper.getSimpleName(this.getClass()) + "(" + this.f_sId + ", " + String.valueOf(this.f_dirStore) + ")";
        }

        protected PersistenceException ensurePersistenceException(Throwable eCause) {
            return this.ensurePersistenceException(eCause, null);
        }

        protected PersistenceException ensurePersistenceException(Throwable eCause, String sMessage) {
            PersistenceException e = AbstractPersistenceManager.this.ensurePersistenceException(eCause, sMessage);
            e.initPersistentStore(this);
            return e;
        }

        protected final boolean lockStorage() {
            FileLock lock = this.m_lockFile;
            if (lock == null) {
                this.m_lockFile = lock = FileHelper.lockFile(this.f_fileLock);
            }
            return lock != null;
        }

        protected final void unlockStorage() {
            FileLock lock = this.m_lockFile;
            if (lock != null) {
                FileHelper.unlockFile(lock);
                this.m_lockFile = null;
            }
        }

        protected final void lockRead() {
            this.f_lock.readLock().lock();
        }

        protected final void unlockRead() {
            this.f_lock.readLock().unlock();
        }

        protected final void lockWrite() {
            this.f_lock.writeLock().lock();
        }

        protected final void unlockWrite() {
            this.f_lock.writeLock().unlock();
        }

        protected void validateExtentId(long lExtentId) {
            Long LId = lExtentId;
            if (!this.f_setExtentIds.contains(LId)) {
                throw new IllegalArgumentException("unknown extent identifier: " + lExtentId + " for store: " + this.getId());
            }
        }

        protected void validateMetadata() {
            try {
                Properties prop = AbstractPersistenceManager.this.readMetadata(this.f_dirStore);
                if (!AbstractPersistenceManager.this.isMetadataComplete(prop)) {
                    throw this.ensurePersistenceException(new FatalAccessException("the data in directory \"" + String.valueOf(this.f_dirStore) + "\" appears to be incomplete"));
                }
                if (!AbstractPersistenceManager.this.isMetadataCompatible(prop)) {
                    throw this.ensurePersistenceException(new FatalAccessException("the data in directory \"" + String.valueOf(this.f_dirStore) + "\" is incompatible with this manager"));
                }
            }
            catch (IOException e) {
                throw this.ensurePersistenceException(new FatalAccessException("error reading metadata in directory \"" + String.valueOf(this.f_dirStore) + "\"", e));
            }
        }

        protected boolean ensureExtentInternal(long lExtentId) {
            Long LId = lExtentId;
            if (!this.f_setExtentIds.contains(LId)) {
                if (this.f_setDeletedIds.contains(LId)) {
                    throw new IllegalArgumentException("deleted extent identifier: " + lExtentId);
                }
                if (this.f_setExtentIds.add(LId)) {
                    this.createExtentInternal(lExtentId);
                }
                return true;
            }
            return false;
        }

        protected void copyAndOpenInternal(PersistentStore<ReadBuffer> storeFrom) {
            this.openInternal();
            if (storeFrom != null) {
                ((AbstractPersistentStore)storeFrom).validateMetadata();
                Object oToken = this.beginInternal();
                try {
                    for (long lExtentId2 : storeFrom.extents()) {
                        this.ensureExtentInternal(lExtentId2);
                    }
                    storeFrom.iterate((long lExtentId, R bufKey, R bufValue) -> {
                        this.storeInternal(lExtentId, (ReadBuffer)bufKey, (ReadBuffer)bufValue, oToken);
                        return true;
                    });
                }
                catch (PersistenceException e) {
                    this.abortInternal(oToken);
                    this.delete(false);
                    throw e;
                }
                this.commitInternal(oToken);
            }
        }

        protected abstract void openInternal();

        protected abstract void releaseInternal();

        protected abstract boolean deleteInternal();

        protected abstract void loadExtentIdsInternal(Set<Long> var1);

        protected abstract void createExtentInternal(long var1);

        protected abstract void deleteExtentInternal(long var1);

        protected void moveExtentInternal(long lOldExtentId, long lNewExtentId) {
            Object oToken = this.begin();
            try {
                this.iterate((long lExtentId, ReadBuffer bufKey, ReadBuffer bufValue) -> {
                    if (lExtentId == lOldExtentId) {
                        this.store(lNewExtentId, (ReadBuffer)bufKey, (ReadBuffer)bufValue, oToken);
                    }
                    return true;
                });
            }
            catch (PersistenceException e) {
                this.abort(oToken);
                throw e;
            }
            this.commit(oToken);
        }

        protected abstract void truncateExtentInternal(long var1);

        protected abstract ReadBuffer loadInternal(long var1, ReadBuffer var3);

        protected abstract void storeInternal(long var1, ReadBuffer var3, ReadBuffer var4, Object var5);

        protected abstract void eraseInternal(long var1, ReadBuffer var3, Object var4);

        protected abstract void iterateInternal(PersistentStore.Visitor<ReadBuffer> var1);

        protected abstract Object beginInternal();

        protected abstract void commitInternal(Object var1);

        protected abstract void abortInternal(Object var1);

        public File getDataDirectory() {
            return this.f_dirStore;
        }

        protected class DeleteExtentTask
        extends Task
        implements KeyAssociation {
            protected final Long f_LExtentId;

            public DeleteExtentTask(Long LExtentId) {
                this.f_LExtentId = LExtentId;
            }

            @Override
            public Object getAssociatedKey() {
                return AbstractPersistentStore.this.getId();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                block6: {
                    AbstractPersistentStore store = AbstractPersistentStore.this;
                    store.lockWrite();
                    try {
                        if (!store.f_setDeletedIds.remove(this.f_LExtentId)) break block6;
                        store.deleteExtentInternal(this.f_LExtentId);
                        Set<Long> set = store.f_setDeletedIds;
                        synchronized (set) {
                            store.f_setDeletedIds.notifyAll();
                        }
                    }
                    finally {
                        store.unlockWrite();
                    }
                }
            }
        }

        protected class BatchTask
        extends Task
        implements KeyAssociation {
            protected final Object f_oToken;
            protected final Collector<Object> f_collector;
            protected final Object f_oReceipt;
            protected final List<com.tangosol.persistence.AbstractPersistenceManager$AbstractPersistentStore.BatchTask.Operation> f_listOps;

            public BatchTask(Object oToken, Collector<Object> collector, Object oReceipt) {
                this.f_listOps = new ArrayList<com.tangosol.persistence.AbstractPersistenceManager$AbstractPersistentStore.BatchTask.Operation>();
                this.f_oToken = oToken;
                this.f_collector = collector;
                this.f_oReceipt = oReceipt;
            }

            public void store(long lExtentId, ReadBuffer bufKey, ReadBuffer bufValue) {
                this.f_listOps.add((com.tangosol.persistence.AbstractPersistenceManager$AbstractPersistentStore.BatchTask.Operation)new StoreOperation(lExtentId, bufKey, bufValue));
            }

            public void erase(long lExtentId, ReadBuffer bufKey) {
                this.f_listOps.add((com.tangosol.persistence.AbstractPersistenceManager$AbstractPersistentStore.BatchTask.Operation)new EraseOperation(lExtentId, bufKey));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void abort(Throwable eCause) {
                Object oReceipt = this.f_oReceipt;
                try {
                    AbstractPersistentStore.this.abort(this.f_oToken);
                    AsyncPersistenceException eAsync = new AsyncPersistenceException("\"transaction aborted: \"" + String.valueOf(this.f_oToken), eCause).initReceipt(this.f_oReceipt);
                    oReceipt = AbstractPersistentStore.this.ensurePersistenceException(eAsync);
                }
                finally {
                    this.notifyCollector(oReceipt, true);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                AbstractPersistentStore store = AbstractPersistentStore.this;
                try {
                    store.lockRead();
                    try {
                        for (Operation operation : this.f_listOps) {
                            operation.run();
                        }
                        AbstractPersistentStore.this.commit(this.f_oToken);
                    }
                    finally {
                        store.unlockRead();
                    }
                    this.notifyCollector(this.f_oReceipt, true);
                }
                catch (Throwable e) {
                    this.abort(e);
                }
            }

            @Override
            public void notifyCanceled(Throwable eCause) {
                this.abort(eCause);
            }

            @Override
            public Object getAssociatedKey() {
                return AbstractPersistentStore.this.getId();
            }

            protected void notifyCollector(Object oItem, boolean fFlush) {
                if (this.f_collector != null) {
                    try {
                        this.f_collector.add(oItem);
                        if (fFlush) {
                            this.f_collector.flush();
                        }
                    }
                    catch (Throwable e) {
                        Logger.err("Error adding an item to collector \"" + String.valueOf(this.f_collector) + "\":", e);
                    }
                }
            }

            /*
             * Signature claims super is com.tangosol.persistence.AbstractPersistenceManager$AbstractPersistentStore.BatchTask.Operation, not com.tangosol.persistence.AbstractPersistenceManager$AbstractPersistentStore$BatchTask$Operation - discarding signature.
             */
            protected class StoreOperation
            extends Operation {
                protected final ReadBuffer f_bufValue;

                public StoreOperation(long lExtentId, ReadBuffer bufKey, ReadBuffer bufValue) {
                    super(lExtentId, bufKey);
                    this.f_bufValue = bufValue;
                }

                @Override
                public void run() {
                    AbstractPersistentStore.this.store(this.f_lExtentId, this.f_bufKey, this.f_bufValue, BatchTask.this.f_oToken);
                }
            }

            /*
             * Signature claims super is com.tangosol.persistence.AbstractPersistenceManager$AbstractPersistentStore.BatchTask.Operation, not com.tangosol.persistence.AbstractPersistenceManager$AbstractPersistentStore$BatchTask$Operation - discarding signature.
             */
            protected class EraseOperation
            extends Operation {
                public EraseOperation(long lExtentId, ReadBuffer bufKey) {
                    super(lExtentId, bufKey);
                }

                @Override
                public void run() {
                    AbstractPersistentStore.this.erase(this.f_lExtentId, this.f_bufKey, BatchTask.this.f_oToken);
                }
            }

            protected abstract class Operation
            extends Base
            implements Runnable {
                protected final long f_lExtentId;
                protected final ReadBuffer f_bufKey;

                public Operation(long lExtentId, ReadBuffer bufKey) {
                    this.f_lExtentId = lExtentId;
                    this.f_bufKey = bufKey;
                }
            }
        }

        protected class OpenTask
        extends Task
        implements KeyAssociation {
            protected final PersistentStore<ReadBuffer> f_storeFrom;
            protected final Collector<Object> f_collector;

            public OpenTask(PersistentStore<ReadBuffer> storeFrom, Collector<Object> collector) {
                this.f_storeFrom = storeFrom;
                this.f_collector = collector;
            }

            @Override
            public Object getAssociatedKey() {
                return this.f_storeFrom == null ? AbstractPersistentStore.this.getId() : this.f_storeFrom.getId();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                AbstractPersistentStore store = AbstractPersistentStore.this;
                PersistenceException eFailure = null;
                try {
                    boolean fNewStore = store.open(this.f_storeFrom);
                    if (fNewStore) {
                        Logger.info("Created persistent store " + FileHelper.getPath(store.f_dirStore) + (String)(this.f_storeFrom == null ? "" : " from " + String.valueOf(this.f_storeFrom)));
                    }
                }
                catch (PersistenceException e) {
                    if (this.f_collector == null) {
                        AbstractPersistenceManager.this.close(store.getId());
                        throw e;
                    }
                    eFailure = store.ensurePersistenceException(new AsyncPersistenceException("Error in opening store", (Throwable)e).initReceipt(store.getId()));
                }
                finally {
                    if (this.f_collector != null) {
                        if (eFailure == null) {
                            this.f_collector.add(store.getId());
                        } else {
                            AbstractPersistenceManager.this.close(store.getId());
                            this.f_collector.add(eFailure);
                        }
                    }
                }
            }
        }
    }

    public abstract class Task
    extends Base
    implements Runnable {
        protected boolean f_canceled;

        public abstract void execute();

        public final synchronized void cancel(Throwable eCause) {
            if (this.f_canceled) {
                return;
            }
            try {
                this.notifyCanceled(eCause);
            }
            finally {
                this.f_canceled = true;
                this.notifyCompleted();
            }
        }

        protected void register() {
            AbstractPersistenceManager.this.addTask(this);
        }

        protected void notifyCanceled(Throwable eCause) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyCompleted() {
            Set<Task> set;
            Set<Task> set2 = set = AbstractPersistenceManager.this.f_setTasks;
            synchronized (set2) {
                set.remove(this);
                if (set.isEmpty()) {
                    set.notifyAll();
                }
            }
        }

        @Override
        public final synchronized void run() {
            if (this.f_canceled) {
                return;
            }
            try {
                this.execute();
            }
            finally {
                this.notifyCompleted();
            }
        }
    }

    protected static class BatchTasks
    implements Runnable,
    KeyAssociation {
        protected final List<Runnable> f_listTasks;
        protected final Object f_oAssociation;

        protected BatchTasks(List<Runnable> listTasks) {
            this.f_listTasks = listTasks;
            this.f_oAssociation = listTasks.isEmpty() ? null : ((KeyAssociation)((Object)listTasks.iterator().next())).getAssociatedKey();
        }

        @Override
        public void run() {
            for (Runnable task : this.f_listTasks) {
                task.run();
            }
        }

        @Override
        public Object getAssociatedKey() {
            return this.f_oAssociation;
        }
    }

    protected abstract class AbstractPersistenceSnapshotTools
    extends AbstractPersistenceTools {
        protected final File f_dirSnapshot;

        public AbstractPersistenceSnapshotTools(File dirSnapshot, OfflinePersistenceInfo info) {
            super(info);
            this.f_dirSnapshot = dirSnapshot;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PersistenceStatistics getStatistics() {
            String[] asFileList = this.f_info.getGUIDs();
            String sCurrentGUID = null;
            PersistenceStatistics stats = new PersistenceStatistics();
            AbstractPersistenceTools.StatsVisitor visitor = new AbstractPersistenceTools.StatsVisitor(stats);
            for (int i = 0; i < asFileList.length; ++i) {
                sCurrentGUID = asFileList[i];
                if (AbstractPersistenceManager.this.isEmpty(sCurrentGUID)) continue;
                try {
                    PersistentStore<ReadBuffer> store = AbstractPersistenceManager.this.open(sCurrentGUID, (PersistentStore<ReadBuffer>)null);
                    this.validateStoreSealed(store);
                    visitor.setCaches(CachePersistenceHelper.getCacheNames(store));
                    store.iterate(CachePersistenceHelper.instantiatePersistenceVisitor(visitor));
                    continue;
                }
                finally {
                    AbstractPersistenceManager.this.close(sCurrentGUID);
                }
            }
            return stats;
        }

        protected void validateStoreSealed(String sCurrentGUID) {
            try {
                PersistentStore<ReadBuffer> store = AbstractPersistenceManager.this.open(sCurrentGUID, (PersistentStore<ReadBuffer>)null);
                this.validateStoreSealed(store);
            }
            finally {
                AbstractPersistenceManager.this.close(sCurrentGUID);
            }
        }

        protected void validateStoreSealed(PersistentStore<ReadBuffer> store) {
            if (!CachePersistenceHelper.isSealed(store)) {
                throw CachePersistenceHelper.ensurePersistenceException(new IllegalStateException("Store " + store.getId() + " was not sealed correctly"));
            }
        }
    }
}

