/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.topic;

import com.oracle.coherence.common.base.Exceptions;
import com.tangosol.internal.net.topic.impl.paged.model.PagedPosition;
import com.tangosol.io.AbstractEvolvable;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.FlowControl;
import com.tangosol.net.topic.NamedTopic;
import com.tangosol.net.topic.Position;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.ValueExtractor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public interface Subscriber<V>
extends AutoCloseable {
    public CompletableFuture<Element<V>> receive();

    public CompletableFuture<List<Element<V>>> receive(int var1);

    public int[] getChannels();

    default public boolean isOwner(int nChannel) {
        int[] anChannel;
        for (int c : anChannel = this.getChannels()) {
            if (c != nChannel) continue;
            return true;
        }
        return false;
    }

    public int getChannelCount();

    public FlowControl getFlowControl();

    @Override
    public void close();

    public void heartbeat();

    public boolean isActive();

    public void onClose(Runnable var1);

    default public CommitResult commit(int nChannel, Position position) {
        return this.commit(Collections.singletonMap(nChannel, position)).get(nChannel);
    }

    public CompletableFuture<CommitResult> commitAsync(int var1, Position var2);

    default public Map<Integer, CommitResult> commit(Map<Integer, Position> mapPositions) {
        try {
            return this.commitAsync(mapPositions).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw Exceptions.ensureRuntimeException(e);
        }
    }

    public CompletableFuture<Map<Integer, CommitResult>> commitAsync(Map<Integer, Position> var1);

    default public Optional<Position> getLastCommitted(int nChannel) {
        return Optional.ofNullable(this.getLastCommitted().get(nChannel));
    }

    public Map<Integer, Position> getLastCommitted();

    public Position seek(int var1, Position var2);

    default public Position seekAndCommit(int nChannel, Position position) {
        Position positionNew = this.seek(nChannel, position);
        if (positionNew != null) {
            this.commit(nChannel, positionNew);
        }
        return positionNew;
    }

    public Map<Integer, Position> seek(Map<Integer, Position> var1);

    default public Map<Integer, Position> seekAndCommit(Map<Integer, Position> mapPosition) {
        Map<Integer, Position> map = this.seek(mapPosition);
        if (map != null && !map.isEmpty()) {
            this.commit(map);
        }
        return map;
    }

    public Position seek(int var1, Instant var2);

    default public Position seekAndCommit(int nChannel, Instant timestamp) {
        Position position = this.seek(nChannel, timestamp);
        if (position != null) {
            this.commit(nChannel, position);
        }
        return position;
    }

    public Map<Integer, Position> seekToHead(int ... var1);

    public Map<Integer, Position> seekToTail(int ... var1);

    default public Map<Integer, Position> seekToTailAndCommit(int ... anChannel) {
        Map<Integer, Position> mapPosition = this.seekToTail(anChannel);
        if (mapPosition != null && !mapPosition.isEmpty()) {
            this.commit(mapPosition);
        }
        return mapPosition;
    }

    default public Optional<Position> getHead(int nChannel) {
        return Optional.ofNullable(this.getHeads().get(nChannel));
    }

    public Map<Integer, Position> getHeads();

    default public Optional<Position> getTail(int nChannel) {
        return Optional.ofNullable(this.getTails().get(nChannel));
    }

    public Map<Integer, Position> getTails();

    public <T> NamedTopic<T> getNamedTopic();

    public int getRemainingMessages();

    public int getRemainingMessages(int var1);

    public static <V> Name<V> inGroup(String sName) {
        return Name.inGroup(sName);
    }

    public static <V> CompleteOnEmpty<V> completeOnEmpty() {
        return CompleteOnEmpty.enabled();
    }

    public static <V> ChannelOwnershipListeners<V> withListener(ChannelOwnershipListener ... aListener) {
        return ChannelOwnershipListeners.of(aListener);
    }

    public static <V, U> Convert<V, U> withConverter(ValueExtractor<? super V, U> extractor) {
        return Convert.using(extractor);
    }

    public static <V> Filtered<V> withFilter(Filter<? super V> filter) {
        return Filtered.by(filter);
    }

    public static class CommitResult
    extends AbstractEvolvable
    implements PortableObject,
    ExternalizableLite {
        public static final int DATA_VERSION = 1;
        public static final CommitResult NOTHING_TO_COMMIT = new CommitResult(-1, null, CommitResultStatus.NothingToCommit);
        private int m_nChannel;
        private Position m_position;
        private CommitResultStatus m_status;
        private Throwable m_throwable;

        public CommitResult() {
        }

        public CommitResult(int nChannel, Position position, CommitResultStatus status) {
            this(nChannel, position, status, null);
        }

        public CommitResult(int nChannel, Position position, Throwable throwable) {
            this(nChannel, position, CommitResultStatus.Rejected, throwable);
        }

        public CommitResult(int nChannel, Position position, CommitResultStatus status, Throwable throwable) {
            this.m_nChannel = nChannel;
            this.m_position = position;
            this.m_status = status;
            this.m_throwable = throwable;
        }

        public OptionalInt getChannel() {
            return this.m_nChannel < 0 ? OptionalInt.empty() : OptionalInt.of(this.m_nChannel);
        }

        public Optional<Position> getPosition() {
            return Optional.ofNullable(this.m_position);
        }

        public CommitResultStatus getStatus() {
            return this.m_status;
        }

        public Optional<Throwable> getError() {
            return Optional.ofNullable(this.m_throwable);
        }

        public boolean isSuccess() {
            return this.m_status != CommitResultStatus.Rejected;
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            this.m_nChannel = in.readInt();
            this.m_position = (Position)ExternalizableHelper.readObject(in);
            this.m_status = (CommitResultStatus)((Object)ExternalizableHelper.readObject(in));
            this.m_throwable = (Throwable)ExternalizableHelper.readObject(in);
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            out.writeInt(this.m_nChannel);
            ExternalizableHelper.writeObject(out, this.m_position);
            ExternalizableHelper.writeObject(out, (Object)this.m_status);
            ExternalizableHelper.writeObject(out, this.m_throwable);
        }

        @Override
        public int getImplVersion() {
            return 1;
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            this.m_nChannel = in.readInt(0);
            this.m_position = (Position)in.readObject(1);
            this.m_status = (CommitResultStatus)((Object)in.readObject(2));
            this.m_throwable = (Throwable)in.readObject(3);
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            out.writeInt(0, this.m_nChannel);
            out.writeObject(1, this.m_position);
            out.writeObject(2, (Object)this.m_status);
            out.writeObject(3, this.m_throwable);
        }

        public String toString() {
            return "CommitResult(channel=" + this.m_nChannel + ", position=" + String.valueOf(this.m_position) + ", status=" + String.valueOf((Object)this.m_status) + ", throwable=" + String.valueOf(this.m_throwable) + ")";
        }
    }

    public static class Name<V>
    implements Option<V, V>,
    ExternalizableLite,
    PortableObject {
        private String m_sName;

        public Name() {
        }

        protected Name(String sName) {
            this.m_sName = sName;
        }

        public static <V> Name<V> of(String sName) {
            return new Name<V>(sName);
        }

        public static <V> Name<V> inGroup(String sName) {
            return new Name<V>(sName);
        }

        public String getName() {
            return this.m_sName;
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            this.m_sName = ExternalizableHelper.readSafeUTF(in);
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            ExternalizableHelper.writeSafeUTF(out, this.m_sName);
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            this.m_sName = in.readString(0);
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            out.writeString(0, this.m_sName);
        }
    }

    public static class CompleteOnEmpty<V>
    implements Option<V, V>,
    ExternalizableLite,
    PortableObject {
        protected static final CompleteOnEmpty<?> INSTANCE = new CompleteOnEmpty();

        @Override
        public void readExternal(DataInput in) throws IOException {
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
        }

        public static <V> CompleteOnEmpty<V> enabled() {
            return INSTANCE;
        }
    }

    public static class ChannelOwnershipListeners<V>
    implements Option<V, V> {
        private static final ChannelOwnershipListeners EMPTY = new ChannelOwnershipListeners(Collections.emptyList());
        private final List<ChannelOwnershipListener> m_listListener;

        private ChannelOwnershipListeners(List<ChannelOwnershipListener> listListener) {
            this.m_listListener = listListener;
        }

        public List<ChannelOwnershipListener> getListeners() {
            return this.m_listListener;
        }

        public static <V> ChannelOwnershipListeners<V> of(ChannelOwnershipListener ... aListener) {
            return new ChannelOwnershipListeners<V>(Arrays.asList(aListener));
        }

        public static <V> ChannelOwnershipListeners<V> withListener(ChannelOwnershipListener ... aListener) {
            return ChannelOwnershipListeners.of(aListener);
        }

        public static <V> ChannelOwnershipListeners<V> none() {
            return EMPTY;
        }
    }

    public static interface ChannelOwnershipListener {
        public void onChannelsAssigned(Set<Integer> var1);

        public void onChannelsRevoked(Set<Integer> var1);

        public void onChannelsLost(Set<Integer> var1);
    }

    public static class Convert<V, U>
    implements Option<V, U>,
    ExternalizableLite,
    PortableObject {
        private ValueExtractor<? super V, U> m_extractor;

        public Convert() {
        }

        protected Convert(ValueExtractor<? super V, U> extractor) {
            this.m_extractor = extractor;
        }

        public ValueExtractor<? super V, U> getExtractor() {
            return this.m_extractor;
        }

        public static <V, U> Convert<V, U> using(ValueExtractor<? super V, U> extractor) {
            return new Convert<V, U>(extractor);
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            this.m_extractor = (ValueExtractor)ExternalizableHelper.readObject(in);
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            ExternalizableHelper.writeObject(out, this.m_extractor);
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            this.m_extractor = (ValueExtractor)in.readObject(0);
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            out.writeObject(0, this.m_extractor);
        }
    }

    public static class Filtered<V>
    implements Option<V, V>,
    ExternalizableLite,
    PortableObject {
        private Filter<? super V> m_filter;

        public Filtered() {
        }

        protected Filtered(Filter<? super V> filter) {
            this.m_filter = filter;
        }

        public Filter<? super V> getFilter() {
            return this.m_filter;
        }

        public static <V> Filtered<V> by(Filter<? super V> filter) {
            return new Filtered<V>(filter);
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            this.m_filter = (Filter)ExternalizableHelper.readObject(in);
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            ExternalizableHelper.writeObject(out, this.m_filter);
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            this.m_filter = (Filter)in.readObject(0);
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            out.writeObject(0, this.m_filter);
        }
    }

    public static interface Channel {
        public int getId();

        public Position getHead();

        public Position getLastCommit();

        public long getCommitCount();

        public Position getLastReceived();

        public long getReceiveCount();

        public long getPolls();

        public Position getFirstPolled();

        public long getFirstPolledTimestamp();

        public Position getLastPolled();

        public long getLastPolledTimestamp();

        public boolean isEmpty();

        public boolean isOwned();

        public int getOwnedCode();

        public long getReceived();

        public double getReceivedMeanRate();

        public double getReceivedOneMinuteRate();

        public double getReceivedFiveMinuteRate();

        public double getReceivedFifteenMinuteRate();

        public static class EmptyChannel
        implements Channel {
            private final int f_nId;

            public EmptyChannel(int nId) {
                this.f_nId = nId;
            }

            @Override
            public int getId() {
                return this.f_nId;
            }

            @Override
            public Position getHead() {
                return PagedPosition.NULL_POSITION;
            }

            @Override
            public Position getLastCommit() {
                return PagedPosition.NULL_POSITION;
            }

            @Override
            public long getCommitCount() {
                return 0L;
            }

            @Override
            public Position getLastReceived() {
                return PagedPosition.NULL_POSITION;
            }

            @Override
            public long getReceiveCount() {
                return 0L;
            }

            @Override
            public long getPolls() {
                return 0L;
            }

            @Override
            public Position getFirstPolled() {
                return PagedPosition.NULL_POSITION;
            }

            @Override
            public long getFirstPolledTimestamp() {
                return 0L;
            }

            @Override
            public Position getLastPolled() {
                return PagedPosition.NULL_POSITION;
            }

            @Override
            public long getLastPolledTimestamp() {
                return 0L;
            }

            @Override
            public boolean isEmpty() {
                return true;
            }

            @Override
            public boolean isOwned() {
                return false;
            }

            @Override
            public int getOwnedCode() {
                return 0;
            }

            @Override
            public long getReceived() {
                return 0L;
            }

            @Override
            public double getReceivedMeanRate() {
                return 0.0;
            }

            @Override
            public double getReceivedOneMinuteRate() {
                return 0.0;
            }

            @Override
            public double getReceivedFiveMinuteRate() {
                return 0.0;
            }

            @Override
            public double getReceivedFifteenMinuteRate() {
                return 0.0;
            }
        }
    }

    public static interface Option<V, U> {
        public static final Option NULL_OPTION = new Option(){};

        public static <V, U> Option<V, U> nullOption() {
            return NULL_OPTION;
        }
    }

    public static enum CommitResultStatus {
        Committed,
        AlreadyCommitted,
        Rejected,
        Unowned,
        NothingToCommit;

    }

    public static interface Element<V> {
        public V getValue();

        public Binary getBinaryValue();

        public int getChannel();

        public Position getPosition();

        public Instant getTimestamp();

        default public CommitResult commit() {
            try {
                return this.commitAsync().get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw Exceptions.ensureRuntimeException(e);
            }
        }

        public CompletableFuture<CommitResult> commitAsync();
    }

    public static interface Id {
    }
}

