/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.ssl;

import com.tangosol.net.PasswordProvider;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;

public interface KeyStoreLoader {
    public KeyStore load(String var1, PasswordProvider var2) throws GeneralSecurityException, IOException;

    default public boolean isEnabled() {
        return true;
    }

    default public boolean isRefreshable() {
        return true;
    }

    default public KeyStore createKeyStore(String sType) throws GeneralSecurityException, IOException {
        return KeyStore.getInstance(sType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public KeyStore load(String sType, PasswordProvider password, PrivateKey key, PasswordProvider keyPassword, Certificate[] aCert) throws GeneralSecurityException, IOException {
        KeyStore keyStore;
        char[] acPassword = null;
        char[] acKeyPassword = null;
        try {
            KeyStore keyStore2 = this.createKeyStore(sType);
            char[] cArray = acPassword = password == null ? null : password.get();
            if (acPassword == null) {
                acPassword = new char[]{};
            }
            keyStore2.load(null, acPassword);
            if (key != null) {
                if (aCert == null) {
                    aCert = new Certificate[]{};
                }
                char[] cArray2 = acKeyPassword = keyPassword == null ? null : keyPassword.get();
                if (acKeyPassword == null) {
                    acKeyPassword = new char[]{};
                }
                keyStore2.setKeyEntry("key", key, acKeyPassword, aCert);
            } else if (aCert != null) {
                for (int i = 0; i < aCert.length; ++i) {
                    keyStore2.setCertificateEntry("cert-" + i, aCert[i]);
                }
            }
            keyStore = keyStore2;
        }
        catch (Throwable throwable) {
            PasswordProvider.reset(acPassword, acKeyPassword);
            throw throwable;
        }
        PasswordProvider.reset(acPassword, acKeyPassword);
        return keyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public KeyStore load(String sType, PasswordProvider password, Certificate[] aCert) throws GeneralSecurityException, IOException {
        KeyStore keyStore;
        char[] acPassword = null;
        try {
            char[] cArray = acPassword = password == null ? null : password.get();
            if (acPassword == null) {
                acPassword = new char[]{};
            }
            KeyStore keyStore2 = this.createKeyStore(sType);
            keyStore2.load(null, acPassword);
            for (int i = 0; i < aCert.length; ++i) {
                keyStore2.setCertificateEntry("cert-" + i, aCert[i]);
            }
            keyStore = keyStore2;
        }
        catch (Throwable throwable) {
            PasswordProvider.reset(new char[][]{acPassword});
            throw throwable;
        }
        PasswordProvider.reset(new char[][]{acPassword});
        return keyStore;
    }
}

