/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.ssl;

import com.tangosol.internal.net.ssl.PemReader;
import com.tangosol.net.PasswordProvider;
import com.tangosol.net.ssl.PrivateKeyLoader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.util.Objects;

public abstract class AbstractPrivateKeyLoader
implements PrivateKeyLoader {
    protected final String m_sName;

    protected AbstractPrivateKeyLoader(String sName) {
        this.m_sName = sName;
    }

    @Override
    public PrivateKey load(PasswordProvider provider) throws GeneralSecurityException, IOException {
        InputStream in = this.getInputStream();
        return in == null ? null : PemReader.readPrivateKey(in, provider);
    }

    public String getName() {
        return this.m_sName;
    }

    protected abstract InputStream getInputStream() throws IOException;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractPrivateKeyLoader that = (AbstractPrivateKeyLoader)o;
        return Objects.equals(this.m_sName, that.m_sName);
    }

    public int hashCode() {
        return Objects.hash(this.m_sName);
    }

    public String toString() {
        return this.m_sName;
    }

    protected void safeClose(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

