/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.ssl;

import com.tangosol.net.PasswordProvider;
import com.tangosol.net.ssl.KeyStoreLoader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Objects;

public abstract class AbstractKeyStoreLoader
implements KeyStoreLoader {
    protected final String m_sName;

    protected AbstractKeyStoreLoader(String sName) {
        this.m_sName = sName;
    }

    public String getName() {
        return this.m_sName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyStore load(String sType, PasswordProvider password) throws GeneralSecurityException, IOException {
        KeyStore keyStore = this.createKeyStore(sType);
        InputStream in = this.getInputStream();
        char[] achPassword = null;
        try {
            achPassword = password.get();
            if (achPassword != null && achPassword.length == 0) {
                achPassword = null;
            }
            keyStore.load(in, achPassword);
        }
        catch (Throwable throwable) {
            PasswordProvider.reset(new char[][]{achPassword});
            this.safeClose(in);
            throw throwable;
        }
        PasswordProvider.reset(new char[][]{achPassword});
        this.safeClose(in);
        return keyStore;
    }

    protected abstract InputStream getInputStream() throws IOException;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractKeyStoreLoader that = (AbstractKeyStoreLoader)o;
        return Objects.equals(this.m_sName, that.m_sName);
    }

    public int hashCode() {
        return Objects.hash(this.m_sName);
    }

    public String toString() {
        return this.m_sName;
    }

    protected void safeClose(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

