/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.ssl;

import com.tangosol.internal.net.ssl.PemReader;
import com.tangosol.net.ssl.CertificateLoader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.util.Objects;

public abstract class AbstractCertificateLoader
implements CertificateLoader {
    protected String m_sName;

    protected AbstractCertificateLoader(String sName) {
        this.m_sName = sName;
    }

    @Override
    public Certificate[] load() throws GeneralSecurityException, IOException {
        InputStream in = this.getInputStream();
        return in == null ? new Certificate[]{} : PemReader.readCertificates(in);
    }

    @Override
    public boolean isEnabled() {
        return this.m_sName != null && !this.m_sName.isEmpty();
    }

    public String getName() {
        return this.m_sName;
    }

    protected abstract InputStream getInputStream() throws IOException;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractCertificateLoader that = (AbstractCertificateLoader)o;
        return Objects.equals(this.m_sName, that.m_sName);
    }

    public int hashCode() {
        return Objects.hash(this.m_sName);
    }

    public String toString() {
        return this.m_sName;
    }

    protected void safeClose(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

