/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.security;

import com.tangosol.net.BackingMapContext;
import com.tangosol.util.BinaryEntry;
import javax.security.auth.Subject;

public interface StorageAccessAuthorizer {
    public static final int REASON_UNKNOWN = 0;
    public static final int REASON_GET = 1;
    public static final int REASON_PUT = 2;
    public static final int REASON_REMOVE = 3;
    public static final int REASON_KEYSET = 4;
    public static final int REASON_ENTRYSET = 5;
    public static final int REASON_VALUES = 6;
    public static final int REASON_CLEAR = 7;
    public static final int REASON_INVOKE = 8;
    public static final int REASON_AGGREGATE = 9;
    public static final int REASON_INDEX_ADD = 10;
    public static final int REASON_INDEX_REMOVE = 11;
    public static final int REASON_LISTENER_ADD = 12;
    public static final int REASON_LISTENER_REMOVE = 13;
    public static final int REASON_TRIGGER_ADD = 14;
    public static final int REASON_TRIGGER_REMOVE = 15;
    public static final int REASON_INTERCEPTOR_ADD = 16;
    public static final int REASON_INTERCEPTOR_REMOVE = 17;

    public void checkRead(BinaryEntry var1, Subject var2, int var3);

    public void checkWrite(BinaryEntry var1, Subject var2, int var3);

    public void checkReadAny(BackingMapContext var1, Subject var2, int var3);

    public void checkWriteAny(BackingMapContext var1, Subject var2, int var3);

    public static String reasonToString(int nReason) {
        switch (nReason) {
            case 1: {
                return "get";
            }
            case 2: {
                return "put";
            }
            case 3: {
                return "remove";
            }
            case 4: {
                return "keySet";
            }
            case 5: {
                return "entrySet";
            }
            case 6: {
                return "values";
            }
            case 8: {
                return "invoke";
            }
            case 9: {
                return "aggregate";
            }
            case 10: {
                return "addIndex";
            }
            case 12: {
                return "addListener";
            }
            case 13: {
                return "removeListener";
            }
            case 11: {
                return "removeIndex";
            }
            case 14: {
                return "addTrigger";
            }
            case 15: {
                return "removeTrigger";
            }
            case 16: {
                return "addInterceptor";
            }
            case 17: {
                return "removeInterceptor";
            }
            case 7: {
                return "clear";
            }
        }
        return "<unknown>";
    }
}

