/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.queue;

import com.tangosol.internal.net.queue.model.QueueKey;
import com.tangosol.net.NamedCache;
import com.tangosol.net.NamedQueue;
import com.tangosol.net.QueueService;
import com.tangosol.net.queue.QueueStatistics;
import com.tangosol.util.CollectionListener;
import com.tangosol.util.Filter;
import com.tangosol.util.ObservableCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;

public class WrapperNamedQueue<E>
implements NamedQueue<E> {
    private final Queue<E> m_queue;
    private final String m_sName;
    private final QueueService m_service;

    public WrapperNamedQueue(String sName) {
        this(new LinkedList(), sName, null);
    }

    public WrapperNamedQueue(Queue<E> queue, String sName) {
        this(queue, sName, null);
    }

    public WrapperNamedQueue(Queue<E> queue, String sName, QueueService service) {
        this.m_queue = queue;
        this.m_sName = queue instanceof NamedCache && sName == null ? ((NamedQueue)queue).getName() : sName;
        this.m_service = queue instanceof NamedCache ? ((NamedQueue)queue).getService() : service;
    }

    public Queue<E> getQueue() {
        return this.m_queue;
    }

    @Override
    public String getName() {
        return this.m_sName;
    }

    @Override
    public void destroy() {
        Queue<E> queue = this.getQueue();
        if (queue instanceof NamedQueue) {
            ((NamedQueue)queue).destroy();
        }
    }

    @Override
    public QueueService getService() {
        Queue<E> queue;
        QueueService service = this.m_service;
        if (service == null && (queue = this.getQueue()) instanceof NamedQueue) {
            service = ((NamedQueue)queue).getService();
        }
        return service;
    }

    @Override
    public boolean isActive() {
        Queue<E> queue = this.getQueue();
        if (queue instanceof NamedQueue) {
            return ((NamedQueue)queue).isActive();
        }
        return true;
    }

    @Override
    public void release() {
        Queue<E> queue = this.getQueue();
        if (queue instanceof NamedQueue) {
            ((NamedQueue)queue).release();
        }
    }

    @Override
    public boolean isReleased() {
        Queue<E> queue = this.getQueue();
        if (queue instanceof NamedQueue) {
            return ((NamedQueue)queue).isReleased();
        }
        return true;
    }

    @Override
    public boolean isDestroyed() {
        Queue<E> queue = this.getQueue();
        if (queue instanceof NamedQueue) {
            return ((NamedQueue)queue).isDestroyed();
        }
        return true;
    }

    @Override
    public boolean add(E e) {
        return this.getQueue().add(e);
    }

    @Override
    public boolean offer(E e) {
        return this.getQueue().offer(e);
    }

    @Override
    public long append(E e) {
        return this.getQueue().offer(e) ? (long)this.getQueue().size() : Long.MIN_VALUE;
    }

    @Override
    public E remove() {
        return this.getQueue().remove();
    }

    @Override
    public E poll() {
        return this.getQueue().poll();
    }

    @Override
    public E element() {
        return this.getQueue().element();
    }

    @Override
    public E peek() {
        return this.getQueue().peek();
    }

    @Override
    public int size() {
        return this.getQueue().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getQueue().isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.getQueue().contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.getQueue().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.getQueue().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.getQueue().toArray(a);
    }

    @Override
    public boolean remove(Object o) {
        return this.getQueue().remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.getQueue().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.getQueue().addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.getQueue().removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.getQueue().retainAll(c);
    }

    @Override
    public void clear() {
        this.getQueue().clear();
    }

    @Override
    public QueueStatistics getQueueStatistics() {
        Queue<E> queue = this.getQueue();
        if (queue instanceof NamedQueue) {
            return ((NamedQueue)queue).getQueueStatistics();
        }
        return null;
    }

    @Override
    public int getQueueNameHash() {
        Queue<E> queue = this.getQueue();
        if (queue instanceof NamedQueue) {
            return ((NamedQueue)queue).getQueueNameHash();
        }
        return QueueKey.calculateQueueHash(this.getName());
    }

    @Override
    public void addListener(CollectionListener<? super E> listener) {
        Queue<E> queue = this.getQueue();
        if (queue instanceof ObservableCollection) {
            ((ObservableCollection)((Object)queue)).addListener(listener);
        }
    }

    @Override
    public void removeListener(CollectionListener<? super E> listener) {
        Queue<E> queue = this.getQueue();
        if (queue instanceof ObservableCollection) {
            ((ObservableCollection)((Object)queue)).removeListener(listener);
        }
    }

    @Override
    public void addListener(CollectionListener<? super E> listener, Filter<E> filter, boolean fLite) {
        Queue<E> queue = this.getQueue();
        if (queue instanceof ObservableCollection) {
            ((ObservableCollection)((Object)queue)).addListener(listener, filter, fLite);
        }
    }

    @Override
    public void removeListener(CollectionListener<? super E> listener, Filter<E> filter) {
        Queue<E> queue = this.getQueue();
        if (queue instanceof ObservableCollection) {
            ((ObservableCollection)((Object)queue)).removeListener(listener, filter);
        }
    }

    @Override
    public int hashCode() {
        return this.getQueue().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return this.getQueue().equals(o);
    }

    public String toString() {
        return "WrapperNamedQueue {" + this.getDescription() + "}";
    }

    protected String getDescription() {
        Queue<E> queue = this.getQueue();
        return "Queue {class=" + queue.getClass().getName() + ", size=" + queue.size();
    }
}

